/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.unet.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.exception.ValidatorException;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class AssociateEIPWithShareBandwidthParam
extends BaseRequestParam {
    @NotEmpty(message="region can not be empty")
    @UcloudParam(value="Region")
    private @NotEmpty(message="region can not be empty") String region;
    @NotEmpty(message="shareBandwidthId can not be empty")
    @UcloudParam(value="ShareBandwidthId")
    private @NotEmpty(message="shareBandwidthId can not be empty") String shareBandwidthId;
    @NotNull(message="eipIds can not be null")
    private @NotNull(message="eipIds can not be null") List<String> eipIds;

    @UcloudParam(value="EIPIds")
    public List<Param> checkEIPIds() throws ValidatorException {
        ArrayList<Param> list = new ArrayList<Param>();
        if (this.getEipIds() != null && !this.getEipIds().isEmpty()) {
            List<String> eipIds = this.getEipIds();
            int len = eipIds.size();
            for (int i = 0; i < len; ++i) {
                String eipId = eipIds.get(i);
                if (StringUtils.isBlank((CharSequence)eipId)) {
                    throw new ValidatorException("eipId[" + i + "] can not be empty");
                }
                list.add(new Param("EIPIds." + i, (Object)eipId));
            }
        }
        return list;
    }

    public AssociateEIPWithShareBandwidthParam(@NotEmpty(message="region can not be empty") @NotEmpty(message="region can not be empty") String region, @NotEmpty(message="shareBandwidthId can not be empty") @NotEmpty(message="shareBandwidthId can not be empty") String shareBandwidthId, @NotEmpty(message="eipIds can not be null") @NotEmpty(message="eipIds can not be null") List<String> eipIds) {
        super("AssociateEIPWithShareBandwidth");
        this.region = region;
        this.shareBandwidthId = shareBandwidthId;
        this.eipIds = eipIds;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getShareBandwidthId() {
        return this.shareBandwidthId;
    }

    public void setShareBandwidthId(String shareBandwidthId) {
        this.shareBandwidthId = shareBandwidthId;
    }

    public List<String> getEipIds() {
        return this.eipIds;
    }

    public void setEipIds(List<String> eipIds) {
        this.eipIds = eipIds;
    }
}

