/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.unet.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.exception.ValidatorException;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class CreateFirewallParam
extends BaseRequestParam {
    @UcloudParam(value="Region")
    @NotEmpty(message="region can not be empty")
    private @NotEmpty(message="region can not be empty") String region;
    @UcloudParam(value="Name")
    @NotEmpty(message="name can not be empty")
    private @NotEmpty(message="name can not be empty") String name;
    @UcloudParam(value="Tag")
    private String tag;
    @UcloudParam(value="Remark")
    private String remark;
    @NotNull(message="rule can not be empty")
    private @NotNull(message="rule can not be empty") List<Rule> rule;

    @UcloudParam(value="Rule")
    public List<Param> checkFirewallRule() throws ValidatorException {
        ArrayList<Param> list = new ArrayList<Param>();
        if (this.rule == null || this.rule.isEmpty()) {
            throw new ValidatorException("rule can not be empty");
        }
        List<Rule> rules = this.getRule();
        String exceptionFormat = "rule[%d].%s";
        int len = rules.size();
        for (int i = 0; i < len; ++i) {
            Rule rule = rules.get(i);
            if (rule == null) {
                throw new ValidatorException(String.format(exceptionFormat, i, " can not be null"));
            }
            if (StringUtils.isBlank((CharSequence)rule.getProtocol())) {
                throw new ValidatorException(String.format(exceptionFormat, i, "protocol can not be empty"));
            }
            if (rule.getPort() == null || rule.getPort() <= 0) {
                throw new ValidatorException(String.format(exceptionFormat, i, "port can not be null or value <= 0"));
            }
            if (StringUtils.isBlank((CharSequence)rule.getIp())) {
                throw new ValidatorException(String.format(exceptionFormat, i, "ip can not be empty"));
            }
            if (StringUtils.isBlank((CharSequence)rule.getPriority())) {
                throw new ValidatorException(String.format(exceptionFormat, i, "priority can not be empty"));
            }
            if (StringUtils.isBlank((CharSequence)rule.getAcceptOrNot())) {
                throw new ValidatorException(String.format(exceptionFormat, i, "acceptOrNot can not be empty"));
            }
            list.add(new Param("Rule." + i, (Object)rule.getRule()));
        }
        return list;
    }

    public CreateFirewallParam(@NotEmpty(message="region can not be empty") @NotEmpty(message="region can not be empty") String region, @NotNull(message="rule can not be empty") @NotNull(message="rule can not be empty") List<Rule> rule, @NotNull(message="name can not be empty") @NotNull(message="name can not be empty") String name) {
        super("CreateFirewall");
        this.region = region;
        this.rule = rule;
        this.name = name;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<Rule> getRule() {
        return this.rule;
    }

    public void setRule(List<Rule> rule) {
        this.rule = rule;
    }

    public static class Rule {
        private final String ruleFormat = "%s|%d|%s|%s|%s";
        private String rule;
        @NotEmpty(message="protocol can not be empty")
        private @NotEmpty(message="protocol can not be empty") String protocol;
        @NotNull(message="port can not be null")
        private @NotNull(message="port can not be null") Integer port;
        @NotEmpty(message="ip can not be empty")
        private @NotEmpty(message="ip can not be empty") String ip;
        @NotEmpty(message="acceptOrNot can not be empty")
        private @NotEmpty(message="acceptOrNot can not be empty") String acceptOrNot;
        @NotEmpty(message="priority can not be empty")
        private @NotEmpty(message="priority can not be empty") String priority;

        public Rule(@NotEmpty(message="protocol can not be empty") @NotEmpty(message="protocol can not be empty") String protocol, @NotNull(message="port can not be null") @NotNull(message="port can not be null") Integer port, @NotEmpty(message="ip can not be empty") @NotEmpty(message="ip can not be empty") String ip, @NotEmpty(message="acceptOrNot can not be empty") @NotEmpty(message="acceptOrNot can not be empty") String acceptOrNot, @NotEmpty(message="priority can not be empty") @NotEmpty(message="priority can not be empty") String priority) {
            this.protocol = protocol;
            this.port = port;
            this.ip = ip;
            this.acceptOrNot = acceptOrNot;
            this.priority = priority;
        }

        public String getRule() {
            this.rule = String.format("%s|%d|%s|%s|%s", this.protocol, this.port, this.ip, this.acceptOrNot, this.priority);
            return this.rule;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getAcceptOrNot() {
            return this.acceptOrNot;
        }

        public void setAcceptOrNot(String acceptOrNot) {
            this.acceptOrNot = acceptOrNot;
        }

        public String getPriority() {
            return this.priority;
        }

        public void setPriority(String priority) {
            this.priority = priority;
        }
    }
}

