/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.unet.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.exception.ValidatorException;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.StringUtils;

public class DescribeBandwidthUsageParam
extends BaseRequestParam {
    @UcloudParam(value="Region")
    @NotEmpty(message="region can not be empty")
    private @NotEmpty(message="region can not be empty") String region;
    @UcloudParam(value="Limit")
    private Integer limit;
    @UcloudParam(value="Offset")
    private Integer offset;
    private List<String> eipIds;

    @UcloudParam(value="EIPIds")
    public List<Param> checkEIPIds() throws ValidatorException {
        ArrayList<Param> list = new ArrayList<Param>();
        if (this.getEipIds() != null && !this.getEipIds().isEmpty()) {
            List<String> eipIds = this.getEipIds();
            int len = eipIds.size();
            for (int i = 0; i < len; ++i) {
                String eipId = eipIds.get(i);
                if (StringUtils.isBlank((CharSequence)eipId)) {
                    throw new ValidatorException("eipId[" + i + "] can not be empty");
                }
                list.add(new Param("EIP." + i, (Object)eipId));
            }
        }
        return list;
    }

    public DescribeBandwidthUsageParam(@NotEmpty(message="region can not be empty") @NotEmpty(message="region can not be empty") String region) {
        super("DescribeBandwidthUsage");
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public List<String> getEipIds() {
        return this.eipIds;
    }

    public void setEipIds(List<String> eipIds) {
        this.eipIds = eipIds;
    }
}

