/*
 * Decompiled with CFR 0.152.
 */
package com.ucloudrtclib.monitor;

import android.text.TextUtils;
import com.ucloudrtclib.a.f;
import com.ucloudrtclib.a.h;
import com.ucloudrtclib.a.i;
import com.ucloudrtclib.b.b;
import com.ucloudrtclib.c.c;
import com.ucloudrtclib.sdkengine.UCloudRtcSdkEnv;
import java.util.concurrent.ExecutorService;
import org.json.JSONException;
import org.json.JSONObject;

public class URTCLogReportManager {
    private static final String TAG = "URTCLogReportManager";
    private static URTCLogReportManager instance;
    public static boolean logPre;
    public static String statsReportUrl;
    public static String joinLeaveReportUrl;
    public static String operationUrl;
    public static String exceptionUrl;
    public static final int INVALID_VALUE = -1;
    public static final String INVALID_STRING_VALUE = "";
    public static final int LOG_JOIN_ROOM = 1;
    public static final int LOG_STATUS = 2;
    public static final int LOG_LEAVE_ROOM = 3;
    public static final int LOG_EXCEPTION = 4;
    public static final int LOG_OPERATION = 5;
    public static final int OPERATION_JOIN_ROOM = 1;
    public static final int OPERATION_LEAVE_ROOM = 2;
    public static final int OPERATION_PUSH_START = 3;
    public static final int OPERATION_PUSH_FINISH = 4;
    public static final int OPERATION_PULL_START = 5;
    public static final int OPERATION_PULL_FINISH = 6;
    public static final int OPERATION_OPEN_CAMERA = 7;
    public static final int OPERATION_CLOSE_CAMERA = 8;
    public static final int OPERATION_OPEN_MIC = 9;
    public static final int OPERATION_CLOSE_MIC = 10;
    public static final int OPERATION_RECORD_START = 11;
    public static final int OPERATION_RECORD_FINISH = 12;
    public static final int EXCEPTION_PUSH_ERROR = 1;
    public static final int EXCEPTION_PULL_ERROR = 2;
    public static final int EXCEPTION_CAMERA_ERROR = 3;
    public static final int EXCEPTION_MIC_ERROR = 4;
    public static final int EXCEPTION_SPEAKER_ERROR = 5;
    public static final int EXCEPTION_HIGH_CPU_USAGE = 6;
    public static final int EXCEPTION_HIGH_PACKET_LOST = 7;
    public static final int EXCEPTION_HIGH_LATENCY = 8;
    public static final int EXCEPTION_RECORD_TRANSCODE_FAILED = 9;
    public static final int EXCEPTION_RECORD_STORAGE_FAILED = 10;
    public static final int EXCEPTION_IM_SERVICE_UNAVAILABLE = 11;
    public static final int EXCEPTION_WHITE_SERVICE_UNAVAILABLE = 12;
    public static final int EXCEPTION_OTHER_ERROR = 13;
    public static final int VIDEO_STATUS = 0;
    public static final int AUDIO_STATUS = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URTCLogReportManager getInstance() {
        if (instance != null) return instance;
        Class<URTCLogReportManager> clazz = URTCLogReportManager.class;
        synchronized (URTCLogReportManager.class) {
            if (instance != null) return instance;
            instance = new URTCLogReportManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void refreshUrl() {
        statsReportUrl = logPre ? "https://logpre.urtc.com.cn:443/api/rtcClinetLog" : "https://log.urtc.com.cn:443/api/rtcClinetLog";
        joinLeaveReportUrl = logPre ? "https://logpre.urtc.com.cn:443/api/rtcJoinLeaveClientLog" : "https://log.urtc.com.cn:443/api/rtcJoinLeaveClientLog";
        operationUrl = logPre ? "https://logpre.urtc.com.cn:443/api/opertionLog" : "https://log.urtc.com.cn:443/api/opertionLog";
        exceptionUrl = logPre ? "https://logpre.urtc.com.cn:443/api/exceptionLog" : "https://log.urtc.com.cn:443/api/exceptionLog";
    }

    public PublicLogContainerBuilder assemblePublicHeader() {
        return new PublicLogContainerBuilder();
    }

    public JSONObject createStatusTrackDataDefault(int n2) {
        JSONObject jSONObject = new JSONObject();
        try {
            if (n2 == 0) {
                jSONObject.put("br", -1);
                jSONObject.put("lostpre", -1);
                jSONObject.put("frt", -1);
                jSONObject.put("w", -1);
                jSONObject.put("h", -1);
                jSONObject.put("mime", (Object)INVALID_STRING_VALUE);
            } else {
                jSONObject.put("br", -1);
                jSONObject.put("lostpre", -1);
                jSONObject.put("vol", -1);
                jSONObject.put("mime", (Object)INVALID_STRING_VALUE);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public void sendLog(int n2, String string, ExecutorService executorService) {
        if (!UCloudRtcSdkEnv.isLogReport()) {
            return;
        }
        String string2 = INVALID_STRING_VALUE;
        switch (n2) {
            case 1: {
                string2 = joinLeaveReportUrl;
                break;
            }
            case 3: {
                string2 = joinLeaveReportUrl;
                break;
            }
            case 2: {
                string2 = statsReportUrl;
                break;
            }
            case 4: {
                string2 = exceptionUrl;
                break;
            }
            case 5: {
                string2 = operationUrl;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (executorService != null && !executorService.isShutdown()) {
                executorService.execute(new LogRunnable(n2, string2, string));
            } else {
                new LogRunnable(n2, string2, string).run();
            }
        }
    }

    public void sendCommonMsg(b b2, int n2, JSONObject jSONObject) {
        try {
            PublicLogContainerBuilder publicLogContainerBuilder = URTCLogReportManager.getInstance().assemblePublicHeader().version("1.0").method("logup").rpcId(f.l()).type(n2).timemills(System.currentTimeMillis()).appId(b2.L().getAppId()).roomId(b2.L().getRoomId()).sessionId(b2.J().bc()).userId(b2.L().getUId());
            JSONObject jSONObject2 = publicLogContainerBuilder.build().convertToJsonObject();
            jSONObject2.put("data", (Object)jSONObject);
            this.sendLog(n2, jSONObject2.toString(), b2.bb());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void sendStreamInfoMsg(b b2, int n2, JSONObject jSONObject, String string, int n3, int n4) {
        try {
            PublicLogContainerBuilder publicLogContainerBuilder = URTCLogReportManager.getInstance().assemblePublicHeader().version("1.0").method("logup").rpcId(f.l()).type(n2).timemills(System.currentTimeMillis()).appId(b2.L().getAppId()).roomId(b2.L().getRoomId()).sessionId(b2.J().bc()).userId(b2.L().getUId()).streamId(string).streamType(n3).mediaType(n4);
            JSONObject jSONObject2 = publicLogContainerBuilder.build().convertToJsonObject();
            jSONObject2.put("data", (Object)jSONObject);
            this.sendLog(n2, jSONObject2.toString(), b2.bb());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void sendOpMsg(b b2, int n2) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("opertionType", n2);
            jSONObject.put("userid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("streamid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("recordid", (Object)INVALID_STRING_VALUE);
            this.sendCommonMsg(b2, 5, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void sendOpSubStreamMsg(b b2, int n2, String string, String string2, String string3, int n3, int n4) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("opertionType", n2);
            jSONObject.put("userid", (Object)string3);
            jSONObject.put("streamid", (Object)string2);
            jSONObject.put("recordid", (Object)INVALID_STRING_VALUE);
            this.sendStreamInfoMsg(b2, 5, jSONObject, string, n3, n4);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void sendOpRecordMsg(b b2, int n2, String string) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("opertionType", n2);
            jSONObject.put("userid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("streamid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("recordid", (Object)string);
            this.sendCommonMsg(b2, 5, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void sendOpStreamMsg(b b2, int n2, String string, int n3, int n4) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("opertionType", n2);
            jSONObject.put("userid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("streamid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("recordid", (Object)INVALID_STRING_VALUE);
            this.sendStreamInfoMsg(b2, 5, jSONObject, string, n3, n4);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void sendErrorMsg(b b2, int n2) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("errorType", n2);
            jSONObject.put("userid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("streamid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("msg", (Object)INVALID_STRING_VALUE);
            this.sendCommonMsg(b2, 4, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void sendOtherErrorMsg(b b2, String string) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("errorType", 13);
            jSONObject.put("userid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("streamid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("msg", (Object)string);
            this.sendCommonMsg(b2, 4, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void sendErrorStreamMsg(b b2, int n2, String string, int n3, int n4) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("errorType", n2);
            jSONObject.put("userid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("streamid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("msg", (Object)INVALID_STRING_VALUE);
            this.sendStreamInfoMsg(b2, 4, jSONObject, string, n3, n4);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void sendOtherErrorStreamMsg(b b2, String string, String string2, int n2, int n3) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("errorType", 13);
            jSONObject.put("userid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("streamid", (Object)INVALID_STRING_VALUE);
            jSONObject.put("msg", (Object)string);
            this.sendStreamInfoMsg(b2, 4, jSONObject, string2, n2, n3);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void sendErrorSubStreamMsg(b b2, int n2, String string, String string2, String string3, int n3, int n4) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("errorType", n2);
            jSONObject.put("userid", (Object)string3);
            jSONObject.put("streamid", (Object)string2);
            jSONObject.put("msg", (Object)INVALID_STRING_VALUE);
            this.sendStreamInfoMsg(b2, 4, jSONObject, string, n3, n4);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void sendOtherErrorSubStreamMsg(b b2, String string, String string2, String string3, String string4, int n2, int n3) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("errorType", 13);
            jSONObject.put("userid", (Object)string4);
            jSONObject.put("streamid", (Object)string3);
            jSONObject.put("msg", (Object)string);
            this.sendStreamInfoMsg(b2, 4, jSONObject, string2, n2, n3);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    static {
        logPre = false;
        statsReportUrl = logPre ? "https://logpre.urtc.com.cn/api/stats" : "https://log.urtc.com.cn:443/api/rtcClinetLog";
        joinLeaveReportUrl = logPre ? "https://logpre.urtc.com.cn:443/api/rtcJoinLeaveClientLog" : "https://log.urtc.com.cn:443/api/rtcJoinLeaveClientLog";
        operationUrl = logPre ? "https://logpre.urtc.com.cn:443/api/opertionLog" : "https://log.urtc.com.cn:443/api/opertionLog";
        exceptionUrl = logPre ? "https://logpre.urtc.com.cn:443/api/exceptionLog" : "https://log.urtc.com.cn:443/api/exceptionLog";
    }

    class LogRunnable
    implements Runnable {
        String mUrl;
        String mMessage;
        int mLogType;

        LogRunnable(int n2, String string, String string2) {
            this.mLogType = n2;
            this.mUrl = string;
            this.mMessage = string2;
        }

        @Override
        public void run() {
            try {
                i.d(URTCLogReportManager.TAG, "type: " + this.mLogType + " request url: " + this.mUrl);
                i.d(URTCLogReportManager.TAG, " origin message " + this.mMessage);
                String string = c.bY().g(this.mUrl, this.mMessage);
                i.d(URTCLogReportManager.TAG, " log response " + string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public class PublicLogContainerBuilder {
        private String mVersion = "";
        private String mMethod = "";
        private String mRpcId = "";
        private int mType = -1;
        private long mTimemills = 0L;
        private long mTimeSeconds = 0L;
        private String mAppId = "";
        private String mRoomId = "";
        private String mSessionId = "";
        private String mUserId = "";
        private String mStreamId = "";
        private int mStreamType = -1;
        private int mMediaType = -1;

        public PublicLogContainerBuilder version(String string) {
            this.mVersion = string;
            return this;
        }

        public PublicLogContainerBuilder method(String string) {
            this.mMethod = string;
            return this;
        }

        public PublicLogContainerBuilder rpcId(String string) {
            this.mRpcId = string;
            return this;
        }

        public PublicLogContainerBuilder type(int n2) {
            this.mType = n2;
            return this;
        }

        public PublicLogContainerBuilder timemills(long l2) {
            this.mTimemills = l2;
            this.mTimeSeconds = l2 / 1000L;
            return this;
        }

        public PublicLogContainerBuilder appId(String string) {
            this.mAppId = string;
            return this;
        }

        public PublicLogContainerBuilder roomId(String string) {
            this.mRoomId = string;
            return this;
        }

        public PublicLogContainerBuilder sessionId(String string) {
            this.mSessionId = string;
            return this;
        }

        public PublicLogContainerBuilder userId(String string) {
            this.mUserId = string;
            return this;
        }

        public PublicLogContainerBuilder streamId(String string) {
            this.mStreamId = string;
            return this;
        }

        public PublicLogContainerBuilder streamType(int n2) {
            this.mStreamType = n2;
            return this;
        }

        public PublicLogContainerBuilder mediaType(int n2) {
            this.mMediaType = n2;
            return this;
        }

        public PublicLogContainer build() {
            return new PublicLogContainer(this.mVersion, this.mMethod, this.mRpcId, this.mType, this.mTimeSeconds, this.mAppId, this.mRoomId, this.mSessionId, this.mUserId, this.mStreamId, this.mStreamType, this.mMediaType);
        }
    }

    public class PublicLogContainer {
        private String version;
        private String method;
        private String rpc_id;
        private int type;
        private long ts;
        private String aid;
        private String rid;
        private String sid;
        private String uid;
        private String streamid;
        private int stype;
        private int mtype;

        public PublicLogContainer(String string, String string2, String string3, int n2, long l2, String string4, String string5, String string6, String string7, String string8, int n3, int n4) {
            this.version = string;
            this.method = string2;
            this.rpc_id = string3;
            this.type = n2;
            this.ts = l2;
            this.aid = string4;
            this.rid = string5;
            this.sid = string6;
            this.uid = string7;
            this.streamid = string8;
            this.stype = n3;
            this.mtype = n4;
        }

        public JSONObject convertToJsonObject() {
            JSONObject jSONObject = null;
            try {
                jSONObject = h.a(this);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            return jSONObject;
        }
    }
}

