/*
 * Decompiled with CFR 0.152.
 */
package com.ucloudrtclib.sdkengine.define;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.ucloudrtclib.a.i;
import com.ucloudrtclib.a.l;
import com.ucloudrtclib.d.d;
import com.ucloudrtclib.sdkengine.define.UCloudRtcSdkScaleType;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRTCDataReceiver;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRTCScreenShot;
import java.nio.ByteBuffer;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceViewRenderer;

public class UCloudRtcRenderView
extends SurfaceViewRenderer
implements RendererCommon.RendererEvents {
    private static final String TAG = "URTCRenderView";
    private Handler mMainHandler = null;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    boolean needFullScreen;
    private PositionChanged mPositionChangedListener;

    public UCloudRtcRenderView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        i.d(TAG, "UCloudRtcRenderView222: ");
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
                i.d(UCloudRtcRenderView.TAG, "onLayoutChange new width  " + (n4 - n2) + " from old width: " + (n8 - n6));
                i.d(UCloudRtcRenderView.TAG, "onLayoutChange new height  " + (n5 - n3) + " from old height: " + (n9 - n7));
                UCloudRtcRenderView.this.resetSurface();
            }
        });
    }

    public UCloudRtcRenderView(Context context) {
        super(context);
        i.d(TAG, "UCloudRtcRenderView111: ");
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
                i.d(UCloudRtcRenderView.TAG, "onLayoutChange new width  " + (n4 - n2) + " from old width: " + (n8 - n6));
                i.d(UCloudRtcRenderView.TAG, "onLayoutChange new height  " + (n5 - n3) + " from old height: " + (n9 - n7));
                UCloudRtcRenderView.this.resetSurface();
            }
        });
    }

    public void setPositionChangedListener(PositionChanged positionChanged) {
        this.mPositionChangedListener = positionChanged;
    }

    public boolean isNeedFullScreen() {
        return this.needFullScreen;
    }

    public void setNeedFullScreen(boolean bl) {
        this.needFullScreen = bl;
    }

    public void init() {
        super.init(d.dn().dp(), this, null);
    }

    @Override
    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, UCloudRTCDataReceiver uCloudRTCDataReceiver) {
        i.d(TAG, "init egl surface view ");
        super.init(context, this, uCloudRTCDataReceiver);
        super.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FIT, RendererCommon.ScalingType.SCALE_ASPECT_FIT);
    }

    @Override
    public void release() {
        super.release();
        if (this.mMainHandler != null) {
            this.mMainHandler = null;
        }
    }

    @Override
    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
        i.d(TAG, this + " onMeasure mScaleType: " + this.mScaleType);
        int n4 = View.MeasureSpec.getSize((int)n2);
        int n5 = View.MeasureSpec.getSize((int)n3);
        if (this.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            if (marginLayoutParams.topMargin != 0 || marginLayoutParams.bottomMargin != 0 || marginLayoutParams.leftMargin != 0 || marginLayoutParams.rightMargin != 0) {
                i.d(TAG, "call setLayoutParams() clear margins");
                marginLayoutParams.topMargin = 0;
                marginLayoutParams.bottomMargin = 0;
                marginLayoutParams.leftMargin = 0;
                marginLayoutParams.rightMargin = 0;
                this.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
            }
        }
        i.d(TAG, "mVideoWidth: " + this.mVideoWidth + " mVideoHeight: " + this.mVideoHeight);
        i.d(TAG, "widthSpec.getSize: " + n4 + " heightSpec.getSize: " + n5);
        if (n4 > 0 && n5 > 0 && this.mVideoHeight > 0 && this.mVideoWidth > 0 && this.mScaleType == UCloudRtcSdkScaleType.UCLOUD_RTC_SDK_SCALE_ASPECT_FIT.ordinal()) {
            float f2 = (float)n4 / (float)this.mVideoWidth;
            float f3 = (float)n5 / (float)this.mVideoHeight;
            float f4 = Math.min(f2, f3);
            int n6 = (int)(f4 * (float)this.mVideoWidth);
            int n7 = (int)(f4 * (float)this.mVideoHeight);
            int n8 = (n4 - n6) / 2;
            int n9 = (n5 - n7) / 2;
            i.d(TAG, "Recalculate margins in onMeasure topBottomMargin: " + n9 + " leftRightMargin: " + n8);
            i.d(TAG, "adjust measureWidth: " + n6 + " measureHeight: " + n7);
            this.setMeasuredDimension(n6, n7);
        }
    }

    @Override
    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        ViewGroup viewGroup;
        super.onLayout(bl, n2, n3, n4, n5);
        if (this.getParent() != null && this.getParent() instanceof ViewGroup && this.mScaleType == UCloudRtcSdkScaleType.UCLOUD_RTC_SDK_SCALE_ASPECT_FIT.ordinal() && (viewGroup = (ViewGroup)this.getParent()).getWidth() > 0 && viewGroup.getHeight() > 0) {
            int n6;
            int n7 = 0;
            int n8 = 0;
            if (this.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                n7 = ((ViewGroup.MarginLayoutParams)this.getLayoutParams()).leftMargin + ((ViewGroup.MarginLayoutParams)this.getLayoutParams()).rightMargin;
                n8 = ((ViewGroup.MarginLayoutParams)this.getLayoutParams()).topMargin + ((ViewGroup.MarginLayoutParams)this.getLayoutParams()).bottomMargin;
            }
            int n9 = viewGroup.getHeight() - (viewGroup.getPaddingBottom() + viewGroup.getPaddingTop()) - n8;
            int n10 = viewGroup.getWidth() - (viewGroup.getPaddingLeft() + viewGroup.getPaddingRight()) - n7;
            if (viewGroup.getWidth() == n4 - n2 && n9 > this.getMeasuredHeight()) {
                int n11 = (n9 - (n5 - n3)) / 2 + ((ViewGroup.MarginLayoutParams)this.getLayoutParams()).topMargin;
                if (n3 != n11) {
                    this.layout(0, n11, n4, n11 + (n5 - n3));
                }
            } else if (viewGroup.getHeight() == n5 - n3 && n10 > this.getMeasuredWidth() && n2 != (n6 = (n10 - (n4 - n2)) / 2 + ((ViewGroup.MarginLayoutParams)this.getLayoutParams()).leftMargin)) {
                this.layout(n6, 0, n6 + (n4 - n2), n5);
            }
        }
    }

    public void setScreenShotBack(final UCloudRTCScreenShot uCloudRTCScreenShot) {
        if (uCloudRTCScreenShot != null) {
            EglRenderer.FrameListener frameListener = new EglRenderer.FrameListener(){
                public UCloudRTCScreenShot mSceenShot;
                {
                    this.mSceenShot = uCloudRTCScreenShot;
                }

                @Override
                public void onFrame(ByteBuffer byteBuffer, int n2, int n3) {
                    this.mSceenShot.onReceiveRGBAData(byteBuffer, n2, n3);
                }
            };
            this.addFrameListener(frameListener, 1.0f);
        }
    }

    public void setScaleType(UCloudRtcSdkScaleType uCloudRtcSdkScaleType) {
        if (uCloudRtcSdkScaleType != null) {
            RendererCommon.ScalingType scalingType = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
            switch (uCloudRtcSdkScaleType) {
                case UCLOUD_RTC_SDK_SCALE_ASPECT_FIT: {
                    scalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
                    break;
                }
                case UCLOUD_RTC_SDK_SCALE_ASPECT_FILL: {
                    scalingType = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
                }
                case UCLOUD_RTC_SDK_SCALE_FILL: {
                    scalingType = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
                }
            }
            this.mScaleType = uCloudRtcSdkScaleType.ordinal();
            i.d(TAG, " urtcrenderview setScaleType" + (Object)((Object)uCloudRtcSdkScaleType));
            this.post(new SetScaleTypeRunnable(scalingType));
        }
    }

    @Override
    public void onFirstFrameRendered() {
        i.d(TAG, "onFirstFrameRendered in UCloudRtcRenderView");
        if (this.mPeerConectionCallBack != null) {
            i.d(TAG, "mPeerConectionCallBack onFirstFrameRender");
            this.mPeerConectionCallBack.onFirstFrameRender(this.mStreamInfo, (View)this);
        }
        if (this.mFrameRendered != null) {
            i.d(TAG, "URTCRenderViewonFirstFrameRendered" + this.mStreamInfo + "view: " + this);
            this.mFrameRendered.onFirstFrameRender(this.mStreamInfo, (View)this);
        }
    }

    @Override
    public void onFrameResolutionChanged(final int n2, final int n3, int n4) {
        i.d(TAG, " onFrameResolutionChanged " + n2 + "*" + n3 + " rotation " + n4);
        if (this.mMainHandler != null) {
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    UCloudRtcRenderView.this.mVideoWidth = n2;
                    UCloudRtcRenderView.this.mVideoHeight = n3;
                    UCloudRtcRenderView.this.resetSurface();
                }
            });
        }
    }

    public void resetSurface() {
        i.d(TAG, "resetSurface mScaleType: " + this.mScaleType);
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0 || this.mScaleType == -1 || this.mScaleType == UCloudRtcSdkScaleType.UCLOUD_RTC_SDK_SCALE_ASPECT_FILL.ordinal() || this.mScaleType == UCloudRtcSdkScaleType.UCLOUD_RTC_SDK_SCALE_FILL.ordinal()) {
            return;
        }
        if (this.getParent() instanceof ViewGroup) {
            int n2 = this.needFullScreen ? l.c(this.getContext()) - this.getPaddingLeft() - this.getPaddingRight() : ((ViewGroup)this.getParent()).getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            int n3 = this.needFullScreen ? l.d(this.getContext()) - this.getPaddingTop() - this.getPaddingBottom() : ((ViewGroup)this.getParent()).getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            i.d(TAG, " URTCUIHelper.getScreenPixWidth(getContext()) " + l.c(this.getContext()) + " URTCUIHelper.getScreenPixHeight(getContext()) " + l.d(this.getContext()));
            i.d(TAG, " ((ViewGroup) getParent()).getWidth() " + ((ViewGroup)this.getParent()).getWidth() + " ((ViewGroup) getParent()).getHeight() " + ((ViewGroup)this.getParent()).getHeight());
            i.d(TAG, " winWidth " + n2 + " winHeight " + n3);
            i.d(TAG, " mVideoWidth " + this.mVideoWidth + " mVideoHeight " + this.mVideoHeight);
            float f2 = (float)n2 / (float)this.mVideoWidth;
            float f3 = (float)n3 / (float)this.mVideoHeight;
            float f4 = Math.min(f2, f3);
            int n4 = (int)(f4 * (float)this.mVideoWidth);
            int n5 = (int)(f4 * (float)this.mVideoHeight);
            int n6 = (n3 - n5) / 2;
            int n7 = (n2 - n4) / 2;
            i.d(TAG, " drawn width " + n4 + " drawn height " + n5 + " topBottomMargin " + n6 + " leftRightMargin " + n7);
            if (n6 > 0 || n7 > 0) {
                i.d(TAG, "using new margins to call setLayoutParams and setMeasuredDimension");
                if (this.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
                    marginLayoutParams.topMargin = n6;
                    marginLayoutParams.bottomMargin = n6;
                    marginLayoutParams.leftMargin = n7;
                    marginLayoutParams.rightMargin = n7;
                    this.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
                    this.setMeasuredDimension(n4, n5);
                }
            }
        }
    }

    public int getScaleType() {
        return this.mScaleType;
    }

    public static interface PositionChanged {
        public void onPositionChanged(int var1);
    }

    private class SetScaleTypeRunnable
    implements Runnable {
        RendererCommon.ScalingType renderscacletype;

        SetScaleTypeRunnable(RendererCommon.ScalingType scalingType) {
            this.renderscacletype = scalingType;
        }

        @Override
        public void run() {
            UCloudRtcRenderView.this.setScalingType(this.renderscacletype, this.renderscacletype);
        }
    }
}

