/*
 * Decompiled with CFR 0.152.
 */
package com.ucloudrtclib.sdkengine.define;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.ucloudrtclib.a.l;
import com.ucloudrtclib.d.d;
import com.ucloudrtclib.sdkengine.define.UCloudRtcRenderView;
import com.ucloudrtclib.sdkengine.define.UCloudRtcSdkScaleType;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRTCDataReceiver;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRTCScreenShot;
import java.nio.ByteBuffer;
import org.webrtc.EglRenderer;

public class UCloudRtcSdkSurfaceVideoView
extends FrameLayout {
    private static final String TAG = "==UCloudRtcSdkSurfaceVideoView==";
    private UCloudRtcRenderView mSurface;
    private LinearLayout mRemoteOp;
    private Context mContext;
    private int[] mIconIds;
    private RemoteOpTrigger mRemotTrigger;
    private ImageView muteAudio;
    private ImageView muteVideo;
    private UCloudRTCDataReceiver mDataReceiver;
    private UCloudRtcRenderView.PositionChanged mPostionChangedListener = new UCloudRtcRenderView.PositionChanged(){

        @Override
        public void onPositionChanged(int n2) {
            UCloudRtcSdkSurfaceVideoView.this.adjustRemoteOpBottom(n2);
        }
    };

    public UCloudRtcSdkSurfaceVideoView(Context context) {
        super(context);
        this.mContext = context;
    }

    public UCloudRtcSdkSurfaceVideoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
    }

    public void init(boolean bl) {
        this.mSurface = new UCloudRtcRenderView(this.mContext);
        this.mSurface.setPositionChangedListener(this.mPostionChangedListener);
        this.mSurface.init(d.dn().dp(), null, this.mDataReceiver);
        this.mSurface.setEnableHardwareScaler(true);
        this.mSurface.setNeedFullScreen(bl);
        this.setBackgroundColor(-16777216);
        this.addView((View)this.mSurface, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void init(boolean bl, int[] nArray, RemoteOpTrigger remoteOpTrigger, int[] nArray2) {
        this.mSurface = new UCloudRtcRenderView(this.mContext);
        this.mSurface.setPositionChangedListener(this.mPostionChangedListener);
        this.mSurface.init(d.dn().dp(), null, this.mDataReceiver);
        this.mSurface.setEnableHardwareScaler(true);
        this.mSurface.setNeedFullScreen(bl);
        this.setBackgroundColor(-16777216);
        this.addView((View)this.mSurface, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mIconIds = nArray;
        this.mRemotTrigger = remoteOpTrigger;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 85;
        this.initRemotePanel(bl, nArray2);
        this.addView((View)this.mRemoteOp, (ViewGroup.LayoutParams)layoutParams);
    }

    private void adjustRemoteOpBottom(int n2) {
        if (this.mRemoteOp != null) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mRemoteOp.getLayoutParams();
            layoutParams.bottomMargin = n2;
        }
    }

    private void initRemotePanel(boolean bl, int[] nArray) {
        this.mRemoteOp = new LinearLayout(this.mContext);
        this.mRemoteOp.setOrientation(0);
        if (bl) {
            this.mRemoteOp.setVisibility(4);
        } else {
            this.mRemoteOp.setVisibility(0);
        }
        int n2 = l.a(this.mContext, 20.0f);
        this.muteVideo = new ImageView(this.mContext);
        if (nArray != null && nArray.length >= 2) {
            this.muteVideo.setId(nArray[0]);
        }
        int n3 = l.a(this.mContext, 3.0f);
        this.muteVideo.setPadding(n3, n3, n3, n3);
        this.muteVideo.setBackgroundResource(this.mIconIds[4]);
        this.muteVideo.setImageResource(this.mIconIds[0]);
        this.muteVideo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (UCloudRtcSdkSurfaceVideoView.this.mRemotTrigger != null) {
                    UCloudRtcSdkSurfaceVideoView.this.mRemotTrigger.onRemoteVideo((View)UCloudRtcSdkSurfaceVideoView.this.muteVideo, UCloudRtcSdkSurfaceVideoView.this);
                }
            }
        });
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(n2, n2);
        layoutParams.setMargins(0, 0, l.a(this.mContext, 10.0f), 0);
        this.mRemoteOp.addView((View)this.muteVideo, (ViewGroup.LayoutParams)layoutParams);
        this.muteAudio = new ImageView(this.mContext);
        if (nArray != null && nArray.length >= 2) {
            this.muteAudio.setId(nArray[1]);
        }
        this.muteAudio.setPadding(n3, n3, n3, n3);
        this.muteAudio.setBackgroundResource(this.mIconIds[4]);
        this.muteAudio.setImageResource(this.mIconIds[1]);
        this.muteAudio.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (UCloudRtcSdkSurfaceVideoView.this.mRemotTrigger != null) {
                    UCloudRtcSdkSurfaceVideoView.this.mRemotTrigger.onRemoteAudio((View)UCloudRtcSdkSurfaceVideoView.this.muteAudio, UCloudRtcSdkSurfaceVideoView.this);
                }
            }
        });
        this.mRemoteOp.addView((View)this.muteAudio, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n2, n2));
    }

    public void refreshRemoteOp(int n2) {
        if (this.mRemoteOp != null) {
            this.mRemoteOp.setVisibility(n2);
        }
    }

    public void refreshRemoteVideo(boolean bl) {
        if (bl) {
            this.muteVideo.setImageResource(this.mIconIds[2]);
        } else {
            this.muteVideo.setImageResource(this.mIconIds[0]);
        }
    }

    public void refreshRemoteAudio(boolean bl) {
        if (bl) {
            this.muteAudio.setImageResource(this.mIconIds[3]);
        } else {
            this.muteAudio.setImageResource(this.mIconIds[1]);
        }
    }

    public UCloudRtcRenderView getSurfaceView() {
        return this.mSurface;
    }

    public void setZOrderMediaOverlay(boolean bl) {
        this.mSurface.setZOrderMediaOverlay(bl);
    }

    public void setScalingType(UCloudRtcSdkScaleType uCloudRtcSdkScaleType) {
        if (this.mSurface != null) {
            this.mSurface.setScaleType(uCloudRtcSdkScaleType);
        }
    }

    public void setMirror(boolean bl) {
        if (this.mSurface != null) {
            this.mSurface.setMirror(bl);
        }
    }

    public void release() {
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
    }

    public void refresh() {
        if (this.mSurface != null) {
            this.mSurface.clearImage();
        }
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
        if (this.mSurface != null) {
            this.refresh();
        }
    }

    public void setFrameCallBack(UCloudRTCDataReceiver uCloudRTCDataReceiver) {
        if (uCloudRTCDataReceiver != null) {
            this.mDataReceiver = uCloudRTCDataReceiver;
        }
    }

    public void setScreenShotBack(final UCloudRTCScreenShot uCloudRTCScreenShot) {
        if (uCloudRTCScreenShot != null && this.mSurface != null) {
            EglRenderer.FrameListener frameListener = new EglRenderer.FrameListener(){
                public UCloudRTCScreenShot mSceenShot;
                {
                    this.mSceenShot = uCloudRTCScreenShot;
                }

                @Override
                public void onFrame(ByteBuffer byteBuffer, int n2, int n3) {
                    this.mSceenShot.onReceiveRGBAData(byteBuffer, n2, n3);
                }
            };
            this.mSurface.addFrameListener(frameListener, 1.0f);
        }
    }

    public static interface RemoteOpTrigger {
        public void onRemoteVideo(View var1, UCloudRtcSdkSurfaceVideoView var2);

        public void onRemoteAudio(View var1, UCloudRtcSdkSurfaceVideoView var2);
    }
}

