/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.websocket;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.ucloudrtclib.a.f;
import com.ucloudrtclib.a.i;
import io.crossbar.autobahn.utils.ABLogger;
import io.crossbar.autobahn.utils.IABLogger;
import io.crossbar.autobahn.utils.TLSSocketFactory;
import io.crossbar.autobahn.websocket.WebSocketReader;
import io.crossbar.autobahn.websocket.WebSocketWriter;
import io.crossbar.autobahn.websocket.exceptions.WebSocketException;
import io.crossbar.autobahn.websocket.interfaces.IWebSocket;
import io.crossbar.autobahn.websocket.interfaces.IWebSocketConnectionHandler;
import io.crossbar.autobahn.websocket.messages.BinaryMessage;
import io.crossbar.autobahn.websocket.messages.CannotConnect;
import io.crossbar.autobahn.websocket.messages.ClientHandshake;
import io.crossbar.autobahn.websocket.messages.Close;
import io.crossbar.autobahn.websocket.messages.ConnectionLost;
import io.crossbar.autobahn.websocket.messages.Error;
import io.crossbar.autobahn.websocket.messages.Ping;
import io.crossbar.autobahn.websocket.messages.Pong;
import io.crossbar.autobahn.websocket.messages.ProtocolViolation;
import io.crossbar.autobahn.websocket.messages.Quit;
import io.crossbar.autobahn.websocket.messages.RawTextMessage;
import io.crossbar.autobahn.websocket.messages.ServerError;
import io.crossbar.autobahn.websocket.messages.ServerHandshake;
import io.crossbar.autobahn.websocket.messages.TextMessage;
import io.crossbar.autobahn.websocket.types.ConnectionResponse;
import io.crossbar.autobahn.websocket.types.WebSocketOptions;
import io.crossbar.autobahn.websocket.utils.IPUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class WebSocketConnection
implements IWebSocket {
    private static final IABLogger og = ABLogger.by("WebSocketConnection");
    private static final String TAG = "WebSocketConnection";
    private Handler oh;
    private WebSocketReader oi;
    private WebSocketWriter oj;
    private HandlerThread ok;
    private Socket ol;
    private URI om;
    private String oo;
    private String op;
    private String oq;
    private int or;
    private String ot;
    private String ou;
    private String[] ov;
    private Map<String, String> ow;
    private IWebSocketConnectionHandler ox;
    private WebSocketOptions oy;
    private boolean oz;
    private boolean oA;
    private boolean oB;
    private ScheduledExecutorService oC;
    private ScheduledFuture<?> oD;
    private final Runnable oE = new Runnable(){

        @Override
        public void run() {
            if (WebSocketConnection.this.oi != null && WebSocketConnection.this.oi.eB() >= (double)(WebSocketConnection.this.oy.eQ() - 1)) {
                WebSocketConnection.this.en();
                WebSocketConnection.this.oC.schedule(() -> {
                    if (WebSocketConnection.this.oi.eB() < (double)WebSocketConnection.this.oy.eQ()) {
                        return;
                    }
                    WebSocketConnection.this.d(new ConnectionLost("AutoPing timed out."));
                }, (long)WebSocketConnection.this.oy.eR(), TimeUnit.SECONDS);
            }
        }
    };

    private void d(Object object) {
        Message message = this.oh.obtainMessage();
        message.obj = object;
        this.oh.sendMessage(message);
    }

    public WebSocketConnection() {
        og.bu("WebSocketConnection Created");
        this.eu();
        this.oz = false;
        this.oA = false;
    }

    @Override
    public void bz(String string) {
        this.oj.d(new TextMessage(string));
    }

    @Override
    public void b(byte[] byArray, boolean bl) {
        if (bl) {
            this.oj.d(new BinaryMessage(byArray));
        } else {
            this.oj.d(new RawTextMessage(byArray));
        }
    }

    @Override
    public void en() {
        this.oj.d(new Ping());
    }

    @Override
    public void d(byte[] byArray) {
        this.oj.d(new Ping(byArray));
    }

    @Override
    public void eo() {
        this.oj.d(new Pong());
    }

    @Override
    public void e(byte[] byArray) {
        this.oj.d(new Pong(byArray));
    }

    @Override
    public boolean isConnected() {
        return this.ol != null && this.ol.isConnected() && !this.ol.isClosed();
    }

    private void G(boolean bl) {
        if (this.oi != null) {
            this.oi.quit();
            if (bl) {
                try {
                    this.oi.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    i.d(TAG, f.a(interruptedException.getCause()));
                }
            }
            this.oi = null;
        } else {
            og.bu("mReader already NULL");
        }
    }

    private void ep() {
        Thread thread = new Thread(() -> {
            if (this.isConnected()) {
                try {
                    this.ol.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    i.d(TAG, f.a(iOException.getCause()));
                }
            }
        });
        thread.start();
        thread.join();
    }

    private void eq() {
        if (this.oj != null) {
            this.oj.d(new Quit());
            try {
                this.ok.join();
            }
            catch (InterruptedException interruptedException) {
                og.a(interruptedException.getMessage(), interruptedException);
            }
        } else {
            og.bu("mWriter already NULL");
        }
    }

    public void d(int n2, String string) {
        i.d(TAG, "fail connection [code = " + n2 + ", reason = " + string);
        og.bu("fail connection [code = " + n2 + ", reason = " + string);
        this.G(false);
        this.eq();
        if (this.isConnected()) {
            try {
                this.ep();
            }
            catch (IOException | InterruptedException exception) {
                og.a(exception.getMessage(), exception);
            }
        } else {
            og.bu("Socket already closed");
        }
        this.G(true);
        this.c(n2, string);
        og.bu("Worker threads stopped");
    }

    @Override
    public void a(String string, IWebSocketConnectionHandler iWebSocketConnectionHandler) {
        this.a(string, null, null, iWebSocketConnectionHandler, null, null);
    }

    @Override
    public void a(String string, IWebSocketConnectionHandler iWebSocketConnectionHandler, WebSocketOptions webSocketOptions) {
        this.a(string, null, null, iWebSocketConnectionHandler, webSocketOptions, null);
    }

    @Override
    public void a(String string, String string2, IWebSocketConnectionHandler iWebSocketConnectionHandler, WebSocketOptions webSocketOptions) {
        this.a(string, string2, null, iWebSocketConnectionHandler, webSocketOptions, null);
    }

    @Override
    public void a(String string, String[] stringArray, IWebSocketConnectionHandler iWebSocketConnectionHandler) {
        this.a(string, null, stringArray, iWebSocketConnectionHandler, new WebSocketOptions(), null);
    }

    @Override
    public void a(String string, String string2, String[] stringArray, IWebSocketConnectionHandler iWebSocketConnectionHandler, WebSocketOptions webSocketOptions, Map<String, String> map) {
        i.d(TAG, "connect start");
        if (this.isConnected()) {
            throw new WebSocketException("already connected");
        }
        try {
            this.om = new URI(string);
            if (!this.om.getScheme().equals("ws") && !this.om.getScheme().equals("wss")) {
                throw new WebSocketException("unsupported scheme for WebSockets URI");
            }
            this.op = string2;
            this.oo = this.om.getScheme();
            this.or = this.om.getPort() == -1 ? (this.oo.equals("ws") ? 80 : 443) : this.om.getPort();
            if (this.om.getHost() == null) {
                throw new WebSocketException("no host specified in WebSockets URI");
            }
            this.oq = this.om.getHost();
            this.ot = this.om.getRawPath() == null || this.om.getRawPath().equals("") ? "/" : this.om.getRawPath();
            this.ou = this.om.getRawQuery() == null || this.om.getRawQuery().equals("") ? null : this.om.getRawQuery();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new WebSocketException("invalid WebSockets URI");
        }
        this.ov = stringArray;
        this.ow = map;
        this.ox = iWebSocketConnectionHandler;
        if (this.oy == null) {
            this.oy = webSocketOptions == null ? new WebSocketOptions() : new WebSocketOptions(webSocketOptions);
        } else if (webSocketOptions != null) {
            this.oy = new WebSocketOptions(webSocketOptions);
        }
        this.oz = true;
        this.oB = false;
        i.d(TAG, "connect method finish ,start");
        new WebSocketConnector().start();
    }

    @Override
    public void er() {
        this.ah(1000);
    }

    @Override
    public void ah(int n2) {
        this.e(n2, null);
    }

    @Override
    public void e(int n2, String string) {
        if (this.oj != null) {
            this.oj.d(new Close(n2, string));
        } else {
            og.bu("could not send Close .. writer already NULL");
        }
        this.oB = false;
        this.oz = false;
        this.oA = false;
    }

    public boolean reconnect() {
        if (!this.isConnected() && this.om != null) {
            this.oB = false;
            new WebSocketConnector().start();
            return true;
        }
        return false;
    }

    private boolean es() {
        int n2 = this.oy.eO();
        boolean bl = this.oz && this.oA && n2 > 0;
        i.d(TAG, "web socket inner scheduleReconnect " + bl + "mActive: " + this.oz + " mPrevConnected: " + this.oA + " interval: " + n2);
        if (bl) {
            og.bu("Reconnection scheduled");
            this.oh.postDelayed(() -> {
                og.bu("Reconnecting...");
                this.reconnect();
            }, (long)n2);
        }
        return bl;
    }

    private void c(int n2, String string) {
        block7: {
            boolean bl = false;
            if (n2 == 2 || n2 == 3) {
                i.d(TAG, "web socket start reconnect ");
                bl = this.es();
            }
            if (this.oC != null) {
                this.oC.shutdown();
            }
            if (this.ox != null) {
                try {
                    if (bl) {
                        this.ox.c(7, string);
                        break block7;
                    }
                    this.ox.c(n2, string);
                }
                catch (Exception exception) {
                    og.a(exception.getMessage(), exception);
                }
            } else {
                og.bu("mWsHandler already NULL");
            }
        }
        this.oB = true;
    }

    private void et() {
        this.G(false);
        this.eq();
        if (this.isConnected()) {
            try {
                this.ep();
            }
            catch (IOException | InterruptedException exception) {
                og.a(exception.getMessage(), exception);
            }
        }
        this.G(true);
        this.oB = false;
    }

    private <T> T a(Map<?, ?> map, Object object, T t) {
        if (map.containsKey(object)) {
            return (T)map.get(object);
        }
        return t;
    }

    public void a(WebSocketOptions webSocketOptions) {
        if (this.oy == null) {
            this.oy = new WebSocketOptions(webSocketOptions);
        } else {
            this.oy.an(webSocketOptions.eQ());
            this.oy.ao(webSocketOptions.eR());
            if (this.oD != null) {
                this.oD.cancel(true);
            }
            if (this.oC == null) {
                this.oC = Executors.newSingleThreadScheduledExecutor();
            }
            if (this.oy.eQ() > 0) {
                this.oD = this.oC.scheduleAtFixedRate(this.oE, 0L, this.oy.eQ(), TimeUnit.SECONDS);
            }
        }
    }

    private void eu() {
        this.oh = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                if (WebSocketConnection.this.oB) {
                    og.bu("onClose called already, ignore message.");
                    return;
                }
                if (message.obj instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message.obj;
                    if (WebSocketConnection.this.ox != null) {
                        WebSocketConnection.this.ox.bh(textMessage.pG);
                    } else {
                        og.bu("could not call onTextMessage() .. handler already NULL");
                    }
                } else if (message.obj instanceof RawTextMessage) {
                    RawTextMessage rawTextMessage = (RawTextMessage)message.obj;
                    if (WebSocketConnection.this.ox != null) {
                        WebSocketConnection.this.ox.a(rawTextMessage.pp, false);
                    } else {
                        og.bu("could not call onRawTextMessage() .. handler already NULL");
                    }
                } else if (message.obj instanceof BinaryMessage) {
                    BinaryMessage binaryMessage = (BinaryMessage)message.obj;
                    if (WebSocketConnection.this.ox != null) {
                        WebSocketConnection.this.ox.a(binaryMessage.pp, true);
                    } else {
                        og.bu("could not call onBinaryMessage() .. handler already NULL");
                    }
                } else if (message.obj instanceof Ping) {
                    Ping ping = (Ping)message.obj;
                    og.bu("WebSockets Ping received");
                    if (ping.pp == null) {
                        WebSocketConnection.this.ox.cI();
                    } else {
                        WebSocketConnection.this.ox.b(ping.pp);
                    }
                } else if (message.obj instanceof Pong) {
                    Pong pong = (Pong)message.obj;
                    if (pong.pp == null) {
                        WebSocketConnection.this.ox.cJ();
                    } else {
                        WebSocketConnection.this.ox.c(pong.pp);
                    }
                    og.bu("WebSockets Pong received");
                } else if (message.obj instanceof Close) {
                    int n2;
                    Close close = (Close)message.obj;
                    int n3 = n2 = close.px == 1000 ? 1 : 3;
                    if (close.pz) {
                        og.bu("WebSockets Close received (" + close.px + " - " + close.py + ")");
                        WebSocketConnection.this.et();
                        WebSocketConnection.this.c(n2, close.py);
                    } else if (WebSocketConnection.this.oz) {
                        WebSocketConnection.this.G(false);
                        WebSocketConnection.this.oj.d(new Close(1000, true));
                        WebSocketConnection.this.oz = false;
                    } else {
                        og.bu("WebSockets Close received (" + close.px + " - " + close.py + ")");
                        WebSocketConnection.this.et();
                        WebSocketConnection.this.c(n2, close.py);
                    }
                } else if (message.obj instanceof ServerHandshake) {
                    ServerHandshake serverHandshake = (ServerHandshake)message.obj;
                    og.bu("opening handshake received");
                    if (serverHandshake.pE) {
                        if (WebSocketConnection.this.ox != null) {
                            if (WebSocketConnection.this.oy.eQ() > 0) {
                                WebSocketConnection.this.oD = WebSocketConnection.this.oC.scheduleAtFixedRate(WebSocketConnection.this.oE, 0L, WebSocketConnection.this.oy.eQ(), TimeUnit.SECONDS);
                            }
                            String string = (String)WebSocketConnection.this.a(serverHandshake.pF, "Sec-WebSocket-Protocol", null);
                            WebSocketConnection.this.ox.a(WebSocketConnection.this);
                            WebSocketConnection.this.ox.a(new ConnectionResponse(string));
                            WebSocketConnection.this.ox.cH();
                            og.bu("onOpen() called, ready to rock.");
                        } else {
                            og.bu("could not call onOpen() .. handler already NULL");
                        }
                    }
                } else if (message.obj instanceof CannotConnect) {
                    CannotConnect cannotConnect = (CannotConnect)message.obj;
                    WebSocketConnection.this.d(2, cannotConnect.pq);
                } else if (message.obj instanceof ConnectionLost) {
                    ConnectionLost connectionLost = (ConnectionLost)message.obj;
                    WebSocketConnection.this.d(3, connectionLost.pq);
                } else if (message.obj instanceof ProtocolViolation) {
                    ProtocolViolation protocolViolation = (ProtocolViolation)message.obj;
                    WebSocketConnection.this.d(4, "WebSockets protocol violation");
                } else if (message.obj instanceof Error) {
                    Error error = (Error)message.obj;
                    WebSocketConnection.this.d(5, "WebSockets internal error (" + error.pA.toString() + ")");
                } else if (message.obj instanceof ServerError) {
                    ServerError serverError = (ServerError)message.obj;
                    WebSocketConnection.this.d(6, "Server error " + serverError.pC + " (" + serverError.pD + ")");
                } else {
                    WebSocketConnection.this.e(message.obj);
                }
            }
        };
    }

    private void e(Object object) {
    }

    private void ev() {
        og.bu("WS writer start create");
        this.ok = new HandlerThread("WebSocketWriter");
        this.ok.start();
        this.oj = new WebSocketWriter(this.ok.getLooper(), this.oh, this.ol, this.oy);
        og.bu("WS writer created and started");
    }

    private void ew() {
        og.bu("WS reader created started");
        this.oi = new WebSocketReader(this.oh, this.ol, this.oy, "WebSocketReader");
        og.bu("WS reader created finished");
        this.oi.start();
        og.bu("WS reader created and started");
    }

    private void a(Socket socket, String[] stringArray) {
        if (socket != null && socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(stringArray);
        }
    }

    private class WebSocketConnector
    extends Thread {
        private WebSocketConnector() {
        }

        @Override
        public void run() {
            Object object;
            Thread.currentThread().setName("WebSocketConnector");
            i.d(WebSocketConnection.TAG, "connector to connect start");
            try {
                Object object2;
                if (WebSocketConnection.this.oo.equals("wss")) {
                    WebSocketConnection.this.ol = SSLSocketFactory.getDefault().createSocket();
                    object = KeyStore.getInstance(KeyStore.getDefaultType());
                    ((KeyStore)object).load(null, null);
                    object2 = new TLSSocketFactory();
                    WebSocketConnection.this.ol = ((SocketFactory)object2).createSocket();
                } else {
                    WebSocketConnection.this.ol = SocketFactory.getDefault().createSocket();
                }
                if (WebSocketConnection.this.oy.eP() != null) {
                    WebSocketConnection.this.a(WebSocketConnection.this.ol, WebSocketConnection.this.oy.eP());
                }
                i.d(WebSocketConnection.TAG, "socket call connect start host: " + WebSocketConnection.this.oq + " ip: " + WebSocketConnection.this.op + " port: " + WebSocketConnection.this.or);
                if (!TextUtils.isEmpty((CharSequence)WebSocketConnection.this.op)) {
                    i.d(WebSocketConnection.TAG, "socket connect with ip: " + WebSocketConnection.this.op);
                    object = IPUtils.m(WebSocketConnection.this.op, WebSocketConnection.this.oq);
                    i.d(WebSocketConnection.TAG, "inet4Address: " + object);
                    object2 = new InetSocketAddress((InetAddress)object, WebSocketConnection.this.or);
                    WebSocketConnection.this.ol.connect((SocketAddress)object2, WebSocketConnection.this.oy.eL());
                } else {
                    i.d(WebSocketConnection.TAG, "socket connect with URLHost: " + WebSocketConnection.this.oq);
                    WebSocketConnection.this.ol.connect(new InetSocketAddress(WebSocketConnection.this.oq, WebSocketConnection.this.or), WebSocketConnection.this.oy.eL());
                }
                i.d(WebSocketConnection.TAG, "socket call connect finish");
                i.d(WebSocketConnection.TAG, "socket setSoTimeout");
                WebSocketConnection.this.ol.setSoTimeout(WebSocketConnection.this.oy.eK());
                i.d(WebSocketConnection.TAG, "socket setTcpNoDelay");
                WebSocketConnection.this.ol.setTcpNoDelay(WebSocketConnection.this.oy.getTcpNoDelay());
            }
            catch (IOException iOException) {
                WebSocketConnection.this.d(new CannotConnect(iOException.getMessage()));
                return;
            }
            catch (CertificateException certificateException) {
                certificateException.printStackTrace();
                i.d(WebSocketConnection.TAG, f.a(certificateException.getCause()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
                i.d(WebSocketConnection.TAG, f.a(noSuchAlgorithmException.getCause()));
            }
            catch (KeyStoreException keyStoreException) {
                keyStoreException.printStackTrace();
                i.d(WebSocketConnection.TAG, f.a(keyStoreException.getCause()));
            }
            i.d(WebSocketConnection.TAG, "mExecutor: " + WebSocketConnection.this.oC);
            if (WebSocketConnection.this.oC == null || WebSocketConnection.this.oC.isShutdown()) {
                WebSocketConnection.this.oC = Executors.newSingleThreadScheduledExecutor();
                i.d(WebSocketConnection.TAG, "newSingleThreadScheduledExecutor :" + WebSocketConnection.this.oC);
            }
            i.d(WebSocketConnection.TAG, "check is Connected");
            if (WebSocketConnection.this.isConnected()) {
                i.d(WebSocketConnection.TAG, "is connected now to create reader,writer");
                try {
                    i.d(WebSocketConnection.TAG, "SSLoutputstream" + WebSocketConnection.this.ol.getOutputStream());
                    WebSocketConnection.this.ev();
                    WebSocketConnection.this.ew();
                    object = new ClientHandshake(WebSocketConnection.this.oq + ":" + WebSocketConnection.this.or);
                    ((ClientHandshake)object).ps = WebSocketConnection.this.ot;
                    ((ClientHandshake)object).pt = WebSocketConnection.this.ou;
                    ((ClientHandshake)object).pv = WebSocketConnection.this.ov;
                    ((ClientHandshake)object).pw = WebSocketConnection.this.ow;
                    WebSocketConnection.this.oj.d(object);
                    WebSocketConnection.this.oA = true;
                    i.d(WebSocketConnection.TAG, "is create reader,writer finish");
                }
                catch (Exception exception) {
                    WebSocketConnection.this.d(new Error(exception));
                }
            } else {
                WebSocketConnection.this.d(new CannotConnect("Could not connect to WebSocket server"));
            }
        }
    }
}

