/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.websocket;

import android.os.Handler;
import android.os.Message;
import android.util.Pair;
import com.ucloudrtclib.a.i;
import io.crossbar.autobahn.utils.ABLogger;
import io.crossbar.autobahn.utils.IABLogger;
import io.crossbar.autobahn.websocket.exceptions.WebSocketException;
import io.crossbar.autobahn.websocket.messages.BinaryMessage;
import io.crossbar.autobahn.websocket.messages.Close;
import io.crossbar.autobahn.websocket.messages.ConnectionLost;
import io.crossbar.autobahn.websocket.messages.Error;
import io.crossbar.autobahn.websocket.messages.Ping;
import io.crossbar.autobahn.websocket.messages.Pong;
import io.crossbar.autobahn.websocket.messages.ProtocolViolation;
import io.crossbar.autobahn.websocket.messages.RawTextMessage;
import io.crossbar.autobahn.websocket.messages.ServerError;
import io.crossbar.autobahn.websocket.messages.ServerHandshake;
import io.crossbar.autobahn.websocket.messages.TextMessage;
import io.crossbar.autobahn.websocket.types.WebSocketOptions;
import io.crossbar.autobahn.websocket.utils.Utf8Validator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class WebSocketReader
extends Thread {
    private static final IABLogger og = ABLogger.by("WebSocketReader");
    private static final String TAG = "WebSocketReader";
    private final Handler oH;
    private final WebSocketOptions oy;
    private BufferedInputStream oI;
    private Socket ol;
    private int oJ;
    private byte[] oK;
    private ByteBuffer oL;
    private ByteArrayOutputStream oM;
    private static final int oN = 0;
    private static final int STATE_CONNECTING = 1;
    private static final int oO = 2;
    private static final int oP = 3;
    private boolean oQ = false;
    private int oR;
    private long oS;
    private boolean oT = false;
    private int oU;
    private FrameHeader oV;
    private Utf8Validator oW = new Utf8Validator();

    public WebSocketReader(Handler handler, Socket socket, WebSocketOptions webSocketOptions, String string) {
        super(string);
        this.oH = handler;
        this.oy = webSocketOptions;
        this.ol = socket;
        i.d(TAG, "WebSocketReader allocate messagedata " + (this.oy.eI() + 14));
        this.oK = new byte[this.oy.eI() + 14];
        i.d(TAG, "WebSocketReader allocate BufferedInputStream " + (this.oy.eI() + 14));
        this.oI = new BufferedInputStream(this.ol.getInputStream(), this.oy.eI() + 14);
        i.d(TAG, "WebSocketReader allocate payload " + (this.oy.eJ() + 14));
        this.oM = new ByteArrayOutputStream(webSocketOptions.eJ());
        i.d(TAG, "WebSocketReader allocate finish");
        this.oV = null;
        this.oR = 1;
        i.d(TAG, "WebSocketReader Created");
    }

    double eB() {
        return (double)(System.currentTimeMillis() - this.oS) / 1000.0;
    }

    public void quit() {
        this.oR = 0;
        og.bu("Quit");
    }

    protected void f(Object object) {
        Message message = this.oH.obtainMessage();
        message.obj = object;
        this.oH.sendMessage(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean eC() {
        if (this.oV == null) {
            long l2;
            int n2;
            int n3;
            if (this.oJ < 2) return false;
            byte by = this.oK[0];
            boolean bl = (by & 0x80) != 0;
            int n4 = (by & 0x70) >> 4;
            int n5 = by & 0xF;
            byte by2 = this.oK[1];
            boolean bl2 = (by2 & 0x80) != 0;
            int n6 = by2 & 0x7F;
            if (n4 != 0) {
                throw new WebSocketException("RSV != 0 and no extension negotiated");
            }
            if (bl2) {
                throw new WebSocketException("masked server frame");
            }
            if (n5 > 7) {
                if (!bl) {
                    throw new WebSocketException("fragmented control frame");
                }
                if (n6 > 125) {
                    throw new WebSocketException("control frame with payload length > 125 octets");
                }
                if (n5 != 8 && n5 != 9 && n5 != 10) {
                    throw new WebSocketException("control frame using reserved opcode " + n5);
                }
                if (n5 == 8 && n6 == 1) {
                    throw new WebSocketException("received close control frame with payload len 1");
                }
            } else {
                if (n5 != 0 && n5 != 1 && n5 != 2) {
                    throw new WebSocketException("data frame using reserved opcode " + n5);
                }
                if (!this.oT && n5 == 0) {
                    throw new WebSocketException("received continuation data frame outside fragmented message");
                }
                if (this.oT && n5 != 0) {
                    throw new WebSocketException("received non-continuation data frame while inside fragmented message");
                }
            }
            int n7 = n3 = bl2 ? 4 : 0;
            if (n6 < 126) {
                n2 = 2 + n3;
            } else if (n6 == 126) {
                n2 = 4 + n3;
            } else {
                if (n6 != 127) throw new Exception("logic error");
                n2 = 10 + n3;
            }
            if (this.oJ < n2) return false;
            int n8 = 2;
            if (n6 == 126) {
                l2 = (0xFF & this.oK[n8]) << 8 | 0xFF & this.oK[n8 + 1];
                if (l2 < 126L) {
                    throw new WebSocketException("invalid data frame length (not using minimal length encoding)");
                }
                n8 += 2;
            } else if (n6 == 127) {
                if ((0x80 & this.oK[n8]) != 0) {
                    throw new WebSocketException("invalid data frame length (> 2^63)");
                }
                l2 = (long)(0xFF & this.oK[n8]) << 56 | (long)(0xFF & this.oK[n8 + 1]) << 48 | (long)(0xFF & this.oK[n8 + 2]) << 40 | (long)(0xFF & this.oK[n8 + 3]) << 32 | (long)(0xFF & this.oK[n8 + 4]) << 24 | (long)(0xFF & this.oK[n8 + 5]) << 16 | (long)(0xFF & this.oK[n8 + 6]) << 8 | (long)(0xFF & this.oK[n8 + 7]);
                if (l2 < 65536L) {
                    throw new WebSocketException("invalid data frame length (not using minimal length encoding)");
                }
                n8 += 8;
            } else {
                l2 = n6;
            }
            if (l2 > (long)this.oy.eI()) {
                throw new WebSocketException("frame payload too large");
            }
            this.oV = new FrameHeader();
            this.oV.oX = n5;
            this.oV.oY = bl;
            this.oV.oZ = n4;
            this.oV.pb = (int)l2;
            this.oV.pa = n2;
            this.oV.pc = this.oV.pa + this.oV.pb;
            if (bl2) {
                this.oV.pd = new byte[4];
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.oV.pd[n8] = (byte)(0xFF & this.oK[n8 + i2]);
                }
                n8 += 4;
            } else {
                this.oV.pd = null;
            }
            if (this.oV.pb == 0) return true;
            if (this.oJ < this.oV.pc) return false;
            return true;
        }
        if (this.oJ < this.oV.pc) return false;
        byte[] byArray = null;
        if (this.oV.pb > 0) {
            byArray = new byte[this.oV.pb];
            System.arraycopy(this.oK, this.oV.pa, byArray, 0, this.oV.pb);
        }
        this.oK = Arrays.copyOfRange(this.oK, this.oV.pc, this.oK.length + this.oV.pc);
        this.oJ -= this.oV.pc;
        if (this.oV.oX > 7) {
            if (this.oV.oX == 8) {
                int n9 = 1005;
                String string = null;
                if (this.oV.pb >= 2) {
                    n9 = (byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF);
                    if (n9 < 1000) throw new WebSocketException("invalid close code " + n9);
                    if (n9 >= 1000 && n9 <= 2999 && n9 != 1000 && n9 != 1001 && n9 != 1002 && n9 != 1003 && n9 != 1007 && n9 != 1008 && n9 != 1009 && n9 != 1010) {
                        if (n9 != 1011) throw new WebSocketException("invalid close code " + n9);
                    }
                    if (n9 >= 5000) {
                        throw new WebSocketException("invalid close code " + n9);
                    }
                    if (this.oV.pb > 2) {
                        byte[] byArray2 = new byte[this.oV.pb - 2];
                        System.arraycopy(byArray, 2, byArray2, 0, this.oV.pb - 2);
                        Utf8Validator utf8Validator = new Utf8Validator();
                        utf8Validator.h(byArray2);
                        if (!utf8Validator.isValid()) {
                            throw new WebSocketException("invalid close reasons (not UTF-8)");
                        }
                        string = new String(byArray2, "UTF-8");
                    }
                }
                this.c(n9, string);
                this.oR = 0;
            } else if (this.oV.oX == 9) {
                this.b(byArray);
            } else {
                if (this.oV.oX != 10) throw new Exception("logic error");
                this.c(byArray);
            }
        } else {
            if (!this.oT) {
                this.oT = true;
                this.oU = this.oV.oX;
                if (this.oU == 1 && this.oy.eM()) {
                    this.oW.reset();
                }
            }
            if (byArray != null) {
                if (this.oM.size() + byArray.length > this.oy.eJ()) {
                    throw new WebSocketException("message payload too large");
                }
                if (this.oU == 1 && this.oy.eM() && !this.oW.h(byArray)) {
                    throw new WebSocketException("invalid UTF-8 in text message payload");
                }
                this.oM.write(byArray);
            }
            if (this.oV.oY) {
                if (this.oU == 1) {
                    if (this.oy.eM() && !this.oW.isValid()) {
                        throw new WebSocketException("UTF-8 text message payload ended within Unicode code point");
                    }
                    if (this.oy.eH()) {
                        this.f(this.oM.toByteArray());
                    } else {
                        String string = new String(this.oM.toByteArray(), "UTF-8");
                        this.bA(string);
                    }
                } else {
                    if (this.oU != 2) throw new Exception("logic error");
                    this.g(this.oM.toByteArray());
                }
                this.oT = false;
                this.oM.reset();
            }
        }
        this.oV = null;
        if (this.oJ <= 0) return false;
        return true;
    }

    protected void a(Map<String, String> map, boolean bl) {
        this.f(new ServerHandshake(map, bl));
    }

    protected void c(int n2, String string) {
        this.f(new Close(n2, string));
    }

    protected void b(byte[] byArray) {
        this.f(new Ping(byArray));
    }

    protected void c(byte[] byArray) {
        this.f(new Pong(byArray));
    }

    protected void bA(String string) {
        this.f(new TextMessage(string));
    }

    protected void f(byte[] byArray) {
        this.f(new RawTextMessage(byArray));
    }

    protected void g(byte[] byArray) {
        this.f(new BinaryMessage(byArray));
    }

    private boolean eD() {
        boolean bl = false;
        for (int i2 = this.oJ - 4; i2 >= 0; --i2) {
            Object object;
            if (this.oK[i2] != 13 || this.oK[i2 + 1] != 10 || this.oK[i2 + 2] != 13 || this.oK[i2 + 3] != 10) continue;
            boolean bl2 = false;
            String string = new String(Arrays.copyOf(this.oK, i2 + 4), "UTF-8");
            String[] stringArray = string.split("\r\n");
            if (stringArray[0].startsWith("HTTP")) {
                object = this.bB(stringArray[0]);
                if ((Integer)object.first >= 300) {
                    this.f(new ServerError((Integer)object.first, (String)object.second));
                    bl2 = true;
                }
            }
            object = this.b(Arrays.copyOfRange(stringArray, 1, stringArray.length));
            this.oK = Arrays.copyOfRange(this.oK, i2 + 4, this.oK.length + i2 + 4);
            this.oJ -= i2 + 4;
            if (!bl2) {
                bl = this.oJ > 0;
                this.oR = 3;
            } else {
                bl = true;
                this.oR = 0;
                this.oQ = true;
            }
            this.a((Map<String, String>)object, !bl2);
            break;
        }
        return bl;
    }

    private Map<String, String> b(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : stringArray) {
            String[] stringArray2;
            if (string.length() <= 0 || (stringArray2 = string.split(": ")).length != 2) continue;
            hashMap.put(stringArray2[0], stringArray2[1]);
            og.bu(String.format("'%s'='%s'", stringArray2[0], stringArray2[1]));
        }
        return hashMap;
    }

    private Pair<Integer, String> bB(String string) {
        String[] stringArray = string.split(" ");
        int n2 = Integer.valueOf(stringArray[1]);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 2; i2 < stringArray.length; ++i2) {
            stringBuilder.append(stringArray[i2]);
            stringBuilder.append(" ");
        }
        String string2 = stringBuilder.toString().trim();
        og.bu(String.format("Status: %d (%s)", n2, string2));
        return new Pair((Object)n2, (Object)string2);
    }

    private boolean eE() {
        if (this.oR == 3 || this.oR == 2) {
            return this.eC();
        }
        if (this.oR == 1) {
            return this.eD();
        }
        if (this.oR == 0) {
            return false;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            do {
                int n2 = this.oI.read(this.oK, this.oJ, this.oK.length - this.oJ);
                this.oJ += n2;
                if (n2 > 0) {
                    this.oS = System.currentTimeMillis();
                    while (this.eE()) {
                    }
                } else {
                    if (this.oR == 0) {
                        this.oQ = true;
                        continue;
                    }
                    if (n2 >= 0) continue;
                    og.bu("run() : ConnectionLost");
                    this.f(new ConnectionLost(null));
                    this.oQ = true;
                }
            } while (!this.oQ);
        }
        catch (WebSocketException webSocketException) {
            og.bu("run() : WebSocketException (" + webSocketException.toString() + ")");
            this.f(new ProtocolViolation(webSocketException));
        }
        catch (SocketException socketException) {
            if (this.oR != 0 && !this.ol.isClosed()) {
                og.bu("run() : SocketException (" + socketException.toString() + ")");
                this.f(new ConnectionLost(null));
            }
        }
        catch (Exception exception) {
            og.bu("run() : Exception (" + exception.toString() + ")");
            this.f(new Error(exception));
        }
        finally {
            this.oQ = true;
        }
        og.bu("Ended");
    }

    private static class FrameHeader {
        public int oX;
        public boolean oY;
        public int oZ;
        public int pa;
        public int pb;
        public int pc;
        public byte[] pd;

        private FrameHeader() {
        }
    }
}

