/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.websocket;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Base64;
import com.ucloudrtclib.a.f;
import com.ucloudrtclib.a.i;
import io.crossbar.autobahn.utils.ABLogger;
import io.crossbar.autobahn.utils.IABLogger;
import io.crossbar.autobahn.websocket.exceptions.WebSocketException;
import io.crossbar.autobahn.websocket.messages.BinaryMessage;
import io.crossbar.autobahn.websocket.messages.ClientHandshake;
import io.crossbar.autobahn.websocket.messages.Close;
import io.crossbar.autobahn.websocket.messages.ConnectionLost;
import io.crossbar.autobahn.websocket.messages.Error;
import io.crossbar.autobahn.websocket.messages.Ping;
import io.crossbar.autobahn.websocket.messages.Pong;
import io.crossbar.autobahn.websocket.messages.Quit;
import io.crossbar.autobahn.websocket.messages.RawTextMessage;
import io.crossbar.autobahn.websocket.messages.TextMessage;
import io.crossbar.autobahn.websocket.types.WebSocketOptions;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Random;

class WebSocketWriter
extends Handler {
    private static final IABLogger og = ABLogger.by("WebSocketWriter");
    private static final String CRLF = "\r\n";
    private static final String TAG = "WebSocketWriter";
    private final Random pe = new Random();
    private final Handler oH;
    private final Looper pf;
    private final WebSocketOptions oy;
    private OutputStream pg;
    private Socket ol;
    private boolean oz;

    public WebSocketWriter(Looper looper, Handler handler, Socket socket, WebSocketOptions webSocketOptions) {
        super(looper);
        this.pf = looper;
        this.oH = handler;
        this.oy = webSocketOptions;
        this.ol = socket;
        og.bu("WebSocketWriter socket Created");
        og.bu("use BufferedOutputStream stream");
        this.pg = new BufferedOutputStream(socket.getOutputStream(), webSocketOptions.eI() + 14);
        this.oz = true;
        og.bu("WebSocketWriter Created");
    }

    private void write(String string) {
        try {
            this.pg.write(string.getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            i.d(TAG, f.a(iOException.getCause()));
        }
    }

    private void a(byte by) {
        try {
            this.pg.write(by);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            i.d(TAG, f.a(iOException.getCause()));
        }
    }

    private void write(byte[] byArray) {
        try {
            this.pg.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            i.d(TAG, f.a(iOException.getCause()));
        }
    }

    public void d(Object object) {
        if (!this.oz) {
            og.bu("We have already quit, not processing further messages");
            return;
        }
        Message message = this.obtainMessage();
        message.obj = object;
        this.sendMessage(message);
    }

    private void f(Object object) {
        Message message = this.oH.obtainMessage();
        message.obj = object;
        this.oH.sendMessage(message);
    }

    private String eF() {
        byte[] byArray = new byte[16];
        this.pe.nextBytes(byArray);
        return Base64.encodeToString((byte[])byArray, (int)2);
    }

    private byte[] eG() {
        byte[] byArray = new byte[4];
        this.pe.nextBytes(byArray);
        return byArray;
    }

    private void a(ClientHandshake clientHandshake) {
        String string = clientHandshake.pt != null ? clientHandshake.ps + "?" + clientHandshake.pt : clientHandshake.ps;
        this.write("GET " + string + " HTTP/1.1");
        this.write(CRLF);
        this.write("Host: " + clientHandshake.pr);
        this.write(CRLF);
        this.write("Upgrade: WebSocket");
        this.write(CRLF);
        this.write("Connection: Upgrade");
        this.write(CRLF);
        this.write("Sec-WebSocket-Key: " + this.eF());
        this.write(CRLF);
        if (clientHandshake.pu != null && !clientHandshake.pu.equals("")) {
            this.write("Origin: " + clientHandshake.pu);
            this.write(CRLF);
        }
        if (clientHandshake.pv != null && clientHandshake.pv.length > 0) {
            this.write("Sec-WebSocket-Protocol: ");
            for (int i2 = 0; i2 < clientHandshake.pv.length; ++i2) {
                this.write(clientHandshake.pv[i2]);
                if (i2 == clientHandshake.pv.length - 1) continue;
                this.write(", ");
            }
            this.write(CRLF);
        }
        this.write("Sec-WebSocket-Version: 13");
        this.write(CRLF);
        if (clientHandshake.pw != null) {
            for (String string2 : clientHandshake.pw.keySet()) {
                this.write(string2 + ":" + clientHandshake.pw.get(string2));
                this.write(CRLF);
            }
        }
        this.write(CRLF);
    }

    private void a(Close close) {
        if (close.px > 0) {
            byte[] byArray;
            if (close.py != null && !close.py.equals("")) {
                byte[] byArray2 = close.py.getBytes("UTF-8");
                byArray = new byte[2 + byArray2.length];
                for (int i2 = 0; i2 < byArray2.length; ++i2) {
                    byArray[i2 + 2] = byArray2[i2];
                }
            } else {
                byArray = new byte[2];
            }
            if (byArray != null && byArray.length > 125) {
                throw new WebSocketException("close payload exceeds 125 octets");
            }
            byArray[0] = (byte)(close.px >> 8 & 0xFF);
            byArray[1] = (byte)(close.px & 0xFF);
            this.a(8, true, byArray);
        } else {
            this.a(8, true, null);
        }
    }

    private void a(Ping ping) {
        if (ping.pp != null && ping.pp.length > 125) {
            throw new WebSocketException("ping payload exceeds 125 octets");
        }
        this.a(9, true, ping.pp);
    }

    private void a(Pong pong) {
        if (pong.pp != null && pong.pp.length > 125) {
            throw new WebSocketException("pong payload exceeds 125 octets");
        }
        this.a(10, true, pong.pp);
        og.bu("WebSockets Pong Sent");
    }

    private void a(BinaryMessage binaryMessage) {
        if (binaryMessage.pp.length > this.oy.eJ()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.a(2, true, binaryMessage.pp);
    }

    private void a(TextMessage textMessage) {
        byte[] byArray = textMessage.pG.getBytes("UTF-8");
        if (byArray.length > this.oy.eJ()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.a(1, true, byArray);
    }

    private void a(RawTextMessage rawTextMessage) {
        if (rawTextMessage.pp.length > this.oy.eJ()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.a(1, true, rawTextMessage.pp);
    }

    protected void a(int n2, boolean bl, byte[] byArray) {
        if (byArray != null) {
            this.a(n2, bl, byArray, 0, byArray.length);
        } else {
            this.a(n2, bl, null, 0, 0);
        }
    }

    protected void a(int n2, boolean bl, byte[] byArray, int n3, int n4) {
        long l2;
        byte by = 0;
        if (bl) {
            by = (byte)(by | 0xFFFFFF80);
        }
        by = (byte)(by | (byte)n2);
        this.a(by);
        byte by2 = 0;
        if (this.oy.eN()) {
            by2 = -128;
        }
        if ((l2 = (long)n4) <= 125L) {
            by2 = (byte)(by2 | (byte)l2);
            this.a(by2);
        } else if (l2 <= 65535L) {
            by2 = (byte)(by2 | 0x7E);
            this.a(by2);
            this.write(new byte[]{(byte)(l2 >> 8 & 0xFFL), (byte)(l2 & 0xFFL)});
        } else {
            by2 = (byte)(by2 | 0x7F);
            this.a(by2);
            this.write(new byte[]{(byte)(l2 >> 56 & 0xFFL), (byte)(l2 >> 48 & 0xFFL), (byte)(l2 >> 40 & 0xFFL), (byte)(l2 >> 32 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)(l2 & 0xFFL)});
        }
        byte[] byArray2 = null;
        if (this.oy.eN()) {
            byArray2 = this.eG();
            this.a(byArray2[0]);
            this.a(byArray2[1]);
            this.a(byArray2[2]);
            this.a(byArray2[3]);
        }
        if (l2 > 0L) {
            if (this.oy.eN()) {
                int n5 = 0;
                while ((long)n5 < l2) {
                    int n6 = n5 + n3;
                    byArray[n6] = (byte)(byArray[n6] ^ byArray2[n5 % 4]);
                    ++n5;
                }
            }
            this.pg.write(byArray, n3, n4);
        }
    }

    public void handleMessage(Message message) {
        try {
            this.g(message.obj);
            if (this.oz && this.ol.isConnected() && !this.ol.isClosed()) {
                this.pg.flush();
            }
            if (message.obj instanceof Close) {
                Close close = (Close)message.obj;
                if (close.pz) {
                    this.f(new Close(close.px, close.py, true));
                }
            }
        }
        catch (SocketException socketException) {
            og.bu("run() : SocketException (" + socketException.toString() + ")");
            this.f(new ConnectionLost(null));
        }
        catch (Exception exception) {
            og.b(exception.getMessage(), exception);
            this.f(new Error(exception));
        }
    }

    protected void g(Object object) {
        if (object instanceof TextMessage) {
            this.a((TextMessage)object);
        } else if (object instanceof RawTextMessage) {
            this.a((RawTextMessage)object);
        } else if (object instanceof BinaryMessage) {
            this.a((BinaryMessage)object);
        } else if (object instanceof Ping) {
            this.a((Ping)object);
        } else if (object instanceof Pong) {
            this.a((Pong)object);
        } else if (object instanceof Close) {
            this.a((Close)object);
        } else if (object instanceof ClientHandshake) {
            this.a((ClientHandshake)object);
        } else if (object instanceof Quit) {
            this.pf.quit();
            this.oz = false;
            og.bu("Ended");
        } else {
            this.e(object);
        }
    }

    protected void e(Object object) {
        throw new WebSocketException("unknown message received by WebSocketWriter");
    }
}

