/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.IdentityHashMap;
import org.webrtc.AudioSink;
import org.webrtc.JNINamespace;
import org.webrtc.MediaStreamTrack;

@JNINamespace(value="webrtc::jni")
public class AudioTrack
extends MediaStreamTrack {
    private final IdentityHashMap<AudioSink, Long> sinks = new IdentityHashMap();

    public AudioTrack(long l2) {
        super(l2);
    }

    public void setVolume(double d2) {
        AudioTrack.nativeSetVolume(this.nativeTrack, d2);
    }

    public void addSink(AudioSink audioSink) {
        long l2 = AudioTrack.nativeWrapSink(audioSink);
        this.sinks.put(audioSink, l2);
        AudioTrack.nativeAddSink(this.nativeTrack, l2);
    }

    public void removeSink(AudioSink audioSink) {
        long l2 = this.sinks.remove(audioSink);
        if (l2 != 0L) {
            AudioTrack.nativeRemoveSink(this.nativeTrack, l2);
            AudioTrack.nativeFreeSink(l2);
        }
    }

    @Override
    public void dispose() {
        for (long l2 : this.sinks.values()) {
            AudioTrack.nativeRemoveSink(this.nativeTrack, l2);
            AudioTrack.nativeFreeSink(l2);
        }
        this.sinks.clear();
        super.dispose();
    }

    private static native void nativeSetVolume(long var0, double var2);

    private static native void nativeAddSink(long var0, long var2);

    private static native void nativeRemoveSink(long var0, long var2);

    private static native long nativeWrapSink(AudioSink var0);

    private static native void nativeFreeSink(long var0);
}

