/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.hardware.Camera;
import android.os.SystemClock;
import java.util.ArrayList;
import java.util.List;
import org.webrtc.Camera1Capturer;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.Logging;
import org.webrtc.Size;

public class Camera1Enumerator
implements CameraEnumerator {
    private static final String TAG = "Camera1Enumerator";
    private static List<List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats;
    private final boolean captureToTexture;

    public Camera1Enumerator() {
        this(true);
    }

    public Camera1Enumerator(boolean bl) {
        this.captureToTexture = bl;
    }

    @Override
    public String[] getDeviceNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < Camera.getNumberOfCameras(); ++i2) {
            String string = Camera1Enumerator.getDeviceName(i2);
            if (string != null) {
                arrayList.add(string);
                Logging.d(TAG, "Index: " + i2 + ". " + string);
                continue;
            }
            Logging.e(TAG, "Index: " + i2 + ". Failed to query camera name.");
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    @Override
    public boolean isFrontFacing(String string) {
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(string));
        return cameraInfo != null && cameraInfo.facing == 1;
    }

    @Override
    public boolean isBackFacing(String string) {
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(string));
        return cameraInfo != null && cameraInfo.facing == 0;
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(String string) {
        return Camera1Enumerator.getSupportedFormats(Camera1Enumerator.getCameraIndex(string));
    }

    @Override
    public CameraVideoCapturer createCapturer(String string, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler) {
        return new Camera1Capturer(string, cameraEventsHandler, this.captureToTexture);
    }

    private static Camera.CameraInfo getCameraInfo(int n2) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)n2, (Camera.CameraInfo)cameraInfo);
        }
        catch (Exception exception) {
            Logging.e(TAG, "getCameraInfo failed on index " + n2, exception);
            return null;
        }
        return cameraInfo;
    }

    static synchronized List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(int n2) {
        if (cachedSupportedFormats == null) {
            cachedSupportedFormats = new ArrayList<List<CameraEnumerationAndroid.CaptureFormat>>();
            for (int i2 = 0; i2 < Camera.getNumberOfCameras(); ++i2) {
                cachedSupportedFormats.add(Camera1Enumerator.enumerateFormats(i2));
            }
        }
        return cachedSupportedFormats.get(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CameraEnumerationAndroid.CaptureFormat> enumerateFormats(int n2) {
        Camera.Parameters parameters;
        Logging.d(TAG, "Get supported formats for camera index " + n2 + ".");
        long l2 = SystemClock.elapsedRealtime();
        Camera camera = null;
        try {
            Logging.d(TAG, "Opening camera with index " + n2);
            camera = Camera.open((int)n2);
            parameters = camera.getParameters();
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Open camera failed on camera index " + n2, runtimeException);
            ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            return arrayList;
        }
        finally {
            if (camera != null) {
                camera.release();
            }
        }
        ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
        try {
            Object object;
            Object exception;
            boolean n3 = false;
            boolean bl = false;
            List list = parameters.getSupportedPreviewFpsRange();
            if (list != null) {
                Object object2 = (int[])list.get(list.size() - 1);
                exception = object2[0];
                object = object2[1];
            }
            for (Camera.Size size : parameters.getSupportedPreviewSizes()) {
                arrayList.add(new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, (int)exception, (int)object));
            }
        }
        catch (Exception l3) {
            Logging.e(TAG, "getSupportedFormats() failed on camera index " + n2, l3);
        }
        long l3 = SystemClock.elapsedRealtime();
        Logging.d(TAG, "Get supported formats for camera index " + n2 + " done. Time spent: " + (l3 - l2) + " ms.");
        return arrayList;
    }

    static List<Size> convertSizes(List<Camera.Size> list) {
        ArrayList<Size> arrayList = new ArrayList<Size>();
        for (Camera.Size size : list) {
            arrayList.add(new Size(size.width, size.height));
        }
        return arrayList;
    }

    static List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> convertFramerates(List<int[]> list) {
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        for (int[] nArray : list) {
            arrayList.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange(nArray[0], nArray[1]));
        }
        return arrayList;
    }

    static int getCameraIndex(String string) {
        Logging.d(TAG, "getCameraIndex: " + string);
        for (int i2 = 0; i2 < Camera.getNumberOfCameras(); ++i2) {
            if (!string.equals(Camera1Enumerator.getDeviceName(i2))) continue;
            return i2;
        }
        throw new IllegalArgumentException("No such camera: " + string);
    }

    static String getDeviceName(int n2) {
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(n2);
        if (cameraInfo == null) {
            return null;
        }
        String string = cameraInfo.facing == 1 ? "front" : "back";
        return "Camera " + n2 + ", Facing " + string + ", Orientation " + cameraInfo.orientation;
    }
}

