/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Handler;
import android.os.SystemClock;
import android.view.WindowManager;
import com.ucloudrtclib.sdkengine.UCloudRtcSdkEnv;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.webrtc.Camera1Enumerator;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraSession;
import org.webrtc.Histogram;
import org.webrtc.Logging;
import org.webrtc.NV21Buffer;
import org.webrtc.RendererCommon;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoFrame;
import org.webrtc.ucloud.record.model.CameraParamObserver;

class Camera1Session
implements CameraSession {
    private static final String TAG = "Camera1Session";
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private static final Histogram camera1StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StartTimeMs", 1, 10000, 50);
    private static final Histogram camera1StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StopTimeMs", 1, 10000, 50);
    private static final Histogram camera1ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera1.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private final Handler cameraThreadHandler;
    private final CameraSession.Events events;
    private final boolean captureToTexture;
    private final Context applicationContext;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final int cameraId;
    private final Camera camera;
    private final Camera.CameraInfo info;
    private final CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final long constructionTimeNs;
    private SessionState state;
    private boolean firstFrameReported = false;
    static CameraParamObserver mParamObserver;

    public static void create(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, boolean bl, Context context, SurfaceTextureHelper surfaceTextureHelper, MediaRecorder mediaRecorder, int n2, int n3, int n4, int n5, CameraParamObserver cameraParamObserver) {
        Camera camera;
        mParamObserver = cameraParamObserver;
        long l2 = System.nanoTime();
        Logging.d(TAG, "Open camera " + n2);
        events.onCameraOpening();
        try {
            camera = Camera.open((int)n2);
        }
        catch (RuntimeException runtimeException) {
            createSessionCallback.onFailure(CameraSession.FailureType.ERROR, runtimeException.getMessage());
            return;
        }
        if (camera == null) {
            createSessionCallback.onFailure(CameraSession.FailureType.ERROR, "android.hardware.Camera.open returned null for camera id = " + n2);
            return;
        }
        try {
            camera.setPreviewTexture(surfaceTextureHelper.getSurfaceTexture());
        }
        catch (IOException | RuntimeException exception) {
            camera.release();
            createSessionCallback.onFailure(CameraSession.FailureType.ERROR, exception.getMessage());
            return;
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n2, (Camera.CameraInfo)cameraInfo);
        Camera.Parameters parameters = camera.getParameters();
        CameraEnumerationAndroid.CaptureFormat captureFormat = Camera1Session.findClosestCaptureFormat(parameters, n3, n4, n5);
        Size size = Camera1Session.findClosestPictureSize(parameters, n3, n4);
        Camera1Session.updateCameraParameters(camera, parameters, captureFormat, size, bl);
        if (!bl) {
            int n6 = captureFormat.frameSize();
            for (int i2 = 0; i2 < 3; ++i2) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n6);
                camera.addCallbackBuffer(byteBuffer.array());
            }
        }
        camera.setDisplayOrientation(0);
        createSessionCallback.onDone(new Camera1Session(events, bl, context, surfaceTextureHelper, mediaRecorder, n2, camera, cameraInfo, captureFormat, l2));
    }

    @Override
    public CameraSession.CameraParam requestCamera() {
        CameraSession.CameraParam cameraParam = new CameraSession.CameraParam();
        boolean bl = true;
        if (this.info != null) {
            bl = this.info.facing == 1;
        }
        cameraParam.setFrontCamera(bl);
        return cameraParam;
    }

    private static void updateCameraParameters(Camera camera, Camera.Parameters parameters, CameraEnumerationAndroid.CaptureFormat captureFormat, Size size, boolean bl) {
        List list = parameters.getSupportedFocusModes();
        parameters.setPreviewFpsRange(captureFormat.framerate.min, captureFormat.framerate.max);
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        parameters.setPictureSize(size.width, size.height);
        if (!bl) {
            parameters.setPreviewFormat(captureFormat.imageFormat);
        }
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (list.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        camera.setParameters(parameters);
    }

    private static CameraEnumerationAndroid.CaptureFormat findClosestCaptureFormat(Camera.Parameters parameters, int n2, int n3, int n4) {
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> list = Camera1Enumerator.convertFramerates(parameters.getSupportedPreviewFpsRange());
        Logging.d(TAG, "Available fps ranges: " + list);
        CameraEnumerationAndroid.CaptureFormat.FramerateRange framerateRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(list, n4);
        Size size = CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPreviewSizes()), n2, n3);
        CameraEnumerationAndroid.reportCameraResolution(camera1ResolutionHistogram, size);
        return new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, framerateRange);
    }

    private static Size findClosestPictureSize(Camera.Parameters parameters, int n2, int n3) {
        return CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPictureSizes()), n2, n3);
    }

    private Camera1Session(CameraSession.Events events, boolean bl, Context context, SurfaceTextureHelper surfaceTextureHelper, MediaRecorder mediaRecorder, int n2, Camera camera, Camera.CameraInfo cameraInfo, CameraEnumerationAndroid.CaptureFormat captureFormat, long l2) {
        Logging.d(TAG, "Create new camera1 session on camera " + n2);
        this.cameraThreadHandler = new Handler();
        this.events = events;
        this.captureToTexture = bl;
        this.applicationContext = context;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = n2;
        this.camera = camera;
        this.info = cameraInfo;
        this.captureFormat = captureFormat;
        this.constructionTimeNs = l2;
        this.startCapturing();
        if (mediaRecorder != null) {
            camera.unlock();
            mediaRecorder.setCamera(camera);
        }
    }

    @Override
    public void stop() {
        Logging.d(TAG, "Stop camera1 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long l2 = System.nanoTime();
            this.stopInternal();
            int n2 = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
            camera1StopTimeMsHistogram.addSample(n2);
        }
    }

    private void startCapturing() {
        Logging.d(TAG, "Start capturing");
        this.checkIsOnCameraThread();
        this.state = SessionState.RUNNING;
        this.camera.getParameters().getPictureSize();
        this.camera.setErrorCallback(new Camera.ErrorCallback(){

            public void onError(int n2, Camera camera) {
                String string = n2 == 100 ? "Camera server died!" : "Camera error: " + n2;
                Logging.e(Camera1Session.TAG, string);
                Camera1Session.this.stopInternal();
                if (n2 == 2) {
                    Camera1Session.this.events.onCameraDisconnected(Camera1Session.this);
                } else {
                    Camera1Session.this.events.onCameraError(Camera1Session.this, string);
                }
            }
        });
        if (this.captureToTexture) {
            this.listenForTextureFrames();
        } else {
            this.listenForBytebufferFrames();
        }
        try {
            this.camera.startPreview();
            Camera.Size size = this.camera.getParameters().getPictureSize();
            this.camera.getParameters().getPreviewFrameRate();
            mParamObserver.reportCameraOpenParam(size.width, size.height, this.getDeviceOrientation(), this.camera.getParameters().getPreviewFrameRate());
        }
        catch (RuntimeException runtimeException) {
            this.stopInternal();
            this.events.onCameraError(this, runtimeException.getMessage());
        }
    }

    private void stopInternal() {
        Logging.d(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        if (this.state == SessionState.STOPPED) {
            Logging.d(TAG, "Camera is already stopped");
            return;
        }
        this.state = SessionState.STOPPED;
        this.surfaceTextureHelper.stopListening();
        this.camera.stopPreview();
        this.camera.release();
        this.events.onCameraClosed(this);
        Logging.d(TAG, "Stop done");
    }

    private void listenForTextureFrames() {
        this.surfaceTextureHelper.startListening(new SurfaceTextureHelper.OnTextureFrameAvailableListener(){

            @Override
            public void onTextureFrameAvailable(int n2, float[] fArray, long l2) {
                int n3;
                Camera1Session.this.checkIsOnCameraThread();
                if (Camera1Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera1Session.TAG, "Texture frame captured but camera is no longer running.");
                    Camera1Session.this.surfaceTextureHelper.returnTextureFrame();
                    return;
                }
                if (!Camera1Session.this.firstFrameReported) {
                    n3 = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera1Session.this.constructionTimeNs);
                    camera1StartTimeMsHistogram.addSample(n3);
                    Camera1Session.this.firstFrameReported = true;
                }
                n3 = Camera1Session.this.getFrameOrientation();
                if (((Camera1Session)Camera1Session.this).info.facing == 1) {
                    if (!UCloudRtcSdkEnv.isFrontCameraMirror()) {
                        fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
                    } else if (90 != Camera1Session.this.getDeviceOrientation()) {
                        n3 = Camera1Session.this.getFrameOrientation() - 180;
                    }
                }
                VideoFrame.TextureBuffer textureBuffer = Camera1Session.this.surfaceTextureHelper.createTextureBuffer(((Camera1Session)Camera1Session.this).captureFormat.width, ((Camera1Session)Camera1Session.this).captureFormat.height, RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray));
                VideoFrame videoFrame = new VideoFrame(textureBuffer, n3, l2);
                Camera1Session.this.events.onFrameCaptured(Camera1Session.this, videoFrame);
                videoFrame.release();
            }
        });
    }

    private void listenForBytebufferFrames() {
        this.camera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] byArray, Camera camera) {
                boolean bl;
                Camera1Session.this.checkIsOnCameraThread();
                if (camera != Camera1Session.this.camera) {
                    Logging.e(Camera1Session.TAG, "Callback from a different camera. This should never happen.");
                    return;
                }
                if (Camera1Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera1Session.TAG, "Bytebuffer frame captured but camera is no longer running.");
                    return;
                }
                long l2 = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                if (!Camera1Session.this.firstFrameReported) {
                    int n2 = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera1Session.this.constructionTimeNs);
                    camera1StartTimeMsHistogram.addSample(n2);
                    Camera1Session.this.firstFrameReported = true;
                }
                NV21Buffer nV21Buffer = new NV21Buffer(byArray, ((Camera1Session)Camera1Session.this).captureFormat.width, ((Camera1Session)Camera1Session.this).captureFormat.height, () -> Camera1Session.this.cameraThreadHandler.post(() -> {
                    if (Camera1Session.this.state == SessionState.RUNNING) {
                        Camera1Session.this.camera.addCallbackBuffer(byArray);
                    }
                }));
                boolean bl2 = ((Camera1Session)Camera1Session.this).info.facing == 1;
                boolean bl3 = bl = bl2 && UCloudRtcSdkEnv.isFrontCameraMirror();
                VideoFrame videoFrame = 90 == Camera1Session.this.getDeviceOrientation() || 270 == Camera1Session.this.getDeviceOrientation() ? new VideoFrame(nV21Buffer, Camera1Session.this.getFrameOrientation(), l2) : new VideoFrame(nV21Buffer, bl ? Camera1Session.this.getFrameOrientation() - 180 : Camera1Session.this.getFrameOrientation(), l2);
                Camera1Session.this.events.onFrameCaptured(Camera1Session.this, videoFrame, bl);
                videoFrame.release();
            }
        });
    }

    private int getDeviceOrientation() {
        int n2 = 0;
        WindowManager windowManager = (WindowManager)this.applicationContext.getSystemService("window");
        switch (windowManager.getDefaultDisplay().getRotation()) {
            case 1: {
                n2 = 90;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    private int adapterUserSelect(int n2) {
        int n3 = n2;
        switch (UCloudRtcSdkEnv.getPushOrientation()) {
            case UCLOUD_RTC_PUSH_LANDSCAPE_MODE: {
                if (n3 != 0 && n3 != 180) break;
                n3 = 90;
                break;
            }
            case UCLOUD_RTC_PUSH_PORTRAIT_MODE: {
                if (n3 != 90 && n3 != 270) break;
                n3 = 0;
            }
        }
        return n3;
    }

    private int getFrameOrientation() {
        int n2 = this.adapterUserSelect(this.getDeviceOrientation());
        if (this.info.facing == 0) {
            n2 = 360 - n2;
        }
        return (this.info.orientation + n2) % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    public Camera.CameraInfo getInfo() {
        return this.info;
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

