/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.os.SystemClock;
import android.util.AndroidException;
import android.util.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.webrtc.Camera2Capturer;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.Logging;
import org.webrtc.Size;

@TargetApi(value=21)
public class Camera2Enumerator
implements CameraEnumerator {
    private static final String TAG = "Camera2Enumerator";
    private static final double NANO_SECONDS_PER_SECOND = 1.0E9;
    private static final Map<String, List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats = new HashMap<String, List<CameraEnumerationAndroid.CaptureFormat>>();
    final Context context;
    final CameraManager cameraManager;

    public Camera2Enumerator(Context context) {
        this.context = context;
        this.cameraManager = (CameraManager)context.getSystemService("camera");
    }

    @Override
    public String[] getDeviceNames() {
        try {
            return this.cameraManager.getCameraIdList();
        }
        catch (AndroidException androidException) {
            Logging.e(TAG, "Camera access exception: " + (Object)((Object)androidException));
            return new String[0];
        }
    }

    @Override
    public boolean isFrontFacing(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        return cameraCharacteristics != null && (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
    }

    @Override
    public boolean isBackFacing(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        return cameraCharacteristics != null && (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 1;
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(String string) {
        return Camera2Enumerator.getSupportedFormats(this.context, string);
    }

    @Override
    public CameraVideoCapturer createCapturer(String string, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler) {
        return new Camera2Capturer(this.context, string, cameraEventsHandler);
    }

    private CameraCharacteristics getCameraCharacteristics(String string) {
        try {
            return this.cameraManager.getCameraCharacteristics(string);
        }
        catch (AndroidException androidException) {
            Logging.e(TAG, "Camera access exception: " + (Object)((Object)androidException));
            return null;
        }
    }

    public static boolean isSupported(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        try {
            String[] stringArray;
            for (String string : stringArray = cameraManager.getCameraIdList()) {
                CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(string);
                if ((Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL) != 2) continue;
                return false;
            }
        }
        catch (AndroidException androidException) {
            Logging.e(TAG, "Camera access exception: " + (Object)((Object)androidException));
            return false;
        }
        return true;
    }

    static int getFpsUnitFactor(Range<Integer>[] rangeArray) {
        if (rangeArray.length == 0) {
            return 1000;
        }
        return (Integer)rangeArray[0].getUpper() < 1000 ? 1000 : 1;
    }

    static List<Size> getSupportedSizes(CameraCharacteristics cameraCharacteristics) {
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        int n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        android.util.Size[] sizeArray = streamConfigurationMap.getOutputSizes(SurfaceTexture.class);
        if (sizeArray == null) {
            Logging.d(TAG, "getOutputSizes is null");
            return new ArrayList<Size>();
        }
        List<Size> list = Camera2Enumerator.convertSizes(sizeArray);
        if (Build.VERSION.SDK_INT < 22 && n2 == 2) {
            Rect rect = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            ArrayList<Size> arrayList = new ArrayList<Size>();
            for (Size size : list) {
                if (rect.width() * size.height != rect.height() * size.width) continue;
                arrayList.add(size);
            }
            return arrayList;
        }
        return list;
    }

    static List<Size> getSupportedPictureSizes(CameraCharacteristics cameraCharacteristics) {
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        int n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        android.util.Size[] sizeArray = streamConfigurationMap.getOutputSizes(256);
        List<Size> list = Camera2Enumerator.convertSizes(sizeArray);
        if (Build.VERSION.SDK_INT < 22 && n2 == 2) {
            Rect rect = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            ArrayList<Size> arrayList = new ArrayList<Size>();
            for (Size size : list) {
                if (rect.width() * size.height != rect.height() * size.width) continue;
                arrayList.add(size);
            }
            return arrayList;
        }
        return list;
    }

    static List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(Context context, String string) {
        return Camera2Enumerator.getSupportedFormats((CameraManager)context.getSystemService("camera"), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(CameraManager cameraManager, String string) {
        Map<String, List<CameraEnumerationAndroid.CaptureFormat>> map = cachedSupportedFormats;
        synchronized (map) {
            CameraCharacteristics cameraCharacteristics;
            if (cachedSupportedFormats.containsKey(string)) {
                return cachedSupportedFormats.get(string);
            }
            Logging.d(TAG, "Get supported formats for camera index " + string + ".");
            long l2 = SystemClock.elapsedRealtime();
            try {
                cameraCharacteristics = cameraManager.getCameraCharacteristics(string);
            }
            catch (Exception exception) {
                Logging.e(TAG, "getCameraCharacteristics(): " + exception);
                return new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            }
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            Range[] rangeArray = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> list = Camera2Enumerator.convertFramerates(rangeArray, Camera2Enumerator.getFpsUnitFactor(rangeArray));
            List<Size> list2 = Camera2Enumerator.getSupportedSizes(cameraCharacteristics);
            if (list2.isEmpty()) {
                Logging.e(TAG, "getSupportedSizes is null");
                return new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            }
            int n2 = 0;
            for (CameraEnumerationAndroid.CaptureFormat.FramerateRange object : list) {
                n2 = Math.max(n2, object.max);
            }
            ArrayList arrayList = new ArrayList();
            for (Size size : list2) {
                long l3 = 0L;
                try {
                    l3 = streamConfigurationMap.getOutputMinFrameDuration(SurfaceTexture.class, new android.util.Size(size.width, size.height));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int exception = l3 == 0L ? n2 : (int)Math.round(1.0E9 / (double)l3) * 1000;
                arrayList.add(new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, 0, exception));
                Logging.d(TAG, "Format: " + size.width + "x" + size.height + "@" + exception);
            }
            cachedSupportedFormats.put(string, arrayList);
            long l4 = SystemClock.elapsedRealtime();
            Logging.d(TAG, "Get supported formats for camera index " + string + " done. Time spent: " + (l4 - l2) + " ms.");
            return arrayList;
        }
    }

    private static List<Size> convertSizes(android.util.Size[] sizeArray) {
        ArrayList<Size> arrayList = new ArrayList<Size>();
        for (android.util.Size size : sizeArray) {
            arrayList.add(new Size(size.getWidth(), size.getHeight()));
        }
        return arrayList;
    }

    static List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> convertFramerates(Range<Integer>[] rangeArray, int n2) {
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        for (Range<Integer> range : rangeArray) {
            arrayList.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange((Integer)range.getLower() * n2, (Integer)range.getUpper() * n2));
        }
        return arrayList;
    }
}

