/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.media.MediaRecorder;
import android.os.Handler;
import android.util.Range;
import android.view.Surface;
import android.view.WindowManager;
import com.ucloudrtclib.a.i;
import com.ucloudrtclib.sdkengine.UCloudRtcSdkEnv;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraSession;
import org.webrtc.Histogram;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoFrame;
import org.webrtc.ucloud.record.model.CameraParamObserver;

@TargetApi(value=21)
class Camera2Session
implements CameraSession {
    private static final String TAG = "Camera2Session";
    private static final Histogram camera2StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StartTimeMs", 1, 10000, 50);
    private static final Histogram camera2StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StopTimeMs", 1, 10000, 50);
    private static final Histogram camera2ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera2.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private final Handler cameraThreadHandler;
    private final CameraSession.CreateSessionCallback callback;
    private final CameraSession.Events events;
    private final Context applicationContext;
    private final CameraManager cameraManager;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final Surface mediaRecorderSurface;
    private final String cameraId;
    private final int width;
    private final int height;
    private final int framerate;
    private CameraParamObserver mURTCRecordObserver;
    private CameraCharacteristics cameraCharacteristics;
    private int cameraOrientation;
    private boolean isCameraFrontFacing;
    private int fpsUnitFactor;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    private CameraDevice cameraDevice;
    private Surface surface;
    private CameraCaptureSession captureSession;
    private SessionState state = SessionState.RUNNING;
    private boolean firstFrameReported = false;
    private final long constructionTimeNs;

    public void setURTCRecordObserver(CameraParamObserver cameraParamObserver) {
        this.mURTCRecordObserver = cameraParamObserver;
    }

    public static void create(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context context, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, MediaRecorder mediaRecorder, String string, int n2, int n3, int n4, CameraParamObserver cameraParamObserver) {
        Camera2Session camera2Session = new Camera2Session(createSessionCallback, events, context, cameraManager, surfaceTextureHelper, mediaRecorder, string, n2, n3, n4);
        camera2Session.setURTCRecordObserver(cameraParamObserver);
    }

    private Camera2Session(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context context, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, MediaRecorder mediaRecorder, String string, int n2, int n3, int n4) {
        Logging.d(TAG, "Create new camera2 session on camera " + string);
        i.d(TAG, "Create new camera2 session on camera " + string);
        this.constructionTimeNs = System.nanoTime();
        this.cameraThreadHandler = new Handler();
        this.callback = createSessionCallback;
        this.events = events;
        this.applicationContext = context;
        this.cameraManager = cameraManager;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.mediaRecorderSurface = mediaRecorder != null ? mediaRecorder.getSurface() : null;
        this.cameraId = string;
        this.width = n2;
        this.height = n3;
        this.framerate = n4;
        this.start();
    }

    private void start() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "start");
        i.d(TAG, "start");
        try {
            this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
        }
        catch (CameraAccessException cameraAccessException) {
            this.reportError("getCameraCharacteristics(): " + cameraAccessException.getMessage());
            i.d(TAG, "getCameraCharacteristics(): " + cameraAccessException.getMessage());
            return;
        }
        this.cameraOrientation = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.isCameraFrontFacing = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
        this.findCaptureFormat();
        this.openCamera();
    }

    private void findCaptureFormat() {
        this.checkIsOnCameraThread();
        Range[] rangeArray = (Range[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        this.fpsUnitFactor = Camera2Enumerator.getFpsUnitFactor(rangeArray);
        List<Size> list = Camera2Enumerator.getSupportedSizes(this.cameraCharacteristics);
        if (list.isEmpty()) {
            this.reportError("No supported output sizes.");
            i.d(TAG, "No supported output sizes.");
            return;
        }
        Logging.d(TAG, "Available preview sizes: " + list);
        i.d(TAG, "Available preview sizes: " + list);
        List<Size> list2 = Camera2Enumerator.getSupportedPictureSizes(this.cameraCharacteristics);
        Logging.d(TAG, "Available picture sizes: " + list2);
        i.d(TAG, "Available picture sizes: " + list2);
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> list3 = Camera2Enumerator.convertFramerates(rangeArray, this.fpsUnitFactor);
        Logging.d(TAG, "Available fps ranges: " + list3);
        i.d(TAG, "Available fps ranges: " + list3);
        if (list3.isEmpty() || list2.isEmpty()) {
            this.reportError("No supported capture formats.");
            i.d(TAG, "No supported capture formats.");
            return;
        }
        CameraEnumerationAndroid.CaptureFormat.FramerateRange framerateRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(list3, this.framerate);
        Size size = CameraEnumerationAndroid.getClosestSupportedSize(list2, this.width, this.height);
        CameraEnumerationAndroid.reportCameraResolution(camera2ResolutionHistogram, size);
        this.captureFormat = new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, framerateRange);
        Logging.d(TAG, "Using capture format: " + this.captureFormat);
        i.d(TAG, "Using capture format: " + this.captureFormat);
    }

    private void openCamera() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "Opening camera " + this.cameraId);
        i.d(TAG, "Opening camera " + this.cameraId);
        this.events.onCameraOpening();
        try {
            this.cameraManager.openCamera(this.cameraId, (CameraDevice.StateCallback)new CameraStateCallback(), this.cameraThreadHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            this.reportError("Failed to open camera: " + (Object)((Object)cameraAccessException));
            return;
        }
    }

    @Override
    public CameraSession.CameraParam requestCamera() {
        CameraSession.CameraParam cameraParam = new CameraSession.CameraParam();
        cameraParam.setFrontCamera(this.isCameraFrontFacing);
        return cameraParam;
    }

    @Override
    public void stop() {
        Logging.d(TAG, "Stop camera2 session on camera " + this.cameraId);
        i.d(TAG, "Stop camera2 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long l2 = System.nanoTime();
            this.state = SessionState.STOPPED;
            this.stopInternal();
            int n2 = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
            camera2StopTimeMsHistogram.addSample(n2);
        }
    }

    private void stopInternal() {
        Logging.d(TAG, "Stop internal");
        i.d(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        this.surfaceTextureHelper.stopListening();
        if (this.captureSession != null) {
            this.captureSession.close();
            this.captureSession = null;
        }
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
        Logging.d(TAG, "Stop done");
        i.d(TAG, "Stop done");
    }

    private void reportError(String string) {
        this.checkIsOnCameraThread();
        Logging.e(TAG, "Error: " + string);
        boolean bl = this.captureSession == null && this.state != SessionState.STOPPED;
        this.state = SessionState.STOPPED;
        this.stopInternal();
        if (bl) {
            this.callback.onFailure(CameraSession.FailureType.ERROR, string);
        } else {
            this.events.onCameraError(this, string);
        }
    }

    private int getDeviceOrientation() {
        int n2 = 0;
        WindowManager windowManager = (WindowManager)this.applicationContext.getSystemService("window");
        switch (windowManager.getDefaultDisplay().getRotation()) {
            case 1: {
                n2 = 90;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    private int getFrameOrientation() {
        int n2 = this.adapterUserSelect(this.getDeviceOrientation());
        if (!this.isCameraFrontFacing) {
            n2 = 360 - n2;
        }
        return (this.cameraOrientation + n2) % 360;
    }

    private int adapterUserSelect(int n2) {
        int n3 = n2;
        switch (UCloudRtcSdkEnv.getPushOrientation()) {
            case UCLOUD_RTC_PUSH_LANDSCAPE_MODE: {
                if (n3 != 0 && n3 != 180) break;
                n3 = 90;
                break;
            }
            case UCLOUD_RTC_PUSH_PORTRAIT_MODE: {
                if (n3 != 90 && n3 != 270) break;
                n3 = 0;
            }
        }
        return n3;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private static class CameraCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private CameraCaptureCallback() {
        }

        public void onCaptureFailed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureFailure captureFailure) {
            Logging.d(Camera2Session.TAG, "Capture failed: " + captureFailure);
            i.d(Camera2Session.TAG, "Capture failed: " + captureFailure);
        }
    }

    private class CaptureSessionCallback
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionCallback() {
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            Camera2Session.this.checkIsOnCameraThread();
            cameraCaptureSession.close();
            i.d(Camera2Session.TAG, "Failed to configure capture session.");
            Camera2Session.this.reportError("Failed to configure capture session.");
        }

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera capture session configured.");
            i.d(Camera2Session.TAG, "Camera capture session configured.");
            Camera2Session.this.captureSession = cameraCaptureSession;
            try {
                CaptureRequest.Builder builder = Camera2Session.this.cameraDevice.createCaptureRequest(3);
                builder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.min / Camera2Session.this.fpsUnitFactor), (Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.max / Camera2Session.this.fpsUnitFactor)));
                builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                builder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
                this.chooseStabilizationMode(builder);
                this.chooseFocusMode(builder);
                builder.addTarget(Camera2Session.this.surface);
                if (Camera2Session.this.mediaRecorderSurface != null) {
                    Logging.d(Camera2Session.TAG, "Add MediaRecorder surface to CaptureRequest.Builder");
                    builder.addTarget(Camera2Session.this.mediaRecorderSurface);
                }
                cameraCaptureSession.setRepeatingRequest(builder.build(), (CameraCaptureSession.CaptureCallback)new CameraCaptureCallback(), Camera2Session.this.cameraThreadHandler);
            }
            catch (CameraAccessException cameraAccessException) {
                Camera2Session.this.reportError("Failed to start capture request. " + (Object)((Object)cameraAccessException));
                i.d(Camera2Session.TAG, "Failed to start capture request. " + (Object)((Object)cameraAccessException));
                return;
            }
            Camera2Session.this.surfaceTextureHelper.startListening(new SurfaceTextureHelper.OnTextureFrameAvailableListener(){

                @Override
                public void onTextureFrameAvailable(int n2, float[] fArray, long l2) {
                    int n3;
                    Camera2Session.this.checkIsOnCameraThread();
                    if (Camera2Session.this.state != SessionState.RUNNING) {
                        Logging.d(Camera2Session.TAG, "Texture frame captured but camera is no longer running.");
                        Camera2Session.this.surfaceTextureHelper.returnTextureFrame();
                        return;
                    }
                    if (!Camera2Session.this.firstFrameReported) {
                        Camera2Session.this.firstFrameReported = true;
                        n3 = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera2Session.this.constructionTimeNs);
                        camera2StartTimeMsHistogram.addSample(n3);
                    }
                    n3 = Camera2Session.this.getFrameOrientation();
                    if (Camera2Session.this.isCameraFrontFacing) {
                        if (!UCloudRtcSdkEnv.isFrontCameraMirror()) {
                            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
                            fArray = RendererCommon.rotateTextureMatrix(fArray, -Camera2Session.this.cameraOrientation);
                        } else {
                            fArray = 0 == Camera2Session.this.getDeviceOrientation() ? RendererCommon.rotateTextureMatrix(fArray, -Camera2Session.this.cameraOrientation) : RendererCommon.rotateTextureMatrix(fArray, Camera2Session.this.cameraOrientation);
                        }
                    } else {
                        fArray = RendererCommon.rotateTextureMatrix(fArray, -Camera2Session.this.cameraOrientation);
                    }
                    VideoFrame.TextureBuffer textureBuffer = Camera2Session.this.surfaceTextureHelper.createTextureBuffer(((Camera2Session)Camera2Session.this).captureFormat.width, ((Camera2Session)Camera2Session.this).captureFormat.height, RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray));
                    VideoFrame videoFrame = new VideoFrame(textureBuffer, n3, l2);
                    Camera2Session.this.events.onFrameCaptured(Camera2Session.this, videoFrame);
                    videoFrame.release();
                }
            });
            Logging.d(Camera2Session.TAG, "Camera device successfully started.");
            i.d(Camera2Session.TAG, "Camera device successfully started.");
            Camera2Session.this.callback.onDone(Camera2Session.this);
        }

        private void chooseStabilizationMode(CaptureRequest.Builder builder) {
            int[] nArray;
            int[] nArray2 = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
            if (nArray2 != null) {
                nArray = nArray2;
                int n2 = nArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = nArray[i2];
                    if (n3 != 1) continue;
                    builder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
                    builder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
                    Logging.d(Camera2Session.TAG, "Using optical stabilization.");
                    return;
                }
            }
            for (int n4 : nArray = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES)) {
                if (n4 != 1) continue;
                builder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
                builder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
                Logging.d(Camera2Session.TAG, "Using video stabilization.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Stabilization not available.");
        }

        private void chooseFocusMode(CaptureRequest.Builder builder) {
            int[] nArray;
            for (int n2 : nArray = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES)) {
                if (n2 != 3) continue;
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                Logging.d(Camera2Session.TAG, "Using continuous video auto-focus.");
                i.d(Camera2Session.TAG, "Using continuous video auto-focus.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Auto-focus is not available.");
            i.d(Camera2Session.TAG, "Auto-focus is not available.");
        }
    }

    private class CameraStateCallback
    extends CameraDevice.StateCallback {
        private CameraStateCallback() {
        }

        private String getErrorDescription(int n2) {
            switch (n2) {
                case 4: {
                    return "Camera device has encountered a fatal error.";
                }
                case 3: {
                    return "Camera device could not be opened due to a device policy.";
                }
                case 1: {
                    return "Camera device is in use already.";
                }
                case 5: {
                    return "Camera service has encountered a fatal error.";
                }
                case 2: {
                    return "Camera device could not be opened because there are too many other open camera devices.";
                }
            }
            return "Unknown camera error: " + n2;
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            Camera2Session.this.checkIsOnCameraThread();
            i.d(Camera2Session.TAG, "onDisconnected: ");
            boolean bl = Camera2Session.this.captureSession == null && Camera2Session.this.state != SessionState.STOPPED;
            Camera2Session.this.state = SessionState.STOPPED;
            Camera2Session.this.stopInternal();
            if (bl) {
                Camera2Session.this.callback.onFailure(CameraSession.FailureType.DISCONNECTED, "Camera disconnected / evicted.");
            } else {
                Camera2Session.this.events.onCameraDisconnected(Camera2Session.this);
            }
        }

        public void onError(CameraDevice cameraDevice, int n2) {
            Camera2Session.this.checkIsOnCameraThread();
            i.d(Camera2Session.TAG, "onError: " + this.getErrorDescription(n2));
            Camera2Session.this.reportError(this.getErrorDescription(n2));
        }

        public void onOpened(CameraDevice cameraDevice) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera opened.");
            i.d(Camera2Session.TAG, "Camera opened.");
            Camera2Session.this.cameraDevice = cameraDevice;
            SurfaceTexture surfaceTexture = Camera2Session.this.surfaceTextureHelper.getSurfaceTexture();
            surfaceTexture.setDefaultBufferSize(((Camera2Session)Camera2Session.this).captureFormat.width, ((Camera2Session)Camera2Session.this).captureFormat.height);
            if (Camera2Session.this.mURTCRecordObserver != null) {
                i.d(Camera2Session.TAG, "Camera2SessiongetDeviceOrientation: " + Camera2Session.this.getDeviceOrientation());
                i.d(Camera2Session.TAG, "Camera2SessiongetFrameOrientation: " + Camera2Session.this.getFrameOrientation());
                Camera2Session.this.mURTCRecordObserver.reportCameraOpenParam(((Camera2Session)Camera2Session.this).captureFormat.width, ((Camera2Session)Camera2Session.this).captureFormat.height, Camera2Session.this.getDeviceOrientation(), Camera2Session.this.framerate);
            }
            Camera2Session.this.surface = new Surface(surfaceTexture);
            ArrayList<Surface> arrayList = new ArrayList<Surface>();
            arrayList.add(Camera2Session.this.surface);
            if (Camera2Session.this.mediaRecorderSurface != null) {
                Logging.d(Camera2Session.TAG, "Add MediaRecorder surface to capture session.");
                arrayList.add(Camera2Session.this.mediaRecorderSurface);
            }
            try {
                cameraDevice.createCaptureSession(arrayList, (CameraCaptureSession.StateCallback)new CaptureSessionCallback(), Camera2Session.this.cameraThreadHandler);
            }
            catch (CameraAccessException cameraAccessException) {
                Camera2Session.this.reportError("Failed to create capture session. " + (Object)((Object)cameraAccessException));
                return;
            }
        }

        public void onClosed(CameraDevice cameraDevice) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera device closed.");
            i.d(Camera2Session.TAG, "Camera device closed.");
            Camera2Session.this.events.onCameraClosed(Camera2Session.this);
        }
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

