/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.media.MediaRecorder;
import android.os.Handler;
import android.os.Looper;
import com.ucloudrtclib.a.i;
import java.util.Arrays;
import java.util.List;
import org.webrtc.Camera1Session;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraSession;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.Logging;
import org.webrtc.NV21Buffer;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;
import org.webrtc.ucloud.record.MediaRecorderNative;
import org.webrtc.ucloud.record.model.CameraParamObserver;

@TargetApi(value=21)
public abstract class CameraCapturer
implements CameraVideoCapturer {
    private static final String TAG = "CameraCapturer";
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    protected static final int OPEN_CAMERA_TIMEOUT = 10000;
    private final CameraEnumerator cameraEnumerator;
    private final CameraVideoCapturer.CameraEventsHandler eventsHandler;
    protected final Handler uiThreadHandler;
    private CameraSession.CameraParam mCameraParam;
    protected final CameraSession.CreateSessionCallback createSessionCallback = new CameraSession.CreateSessionCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDone(CameraSession cameraSession) {
            CameraCapturer.this.checkIsOnCameraThread();
            i.d(CameraCapturer.TAG, "Create session done. Switch state: " + (Object)((Object)CameraCapturer.this.switchState) + ". MediaRecorder state: " + (Object)((Object)CameraCapturer.this.mediaRecorderState));
            Logging.d(CameraCapturer.TAG, "Create session done. Switch state: " + (Object)((Object)CameraCapturer.this.switchState) + ". MediaRecorder state: " + (Object)((Object)CameraCapturer.this.mediaRecorderState));
            CameraCapturer.this.uiThreadHandler.removeCallbacks(CameraCapturer.this.openCameraTimeoutRunnable);
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.capturerObserver.onCapturerStarted(true);
                CameraCapturer.this.sessionOpening = false;
                CameraCapturer.this.currentSession = cameraSession;
                CameraCapturer.this.mCameraParam = CameraCapturer.this.currentSession.requestCamera();
                CameraCapturer.this.cameraStatistics = new CameraVideoCapturer.CameraStatistics(CameraCapturer.this.surfaceHelper, CameraCapturer.this.eventsHandler);
                CameraCapturer.this.firstFrameObserved = false;
                CameraCapturer.this.stateLock.notifyAll();
                if (CameraCapturer.this.switchState == SwitchState.IN_PROGRESS) {
                    if (CameraCapturer.this.switchEventsHandler != null) {
                        CameraCapturer.this.switchEventsHandler.onCameraSwitchDone(CameraCapturer.this.cameraEnumerator.isFrontFacing(CameraCapturer.this.cameraName));
                        CameraCapturer.this.switchEventsHandler = null;
                    }
                    CameraCapturer.this.switchState = SwitchState.IDLE;
                } else if (CameraCapturer.this.switchState == SwitchState.PENDING) {
                    CameraCapturer.this.switchState = SwitchState.IDLE;
                    CameraCapturer.this.switchCameraInternal(CameraCapturer.this.switchEventsHandler);
                }
                if (CameraCapturer.this.mediaRecorderState == MediaRecorderState.IDLE_TO_ACTIVE || CameraCapturer.this.mediaRecorderState == MediaRecorderState.ACTIVE_TO_IDLE) {
                    if (CameraCapturer.this.mediaRecorderEventsHandler != null) {
                        CameraCapturer.this.mediaRecorderEventsHandler.onMediaRecorderSuccess();
                        CameraCapturer.this.mediaRecorderEventsHandler = null;
                    }
                    if (CameraCapturer.this.mediaRecorderState == MediaRecorderState.IDLE_TO_ACTIVE) {
                        CameraCapturer.this.mediaRecorderState = MediaRecorderState.ACTIVE;
                    } else {
                        CameraCapturer.this.mediaRecorderState = MediaRecorderState.IDLE;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(CameraSession.FailureType failureType, String string) {
            CameraCapturer.this.checkIsOnCameraThread();
            CameraCapturer.this.uiThreadHandler.removeCallbacks(CameraCapturer.this.openCameraTimeoutRunnable);
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.capturerObserver.onCapturerStarted(false);
                CameraCapturer.this.openAttemptsRemaining--;
                if (CameraCapturer.this.openAttemptsRemaining <= 0) {
                    Logging.w(CameraCapturer.TAG, "Opening camera failed, passing: " + string);
                    CameraCapturer.this.sessionOpening = false;
                    CameraCapturer.this.stateLock.notifyAll();
                    if (CameraCapturer.this.switchState != SwitchState.IDLE) {
                        if (CameraCapturer.this.switchEventsHandler != null) {
                            CameraCapturer.this.switchEventsHandler.onCameraSwitchError(string);
                            CameraCapturer.this.switchEventsHandler = null;
                        }
                        CameraCapturer.this.switchState = SwitchState.IDLE;
                    }
                    if (CameraCapturer.this.mediaRecorderState != MediaRecorderState.IDLE) {
                        if (CameraCapturer.this.mediaRecorderEventsHandler != null) {
                            CameraCapturer.this.mediaRecorderEventsHandler.onMediaRecorderError(string);
                            CameraCapturer.this.mediaRecorderEventsHandler = null;
                        }
                        CameraCapturer.this.mediaRecorderState = MediaRecorderState.IDLE;
                    }
                    if (failureType == CameraSession.FailureType.DISCONNECTED) {
                        CameraCapturer.this.eventsHandler.onCameraDisconnected();
                    } else {
                        CameraCapturer.this.eventsHandler.onCameraError(string);
                    }
                } else {
                    Logging.w(CameraCapturer.TAG, "Opening camera failed, retry: " + string);
                    CameraCapturer.this.createSessionInternal(500, null);
                }
            }
        }
    };
    protected final CameraSession.Events cameraSessionEventsHandler = new CameraSession.Events(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraOpening() {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (CameraCapturer.this.currentSession != null) {
                    Logging.w(CameraCapturer.TAG, "onCameraOpening while session was open.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraOpening(CameraCapturer.this.cameraName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraError(CameraSession cameraSession, String string) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (cameraSession != CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onCameraError from another session: " + string);
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraError(string);
                CameraCapturer.this.stopCapture();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraDisconnected(CameraSession cameraSession) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (cameraSession != CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onCameraDisconnected from another session.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraDisconnected();
                CameraCapturer.this.stopCapture();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraClosed(CameraSession cameraSession) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (cameraSession != CameraCapturer.this.currentSession && CameraCapturer.this.currentSession != null) {
                    Logging.d(CameraCapturer.TAG, "onCameraClosed from another session.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraClosed();
                if (CameraCapturer.this.mParamObserver != null) {
                    CameraCapturer.this.mParamObserver.reportCameraClosed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrameCaptured(CameraSession cameraSession, VideoFrame videoFrame) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (cameraSession != CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onTextureFrameCaptured from another session.");
                    return;
                }
                if (!CameraCapturer.this.firstFrameObserved) {
                    CameraCapturer.this.eventsHandler.onFirstFrameAvailable();
                    CameraCapturer.this.firstFrameObserved = true;
                }
                CameraCapturer.this.cameraStatistics.addFrame();
                if (cameraSession instanceof Camera1Session && videoFrame.getBuffer() instanceof NV21Buffer) {
                    Camera1Session camera1Session = (Camera1Session)cameraSession;
                    NV21Buffer nV21Buffer = (NV21Buffer)videoFrame.getBuffer();
                    nV21Buffer.setNeedMirror(camera1Session.getInfo().facing == 1);
                }
                CameraCapturer.this.capturerObserver.onFrameCaptured(videoFrame);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrameCaptured(CameraSession cameraSession, VideoFrame videoFrame, boolean bl) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (cameraSession != CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onTextureFrameCaptured from another session.");
                    return;
                }
                if (!CameraCapturer.this.firstFrameObserved) {
                    CameraCapturer.this.eventsHandler.onFirstFrameAvailable();
                    CameraCapturer.this.firstFrameObserved = true;
                }
                CameraCapturer.this.cameraStatistics.addFrame();
                if (videoFrame.getBuffer() instanceof NV21Buffer) {
                    NV21Buffer nV21Buffer = (NV21Buffer)videoFrame.getBuffer();
                    nV21Buffer.setNeedMirror(bl);
                }
                CameraCapturer.this.capturerObserver.onFrameCaptured(videoFrame);
            }
        }
    };
    protected final Runnable openCameraTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            CameraCapturer.this.eventsHandler.onCameraError("Camera failed to start within timeout.");
        }
    };
    protected Handler cameraThreadHandler;
    protected Context applicationContext;
    private VideoCapturer.CapturerObserver capturerObserver;
    protected SurfaceTextureHelper surfaceHelper;
    private final Object stateLock = new Object();
    private boolean sessionOpening;
    private CameraSession currentSession;
    protected String cameraName;
    protected int width;
    protected int height;
    protected int framerate;
    private int openAttemptsRemaining;
    private SwitchState switchState = SwitchState.IDLE;
    private CameraVideoCapturer.CameraSwitchHandler switchEventsHandler;
    private CameraVideoCapturer.CameraStatistics cameraStatistics;
    private boolean firstFrameObserved;
    private MediaRecorderState mediaRecorderState = MediaRecorderState.IDLE;
    private CameraVideoCapturer.MediaRecorderHandler mediaRecorderEventsHandler;
    protected CameraParamObserver mParamObserver;

    public CameraSession.CameraParam requestCameraParam() {
        return this.mCameraParam;
    }

    public CameraCapturer(String string, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler, CameraEnumerator cameraEnumerator) {
        if (cameraEventsHandler == null) {
            cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

                @Override
                public void onCameraError(String string) {
                }

                @Override
                public void onCameraDisconnected() {
                }

                @Override
                public void onCameraFreezed(String string) {
                }

                @Override
                public void onCameraOpening(String string) {
                }

                @Override
                public void onFirstFrameAvailable() {
                }

                @Override
                public void onCameraClosed() {
                }
            };
        }
        this.eventsHandler = cameraEventsHandler;
        this.cameraEnumerator = cameraEnumerator;
        this.cameraName = string;
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        String[] stringArray = cameraEnumerator.getDeviceNames();
        if (stringArray.length == 0) {
            throw new RuntimeException("No cameras attached.");
        }
        if (!Arrays.asList(stringArray).contains(this.cameraName)) {
            throw new IllegalArgumentException("Camera name " + this.cameraName + " does not match any known camera device.");
        }
    }

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, VideoCapturer.CapturerObserver capturerObserver) {
        this.applicationContext = context;
        this.capturerObserver = capturerObserver;
        this.surfaceHelper = surfaceTextureHelper;
        this.cameraThreadHandler = surfaceTextureHelper == null ? null : surfaceTextureHelper.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCapture(int n2, int n3, int n4) {
        Logging.d(TAG, "startCapture: " + n2 + "x" + n3 + "@" + n4);
        if (this.applicationContext == null) {
            throw new RuntimeException("CameraCapturer must be initialized before calling startCapture.");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.sessionOpening || this.currentSession != null) {
                Logging.w(TAG, "Session already open");
                return;
            }
            this.width = n2;
            this.height = n3;
            this.framerate = n4;
            this.sessionOpening = true;
            this.openAttemptsRemaining = 3;
            this.createSessionInternal(0, null);
        }
    }

    protected void createSessionInternal(int n2, final MediaRecorder mediaRecorder) {
        this.uiThreadHandler.postDelayed(this.openCameraTimeoutRunnable, (long)(n2 + 10000));
        this.cameraThreadHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (CameraCapturer.this.mParamObserver == null) {
                    CameraCapturer.this.mParamObserver = MediaRecorderNative.cameraParamObserver;
                }
                CameraCapturer.this.createCameraSession(CameraCapturer.this.createSessionCallback, CameraCapturer.this.cameraSessionEventsHandler, CameraCapturer.this.applicationContext, CameraCapturer.this.surfaceHelper, mediaRecorder, CameraCapturer.this.cameraName, CameraCapturer.this.width, CameraCapturer.this.height, CameraCapturer.this.framerate, CameraCapturer.this.mParamObserver);
            }
        }, (long)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCapture() {
        Logging.d(TAG, "Stop capture");
        Object object = this.stateLock;
        synchronized (object) {
            while (this.sessionOpening) {
                Logging.d(TAG, "Stop capture: Waiting for session to open");
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Logging.w(TAG, "Stop capture interrupted while waiting for the session to open.");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.currentSession != null) {
                Logging.d(TAG, "Stop capture: Nulling session");
                this.cameraStatistics.release();
                this.cameraStatistics = null;
                final CameraSession cameraSession = this.currentSession;
                this.cameraThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cameraSession.stop();
                    }
                });
                this.currentSession = null;
                this.mCameraParam = null;
                this.capturerObserver.onCapturerStopped();
            } else {
                Logging.d(TAG, "Stop capture: No session open");
            }
        }
        Logging.d(TAG, "Stop capture done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeCaptureFormat(int n2, int n3, int n4) {
        Logging.d(TAG, "changeCaptureFormat: " + n2 + "x" + n3 + "@" + n4);
        Object object = this.stateLock;
        synchronized (object) {
            this.stopCapture();
            this.startCapture(n2, n3, n4);
        }
    }

    @Override
    public void dispose() {
        Logging.d(TAG, "dispose");
        this.stopCapture();
    }

    @Override
    public void switchCamera(final CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        Logging.d(TAG, "switchCamera");
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                CameraCapturer.this.switchCameraInternal(cameraSwitchHandler);
            }
        });
    }

    @Override
    public void addMediaRecorderToCamera(final MediaRecorder mediaRecorder, final CameraVideoCapturer.MediaRecorderHandler mediaRecorderHandler) {
        Logging.d(TAG, "addMediaRecorderToCamera");
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                CameraCapturer.this.updateMediaRecorderInternal(mediaRecorder, mediaRecorderHandler);
            }
        });
    }

    @Override
    public void removeMediaRecorderFromCamera(final CameraVideoCapturer.MediaRecorderHandler mediaRecorderHandler) {
        Logging.d(TAG, "removeMediaRecorderFromCamera");
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                CameraCapturer.this.updateMediaRecorderInternal(null, mediaRecorderHandler);
            }
        });
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    public void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        Thread thread = null;
        if (this.cameraThreadHandler != null) {
            thread = this.cameraThreadHandler.getLooper().getThread();
        }
        if (thread != null && (stackTraceElementArray = thread.getStackTrace()).length > 0) {
            Logging.d(TAG, "CameraCapturer stack trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    private void reportCameraSwitchError(String string, CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        Logging.e(TAG, string);
        if (cameraSwitchHandler != null) {
            cameraSwitchHandler.onCameraSwitchError(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchCameraInternal(CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        Logging.d(TAG, "switchCamera internal");
        String[] stringArray = this.cameraEnumerator.getDeviceNames();
        if (stringArray.length < 2) {
            if (cameraSwitchHandler != null) {
                cameraSwitchHandler.onCameraSwitchError("No camera to switch to.");
            }
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.switchState != SwitchState.IDLE) {
                this.reportCameraSwitchError("Camera switch already in progress.", cameraSwitchHandler);
                return;
            }
            if (this.mediaRecorderState != MediaRecorderState.IDLE) {
                this.reportCameraSwitchError("switchCamera: media recording is active", cameraSwitchHandler);
                return;
            }
            if (!this.sessionOpening && this.currentSession == null) {
                this.reportCameraSwitchError("switchCamera: camera is not running.", cameraSwitchHandler);
                return;
            }
            this.switchEventsHandler = cameraSwitchHandler;
            if (this.sessionOpening) {
                this.switchState = SwitchState.PENDING;
                return;
            }
            this.switchState = SwitchState.IN_PROGRESS;
            Logging.d(TAG, "switchCamera: Stopping session");
            this.cameraStatistics.release();
            this.cameraStatistics = null;
            final CameraSession cameraSession = this.currentSession;
            this.cameraThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    cameraSession.stop();
                }
            });
            this.currentSession = null;
            this.getValidCameraName(stringArray);
            this.sessionOpening = true;
            this.openAttemptsRemaining = 1;
            this.createSessionInternal(0, null);
        }
        Logging.d(TAG, "switchCamera done");
    }

    private void getValidCameraName(String[] stringArray) {
        int n2 = Arrays.asList(stringArray).indexOf(this.cameraName);
        int n3 = n2 + 1;
        int n4 = n2 % stringArray.length;
        String string = this.cameraName;
        try {
            while (n2 != (n4 = n3 % stringArray.length)) {
                string = stringArray[n4];
                CameraManager cameraManager = (CameraManager)this.applicationContext.getSystemService("camera");
                CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(string);
                List<Size> list = Camera2Enumerator.getSupportedSizes(cameraCharacteristics);
                if (!list.isEmpty()) {
                    this.cameraName = string;
                    i.d(TAG, "Ready to switch camera name is: " + this.cameraName + " camera index is: " + n4);
                    break;
                }
                i.d(TAG, "No supported output sizes, switch to next camera.");
                ++n3;
            }
        }
        catch (CameraAccessException cameraAccessException) {
            i.d(TAG, "getCameraCharacteristics(): " + cameraAccessException.getMessage());
            return;
        }
    }

    private void reportUpdateMediaRecorderError(String string, CameraVideoCapturer.MediaRecorderHandler mediaRecorderHandler) {
        this.checkIsOnCameraThread();
        Logging.e(TAG, string);
        if (mediaRecorderHandler != null) {
            mediaRecorderHandler.onMediaRecorderError(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMediaRecorderInternal(MediaRecorder mediaRecorder, CameraVideoCapturer.MediaRecorderHandler mediaRecorderHandler) {
        this.checkIsOnCameraThread();
        boolean bl = mediaRecorder != null;
        Logging.d(TAG, "updateMediaRecoderInternal internal. State: " + (Object)((Object)this.mediaRecorderState) + ". Switch state: " + (Object)((Object)this.switchState) + ". Add MediaRecorder: " + bl);
        Object object = this.stateLock;
        synchronized (object) {
            if (bl && this.mediaRecorderState != MediaRecorderState.IDLE || !bl && this.mediaRecorderState != MediaRecorderState.ACTIVE) {
                this.reportUpdateMediaRecorderError("Incorrect state for MediaRecorder update.", mediaRecorderHandler);
                return;
            }
            if (this.switchState != SwitchState.IDLE) {
                this.reportUpdateMediaRecorderError("MediaRecorder update while camera is switching.", mediaRecorderHandler);
                return;
            }
            if (this.currentSession == null) {
                this.reportUpdateMediaRecorderError("MediaRecorder update while camera is closed.", mediaRecorderHandler);
                return;
            }
            if (this.sessionOpening) {
                this.reportUpdateMediaRecorderError("MediaRecorder update while camera is still opening.", mediaRecorderHandler);
                return;
            }
            this.mediaRecorderEventsHandler = mediaRecorderHandler;
            this.mediaRecorderState = bl ? MediaRecorderState.IDLE_TO_ACTIVE : MediaRecorderState.ACTIVE_TO_IDLE;
            Logging.d(TAG, "updateMediaRecoder: Stopping session");
            this.cameraStatistics.release();
            this.cameraStatistics = null;
            final CameraSession cameraSession = this.currentSession;
            this.cameraThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    cameraSession.stop();
                }
            });
            this.currentSession = null;
            this.sessionOpening = true;
            this.openAttemptsRemaining = 1;
            this.createSessionInternal(0, mediaRecorder);
        }
        Logging.d(TAG, "updateMediaRecoderInternal done");
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            Logging.e(TAG, "Check is on camera thread failed.");
            throw new RuntimeException("Not on camera thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCameraName() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.cameraName;
        }
    }

    protected abstract void createCameraSession(CameraSession.CreateSessionCallback var1, CameraSession.Events var2, Context var3, SurfaceTextureHelper var4, MediaRecorder var5, String var6, int var7, int var8, int var9, CameraParamObserver var10);

    static enum MediaRecorderState {
        IDLE,
        IDLE_TO_ACTIVE,
        ACTIVE_TO_IDLE,
        ACTIVE;

    }

    static enum SwitchState {
        IDLE,
        PENDING,
        IN_PROGRESS;

    }
}

