/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.JNINamespace;
import org.webrtc.JniCommon;

@JNINamespace(value="webrtc::jni")
public class DataChannel {
    private final long nativeDataChannel;
    private long nativeObserver;

    @CalledByNative
    public DataChannel(long l2) {
        this.nativeDataChannel = l2;
    }

    public void registerObserver(Observer observer) {
        if (this.nativeObserver != 0L) {
            this.nativeUnregisterObserver(this.nativeObserver);
        }
        this.nativeObserver = this.nativeRegisterObserver(observer);
    }

    public void unregisterObserver() {
        this.nativeUnregisterObserver(this.nativeObserver);
    }

    public String label() {
        return this.nativeLabel();
    }

    public int id() {
        return this.nativeId();
    }

    public State state() {
        return this.nativeState();
    }

    public long bufferedAmount() {
        return this.nativeBufferedAmount();
    }

    public void close() {
        this.nativeClose();
    }

    public boolean send(Buffer buffer) {
        byte[] byArray = new byte[buffer.data.remaining()];
        buffer.data.get(byArray);
        return this.nativeSend(byArray, buffer.binary);
    }

    public void dispose() {
        JniCommon.nativeReleaseRef(this.nativeDataChannel);
    }

    @CalledByNative
    long getNativeDataChannel() {
        return this.nativeDataChannel;
    }

    private native long nativeRegisterObserver(Observer var1);

    private native void nativeUnregisterObserver(long var1);

    private native String nativeLabel();

    private native int nativeId();

    private native State nativeState();

    private native long nativeBufferedAmount();

    private native void nativeClose();

    private native boolean nativeSend(byte[] var1, boolean var2);

    public static enum State {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;


        @CalledByNative(value="State")
        static State fromNativeIndex(int n2) {
            return State.values()[n2];
        }
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onBufferedAmountChange(long var1);

        @CalledByNative(value="Observer")
        public void onStateChange();

        @CalledByNative(value="Observer")
        public void onMessage(Buffer var1);
    }

    public static class Buffer {
        public final ByteBuffer data;
        public final boolean binary;

        @CalledByNative(value="Buffer")
        public Buffer(ByteBuffer byteBuffer, boolean bl) {
            this.data = byteBuffer;
            this.binary = bl;
        }
    }

    public static class Init {
        public boolean ordered = true;
        public int maxRetransmitTimeMs = -1;
        public int maxRetransmits = -1;
        public String protocol = "";
        public boolean negotiated = false;
        public int id = -1;

        @CalledByNative(value="Init")
        boolean getOrdered() {
            return this.ordered;
        }

        @CalledByNative(value="Init")
        int getMaxRetransmitTimeMs() {
            return this.maxRetransmitTimeMs;
        }

        @CalledByNative(value="Init")
        int getMaxRetransmits() {
            return this.maxRetransmits;
        }

        @CalledByNative(value="Init")
        String getProtocol() {
            return this.protocol;
        }

        @CalledByNative(value="Init")
        boolean getNegotiated() {
            return this.negotiated;
        }

        @CalledByNative(value="Init")
        int getId() {
            return this.id;
        }
    }
}

