/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.webrtc.EglBase;
import org.webrtc.HardwareVideoEncoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;

public class DefaultVideoEncoderFactory
implements VideoEncoderFactory {
    private final VideoEncoderFactory hardwareVideoEncoderFactory;
    private final VideoEncoderFactory softwareVideoEncoderFactory;

    public DefaultVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2) {
        this.hardwareVideoEncoderFactory = new HardwareVideoEncoderFactory(context, bl, bl2, false);
        this.softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory();
    }

    DefaultVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
        this.hardwareVideoEncoderFactory = videoEncoderFactory;
        this.softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory();
    }

    @Override
    public VideoEncoder createEncoder(VideoCodecInfo videoCodecInfo) {
        VideoEncoder videoEncoder = this.hardwareVideoEncoderFactory.createEncoder(videoCodecInfo);
        if (videoEncoder != null) {
            return videoEncoder;
        }
        return this.softwareVideoEncoderFactory.createEncoder(videoCodecInfo);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> linkedHashSet = new LinkedHashSet<VideoCodecInfo>();
        linkedHashSet.addAll(Arrays.asList(this.softwareVideoEncoderFactory.getSupportedCodecs()));
        linkedHashSet.addAll(Arrays.asList(this.hardwareVideoEncoderFactory.getSupportedCodecs()));
        return linkedHashSet.toArray(new VideoCodecInfo[linkedHashSet.size()]);
    }
}

