/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.BaseBitrateAdjuster;

class DynamicBitrateAdjuster
extends BaseBitrateAdjuster {
    private static final double BITRATE_ADJUSTMENT_SEC = 3.0;
    private static final double BITRATE_ADJUSTMENT_MAX_SCALE = 4.0;
    private static final int BITRATE_ADJUSTMENT_STEPS = 20;
    private static final double BITS_PER_BYTE = 8.0;
    private double deviationBytes = 0.0;
    private double timeSinceLastAdjustmentMs = 0.0;
    private int bitrateAdjustmentScaleExp = 0;

    DynamicBitrateAdjuster() {
    }

    @Override
    public void setTargets(int n2, int n3) {
        if (this.targetBitrateBps > 0 && n2 < this.targetBitrateBps) {
            this.deviationBytes = this.deviationBytes * (double)n2 / (double)this.targetBitrateBps;
        }
        super.setTargets(n2, n3);
    }

    @Override
    public void reportEncodedFrame(int n2) {
        if (this.targetFps == 0) {
            return;
        }
        double d2 = (double)this.targetBitrateBps / 8.0 / (double)this.targetFps;
        this.deviationBytes += (double)n2 - d2;
        this.timeSinceLastAdjustmentMs += 1000.0 / (double)this.targetFps;
        double d3 = (double)this.targetBitrateBps / 8.0;
        double d4 = 3.0 * d3;
        this.deviationBytes = Math.min(this.deviationBytes, d4);
        this.deviationBytes = Math.max(this.deviationBytes, -d4);
        if (this.timeSinceLastAdjustmentMs <= 3000.0) {
            return;
        }
        if (this.deviationBytes > d3) {
            int n3 = (int)(this.deviationBytes / d3 + 0.5);
            this.bitrateAdjustmentScaleExp -= n3;
            this.bitrateAdjustmentScaleExp = Math.max(this.bitrateAdjustmentScaleExp, -20);
            this.deviationBytes = d3;
        } else if (this.deviationBytes < -d3) {
            int n4 = (int)(-this.deviationBytes / d3 + 0.5);
            this.bitrateAdjustmentScaleExp += n4;
            this.bitrateAdjustmentScaleExp = Math.min(this.bitrateAdjustmentScaleExp, 20);
            this.deviationBytes = -d3;
        }
        this.timeSinceLastAdjustmentMs = 0.0;
    }

    @Override
    public int getAdjustedBitrateBps() {
        return (int)((double)this.targetBitrateBps * Math.pow(4.0, (double)this.bitrateAdjustmentScaleExp / 20.0));
    }
}

