/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Surface;
import com.ucloudrtclib.a.i;
import com.ucloudrtclib.d.d;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.webrtc.EglBase;
import org.webrtc.GlTextureFrameBuffer;
import org.webrtc.GlUtil;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoFrameDrawer;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoSink;

public class EglRenderer
implements VideoRenderer.Callbacks,
VideoSink {
    private static final String TAG = "EglRenderer";
    private static final long LOG_INTERVAL_SEC = 4L;
    protected boolean isFirstFrameRendered;
    protected RendererCommon.RendererEvents rendererEvents;
    protected final String name;
    private final Object handlerLock = new Object();
    private Handler renderThreadHandler;
    private final ArrayList<FrameListenerAndParams> frameListeners = new ArrayList();
    private final Object fpsReductionLock = new Object();
    private long nextFrameTimeNs;
    private long minRenderPeriodNs;
    private EglBase eglBase;
    private final VideoFrameDrawer frameDrawer = new VideoFrameDrawer();
    private RendererCommon.GlDrawer drawer;
    private final Matrix drawMatrix = new Matrix();
    private final Object frameLock = new Object();
    private VideoFrame pendingFrame;
    private final Object layoutLock = new Object();
    private float layoutAspectRatio;
    private boolean mirror;
    private final Object statisticsLock = new Object();
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long statisticsStartTimeNs;
    private long renderTimeNs;
    private long renderSwapBufferTimeNs;
    private GlTextureFrameBuffer bitmapTextureFramebuffer;
    private final Runnable logStatisticsRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EglRenderer.this.logStatistics();
            Object object = EglRenderer.this.handlerLock;
            synchronized (object) {
                if (EglRenderer.this.renderThreadHandler != null) {
                    EglRenderer.this.renderThreadHandler.removeCallbacks(EglRenderer.this.logStatisticsRunnable);
                    EglRenderer.this.renderThreadHandler.postDelayed(EglRenderer.this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
                }
            }
        }
    };
    private final EglSurfaceCreation eglSurfaceCreationRunnable = new EglSurfaceCreation();

    public EglRenderer(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer, RendererCommon.RendererEvents rendererEvents) {
        Object object = this.handlerLock;
        synchronized (object) {
            this.rendererEvents = rendererEvents;
            if (this.renderThreadHandler == null) {
                this.logD("Initializing EglRenderer");
                i.d(TAG, this.name + "Initializing EglRenderer");
                this.drawer = glDrawer;
                HandlerThread handlerThread = new HandlerThread(this.name + TAG);
                handlerThread.start();
                this.renderThreadHandler = new Handler(handlerThread.getLooper());
                ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, () -> {
                    if (context == null) {
                        this.logD("EglBase10.create context");
                        this.eglBase = EglBase.createEgl10(nArray);
                    } else {
                        this.logD("EglBase.create shared context");
                        this.eglBase = EglBase.create(context, nArray);
                    }
                });
                this.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
                long l2 = System.nanoTime();
                this.resetStatistics(l2);
                this.renderThreadHandler.postDelayed(this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
            } else {
                i.d(TAG, this.name + "Already initialized");
            }
        }
    }

    public void createEglSurface(Surface surface) {
        this.createEglSurfaceInternal(surface);
    }

    public void createEglSurface(SurfaceTexture surfaceTexture) {
        this.createEglSurfaceInternal(surfaceTexture);
    }

    private void createEglSurfaceInternal(Object object) {
        this.eglSurfaceCreationRunnable.setSurface(object);
        this.postToRenderThread(this.eglSurfaceCreationRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.logD(" Releasing.");
        i.d(TAG, "EglRenderer Releasing");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            this.renderThreadHandler.removeCallbacks(this.logStatisticsRunnable);
            this.renderThreadHandler.postAtFrontOfQueue(() -> {
                if (this.drawer != null) {
                    this.drawer.release();
                    this.drawer = null;
                }
                this.frameDrawer.release();
                if (this.bitmapTextureFramebuffer != null) {
                    this.bitmapTextureFramebuffer.release();
                    this.bitmapTextureFramebuffer = null;
                }
                if (this.eglBase != null) {
                    i.d(TAG, "eglBase detach and release.");
                    this.logD("eglBase detach and release.");
                    this.eglBase.detachCurrent();
                    this.eglBase.release();
                    this.eglBase = null;
                }
                this.frameListeners.clear();
                countDownLatch.countDown();
            });
            Looper looper = this.renderThreadHandler.getLooper();
            this.renderThreadHandler.post(() -> {
                this.logD("Quitting render thread.");
                i.d(TAG, "EglRendererQuitting render thread");
                looper.quit();
            });
            this.renderThreadHandler = null;
        }
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                this.pendingFrame.release();
                this.pendingFrame = null;
            }
        }
        this.logD("Releasing done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStatistics(long l2) {
        Object object = this.statisticsLock;
        synchronized (object) {
            this.statisticsStartTimeNs = l2;
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.renderTimeNs = 0L;
            this.renderSwapBufferTimeNs = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        Object object = this.handlerLock;
        synchronized (object) {
            StackTraceElement[] stackTraceElementArray;
            Thread thread;
            Thread thread2 = thread = this.renderThreadHandler == null ? null : this.renderThreadHandler.getLooper().getThread();
            if (thread != null && (stackTraceElementArray = thread.getStackTrace()).length > 0) {
                this.logD("EglRenderer stack trace:");
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    this.logD(stackTraceElement.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean bl) {
        this.logD("setMirror: " + bl);
        Object object = this.layoutLock;
        synchronized (object) {
            this.mirror = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutAspectRatio(float f2) {
        this.logD("setLayoutAspectRatio: " + f2);
        Object object = this.layoutLock;
        synchronized (object) {
            this.layoutAspectRatio = f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFpsReduction(float f2) {
        this.logD("setFpsReduction: " + f2);
        Object object = this.fpsReductionLock;
        synchronized (object) {
            long l2 = this.minRenderPeriodNs;
            this.minRenderPeriodNs = f2 <= 0.0f ? Long.MAX_VALUE : (long)((float)TimeUnit.SECONDS.toNanos(1L) / f2);
            if (this.minRenderPeriodNs != l2) {
                this.nextFrameTimeNs = System.nanoTime();
            }
        }
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    public void addFrameListener(FrameListener frameListener, float f2) {
        this.addFrameListener(frameListener, f2, null, false);
    }

    public void addFrameListener(FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer) {
        this.addFrameListener(frameListener, f2, glDrawer, false);
    }

    public void addFrameListener(FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer, boolean bl) {
        this.postToRenderThread(() -> {
            RendererCommon.GlDrawer glDrawer2 = glDrawer == null ? this.drawer : glDrawer;
            this.frameListeners.add(new FrameListenerAndParams(frameListener, f2, glDrawer2, bl));
            i.d(TAG, "addFrameListener: size:" + this.frameListeners.size());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameListener(FrameListener frameListener) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            if (Thread.currentThread() == this.renderThreadHandler.getLooper().getThread()) {
                throw new RuntimeException("removeFrameListener must not be called on the render thread.");
            }
            this.postToRenderThread(() -> {
                countDownLatch.countDown();
                Iterator<FrameListenerAndParams> iterator = this.frameListeners.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().listener != frameListener) continue;
                    iterator.remove();
                }
            });
        }
        ThreadUtils.awaitUninterruptibly(countDownLatch);
    }

    @Override
    public void renderFrame(VideoRenderer.I420Frame i420Frame) {
        VideoFrame videoFrame = i420Frame.toVideoFrame();
        this.onFrame(videoFrame);
        videoFrame.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame videoFrame) {
        boolean bl;
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.framesReceived;
        }
        Object object2 = this.handlerLock;
        synchronized (object2) {
            if (this.renderThreadHandler == null) {
                this.logD("Dropping frame - Not initialized or already released.");
                return;
            }
            Object object3 = this.frameLock;
            synchronized (object3) {
                boolean bl2 = bl = this.pendingFrame != null;
                if (bl) {
                    this.pendingFrame.release();
                }
                this.pendingFrame = videoFrame;
                this.pendingFrame.retain();
                this.renderThreadHandler.post(this::renderFrameOnRenderThread);
            }
        }
        if (bl) {
            object2 = this.statisticsLock;
            synchronized (object2) {
                ++this.framesDropped;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEglSurface(Runnable runnable) {
        this.eglSurfaceCreationRunnable.setSurface(null);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
                this.renderThreadHandler.postAtFrontOfQueue(() -> {
                    if (this.eglBase != null) {
                        this.eglBase.detachCurrent();
                        i.d(TAG, "egl render releaseSurface");
                        this.eglBase.releaseSurface();
                    }
                    runnable.run();
                });
                return;
            }
        }
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(runnable);
            }
        }
    }

    private void clearSurfaceOnRenderThread(float f2, float f3, float f4, float f5) {
        if (this.eglBase != null && this.eglBase.hasSurface()) {
            this.logD("clearSurface");
            GLES20.glClearColor((float)f2, (float)f3, (float)f4, (float)f5);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    public void clearImage() {
        this.clearImage(0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImage(float f2, float f3, float f4, float f5) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue(() -> this.clearSurfaceOnRenderThread(f2, f3, f4, f5));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFrameOnRenderThread() {
        float f2;
        float f3;
        float f4;
        boolean bl;
        VideoFrame videoFrame;
        Object object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame == null) {
                return;
            }
            videoFrame = this.pendingFrame;
            this.pendingFrame = null;
        }
        if (this.eglBase == null || !this.eglBase.hasSurface()) {
            videoFrame.release();
            return;
        }
        Object object2 = this.fpsReductionLock;
        synchronized (object2) {
            if (this.minRenderPeriodNs == Long.MAX_VALUE) {
                bl = false;
                i.d(TAG, "name: " + this.name + "shouldRenderFrame = FALSE minRenderPeriodNs == Long.MAX_VALUE");
            } else if (this.minRenderPeriodNs <= 0L) {
                bl = true;
            } else {
                long l2 = System.nanoTime();
                if (l2 < this.nextFrameTimeNs) {
                    this.logD("Skipping frame rendering - fps reduction is active.");
                    i.d(TAG, "name: " + this.name + "Skipping frame rendering - fps reduction is active");
                    bl = false;
                } else {
                    this.nextFrameTimeNs += this.minRenderPeriodNs;
                    this.nextFrameTimeNs = Math.max(this.nextFrameTimeNs, l2);
                    bl = true;
                }
            }
        }
        long l3 = System.nanoTime();
        float f5 = (float)videoFrame.getRotatedWidth() / (float)videoFrame.getRotatedHeight();
        Object object3 = this.layoutLock;
        synchronized (object3) {
            f4 = this.layoutAspectRatio != 0.0f ? this.layoutAspectRatio : f5;
        }
        if (this.layoutAspectRatio == -100.0f) {
            f3 = 1.0f;
            f2 = 1.0f;
            i.d(TAG, "EglRendererfill " + f3);
        } else if (f5 > f4) {
            f3 = f4 / f5;
            f2 = 1.0f;
        } else {
            f3 = 1.0f;
            f2 = f5 / f4;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (this.mirror && d.dn().dv()) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        this.drawMatrix.preScale(f3, f2);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        if (bl) {
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(videoFrame, this.drawer, this.drawMatrix, 0, 0, this.eglBase.surfaceWidth(), this.eglBase.surfaceHeight());
            long l4 = System.nanoTime();
            this.eglBase.swapBuffers();
            long l5 = System.nanoTime();
            Object object4 = this.statisticsLock;
            synchronized (object4) {
                ++this.framesRendered;
                this.renderTimeNs += l5 - l3;
                this.renderSwapBufferTimeNs += l5 - l4;
            }
        }
        this.notifyCallbacks(videoFrame, bl);
        videoFrame.release();
    }

    private void notifyCallbacks(VideoFrame videoFrame, boolean bl) {
        if (!this.isFirstFrameRendered) {
            i.d(TAG, "egl isFirstFrameRendered = true");
            this.isFirstFrameRendered = true;
            if (this.rendererEvents != null) {
                i.d(TAG, "EglRendererReporting first rendered frame!!!: " + Thread.currentThread());
                this.rendererEvents.onFirstFrameRendered();
            }
        }
        if (this.frameListeners.isEmpty()) {
            return;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (this.mirror && d.dn().dv()) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        this.drawMatrix.preScale(1.0f, -1.0f);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        Iterator<FrameListenerAndParams> iterator = this.frameListeners.iterator();
        while (iterator.hasNext()) {
            FrameListenerAndParams frameListenerAndParams = iterator.next();
            if (!bl && frameListenerAndParams.applyFpsReduction) continue;
            iterator.remove();
            int n2 = (int)(frameListenerAndParams.scale * (float)videoFrame.getRotatedWidth());
            int n3 = (int)(frameListenerAndParams.scale * (float)videoFrame.getRotatedHeight());
            if (n2 == 0 || n3 == 0) {
                frameListenerAndParams.listener.onFrame(null, videoFrame.getRotatedWidth(), videoFrame.getRotatedHeight());
                continue;
            }
            if (this.bitmapTextureFramebuffer == null) {
                this.bitmapTextureFramebuffer = new GlTextureFrameBuffer(6408);
            }
            this.bitmapTextureFramebuffer.setSize(n2, n3);
            GLES20.glBindFramebuffer((int)36160, (int)this.bitmapTextureFramebuffer.getFrameBufferId());
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.bitmapTextureFramebuffer.getTextureId(), (int)0);
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(videoFrame, frameListenerAndParams.drawer, this.drawMatrix, 0, 0, n2, n3);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 * n3 * 4);
            GLES20.glViewport((int)0, (int)0, (int)n2, (int)n3);
            GLES20.glReadPixels((int)0, (int)0, (int)n2, (int)n3, (int)6408, (int)5121, (Buffer)byteBuffer);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GlUtil.checkNoGLES2Error("EglRenderer.notifyCallbacks");
            i.d(TAG, "EglRendereregl listener called screen shot ");
            frameListenerAndParams.listener.onFrame(byteBuffer, videoFrame.getRotatedWidth(), videoFrame.getRotatedHeight());
        }
    }

    private String averageTimeAsString(long l2, int n2) {
        return n2 <= 0 ? "NA" : TimeUnit.NANOSECONDS.toMicros(l2 / (long)n2) + " \u03bcs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatistics() {
        long l2 = System.nanoTime();
        Object object = this.statisticsLock;
        synchronized (object) {
            long l3 = l2 - this.statisticsStartTimeNs;
            if (l3 <= 0L) {
                return;
            }
            float f2 = (float)((long)this.framesRendered * TimeUnit.SECONDS.toNanos(1L)) / (float)l3;
            this.logD("Duration: " + TimeUnit.NANOSECONDS.toMillis(l3) + " ms. Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered + ". Render fps: " + String.format(Locale.US, "%.1f", Float.valueOf(f2)) + ". Average render time: " + this.averageTimeAsString(this.renderTimeNs, this.framesRendered) + ". Average swapBuffer time: " + this.averageTimeAsString(this.renderSwapBufferTimeNs, this.framesRendered) + ".");
            this.resetStatistics(l2);
        }
    }

    private void logD(String string) {
        Logging.d(TAG, this.name + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isInitEgl(final RequestEglInit requestEglInit) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                if (requestEglInit != null) {
                    i.d(TAG, "request false false");
                    requestEglInit.onRequestEglState(false, false);
                }
            } else {
                this.postToRenderThread(new Runnable(){

                    @Override
                    public void run() {
                        if (EglRenderer.this.eglBase != null && EglRenderer.this.eglBase.hasSurface()) {
                            requestEglInit.onRequestEglState(true, true);
                            i.d(EglRenderer.TAG, "request true true");
                        } else {
                            requestEglInit.onRequestEglState(true, false);
                            i.d(EglRenderer.TAG, "request true false");
                        }
                    }
                });
            }
        }
    }

    public static interface RequestEglInit {
        public void onRequestEglState(boolean var1, boolean var2);
    }

    private class EglSurfaceCreation
    implements Runnable {
        private Object surface;

        private EglSurfaceCreation() {
        }

        public synchronized void setSurface(Object object) {
            this.surface = object;
        }

        @Override
        public synchronized void run() {
            i.d(EglRenderer.TAG, "EglSurfaceCreation: " + EglRenderer.this.name + " eglBase: " + EglRenderer.this.eglBase + "surface: " + this.surface);
            if (EglRenderer.this.eglBase != null) {
                i.d(EglRenderer.TAG, " eglBase.hasSurface()" + EglRenderer.this.eglBase.hasSurface());
            }
            if (this.surface != null && EglRenderer.this.eglBase != null && !EglRenderer.this.eglBase.hasSurface()) {
                if (this.surface instanceof Surface) {
                    EglRenderer.this.eglBase.createSurface((Surface)this.surface);
                } else if (this.surface instanceof SurfaceTexture) {
                    EglRenderer.this.eglBase.createSurface((SurfaceTexture)this.surface);
                } else {
                    throw new IllegalStateException("Invalid surface: " + this.surface);
                }
                EglRenderer.this.eglBase.makeCurrent();
                GLES20.glPixelStorei((int)3317, (int)1);
                i.d(EglRenderer.TAG, "EglSurfaceCreation finished eglBase: " + EglRenderer.this.eglBase + " eglBase.hasSurface() " + EglRenderer.this.eglBase.hasSurface());
            } else {
                i.d(EglRenderer.TAG, "EglSurfaceCreation aborted");
            }
        }
    }

    private static class FrameListenerAndParams {
        public final FrameListener listener;
        public final float scale;
        public final RendererCommon.GlDrawer drawer;
        public final boolean applyFpsReduction;
        Bitmap mBitmap;

        public FrameListenerAndParams(FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer, boolean bl) {
            this.listener = frameListener;
            this.scale = f2;
            this.drawer = glDrawer;
            this.applyFpsReduction = bl;
        }
    }

    public static interface FrameListener {
        public void onFrame(ByteBuffer var1, int var2, int var3);
    }
}

