/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.webrtc.CalledByNative;

public class EncodedImage {
    public final ByteBuffer buffer;
    public final int encodedWidth;
    public final int encodedHeight;
    public final long captureTimeMs;
    public final long captureTimeNs;
    public final FrameType frameType;
    public final int rotation;
    public final boolean completeFrame;
    public final Integer qp;

    @CalledByNative
    private EncodedImage(ByteBuffer byteBuffer, int n2, int n3, long l2, FrameType frameType, int n4, boolean bl, Integer n5) {
        this.buffer = byteBuffer;
        this.encodedWidth = n2;
        this.encodedHeight = n3;
        this.captureTimeMs = TimeUnit.NANOSECONDS.toMillis(l2);
        this.captureTimeNs = l2;
        this.frameType = frameType;
        this.rotation = n4;
        this.completeFrame = bl;
        this.qp = n5;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ByteBuffer buffer;
        private int encodedWidth;
        private int encodedHeight;
        private long captureTimeNs;
        private FrameType frameType;
        private int rotation;
        private boolean completeFrame;
        private Integer qp;

        private Builder() {
        }

        public Builder setBuffer(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
            return this;
        }

        public Builder setEncodedWidth(int n2) {
            this.encodedWidth = n2;
            return this;
        }

        public Builder setEncodedHeight(int n2) {
            this.encodedHeight = n2;
            return this;
        }

        @Deprecated
        public Builder setCaptureTimeMs(long l2) {
            this.captureTimeNs = TimeUnit.MILLISECONDS.toNanos(l2);
            return this;
        }

        public Builder setCaptureTimeNs(long l2) {
            this.captureTimeNs = l2;
            return this;
        }

        public Builder setFrameType(FrameType frameType) {
            this.frameType = frameType;
            return this;
        }

        public Builder setRotation(int n2) {
            this.rotation = n2;
            return this;
        }

        public Builder setCompleteFrame(boolean bl) {
            this.completeFrame = bl;
            return this;
        }

        public Builder setQp(Integer n2) {
            this.qp = n2;
            return this;
        }

        public EncodedImage createEncodedImage() {
            return new EncodedImage(this.buffer, this.encodedWidth, this.encodedHeight, this.captureTimeNs, this.frameType, this.rotation, this.completeFrame, this.qp);
        }
    }

    public static enum FrameType {
        EmptyFrame(0),
        VideoFrameKey(3),
        VideoFrameDelta(4);

        private final int nativeIndex;

        private FrameType(int n3) {
            this.nativeIndex = n3;
        }

        public int getNative() {
            return this.nativeIndex;
        }

        @CalledByNative(value="FrameType")
        static FrameType fromNativeIndex(int n2) {
            for (FrameType frameType : FrameType.values()) {
                if (frameType.getNative() != n2) continue;
                return frameType;
            }
            throw new IllegalArgumentException("Unknown native frame type: " + n2);
        }
    }
}

