/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.os.SystemClock;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.webrtc.JavaI420Buffer;
import org.webrtc.Logging;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;

public class FileVideoCapturer
implements VideoCapturer {
    private static final String TAG = "FileVideoCapturer";
    private final VideoReader videoReader;
    private VideoCapturer.CapturerObserver capturerObserver;
    private final Timer timer = new Timer();
    private final TimerTask tickTask = new TimerTask(){

        @Override
        public void run() {
            FileVideoCapturer.this.tick();
        }
    };

    public FileVideoCapturer(String string) {
        try {
            this.videoReader = new VideoReaderY4M(string);
        }
        catch (IOException iOException) {
            Logging.d(TAG, "Could not open video file: " + string);
            throw iOException;
        }
    }

    public void tick() {
        this.capturerObserver.onFrameCaptured(this.videoReader.getNextFrame());
    }

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, VideoCapturer.CapturerObserver capturerObserver) {
        this.capturerObserver = capturerObserver;
    }

    @Override
    public void startCapture(int n2, int n3, int n4) {
        this.timer.schedule(this.tickTask, 0L, (long)(1000 / n4));
    }

    @Override
    public void stopCapture() {
        this.timer.cancel();
    }

    @Override
    public void changeCaptureFormat(int n2, int n3, int n4) {
    }

    @Override
    public void dispose() {
        this.videoReader.close();
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    private static class VideoReaderY4M
    implements VideoReader {
        private static final String TAG = "VideoReaderY4M";
        private static final String Y4M_FRAME_DELIMETER = "FRAME";
        private static final int FRAME_DELIMETER_LENGTH = "FRAME".length() + 1;
        private final int frameWidth;
        private final int frameHeight;
        private final long videoStart;
        private final RandomAccessFile mediaFile;
        private final FileChannel mediaFileChannel;

        public VideoReaderY4M(String string) {
            this.mediaFile = new RandomAccessFile(string, "r");
            this.mediaFileChannel = this.mediaFile.getChannel();
            StringBuilder stringBuilder = new StringBuilder();
            while (true) {
                int n2;
                if ((n2 = this.mediaFile.read()) == -1) {
                    throw new RuntimeException("Found end of file before end of header for file: " + string);
                }
                if (n2 == 10) break;
                stringBuilder.append((char)n2);
            }
            this.videoStart = this.mediaFileChannel.position();
            String string2 = stringBuilder.toString();
            String[] stringArray = string2.split("[ ]");
            int n3 = 0;
            int n4 = 0;
            String string3 = "";
            block6: for (String string4 : stringArray) {
                char c2 = string4.charAt(0);
                switch (c2) {
                    case 'W': {
                        n3 = Integer.parseInt(string4.substring(1));
                        continue block6;
                    }
                    case 'H': {
                        n4 = Integer.parseInt(string4.substring(1));
                        continue block6;
                    }
                    case 'C': {
                        string3 = string4.substring(1);
                    }
                }
            }
            Logging.d(TAG, "Color space: " + string3);
            if (!string3.equals("420") && !string3.equals("420mpeg2")) {
                throw new IllegalArgumentException("Does not support any other color space than I420 or I420mpeg2");
            }
            if (n3 % 2 == 1 || n4 % 2 == 1) {
                throw new IllegalArgumentException("Does not support odd width or height");
            }
            this.frameWidth = n3;
            this.frameHeight = n4;
            Logging.d(TAG, "frame dim: (" + n3 + ", " + n4 + ")");
        }

        @Override
        public VideoFrame getNextFrame() {
            long l2 = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
            JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(this.frameWidth, this.frameHeight);
            ByteBuffer byteBuffer = javaI420Buffer.getDataY();
            ByteBuffer byteBuffer2 = javaI420Buffer.getDataU();
            ByteBuffer byteBuffer3 = javaI420Buffer.getDataV();
            int n2 = (this.frameHeight + 1) / 2;
            int n3 = this.frameHeight * javaI420Buffer.getStrideY();
            int n4 = n2 * javaI420Buffer.getStrideU();
            int n5 = n2 * javaI420Buffer.getStrideV();
            try {
                String string;
                ByteBuffer byteBuffer4 = ByteBuffer.allocate(FRAME_DELIMETER_LENGTH);
                if (this.mediaFileChannel.read(byteBuffer4) < FRAME_DELIMETER_LENGTH) {
                    this.mediaFileChannel.position(this.videoStart);
                    if (this.mediaFileChannel.read(byteBuffer4) < FRAME_DELIMETER_LENGTH) {
                        throw new RuntimeException("Error looping video");
                    }
                }
                if (!(string = new String(byteBuffer4.array(), Charset.forName("US-ASCII"))).equals("FRAME\n")) {
                    throw new RuntimeException("Frames should be delimited by FRAME plus newline, found delimter was: '" + string + "'");
                }
                this.mediaFileChannel.read(byteBuffer);
                this.mediaFileChannel.read(byteBuffer2);
                this.mediaFileChannel.read(byteBuffer3);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return new VideoFrame(javaI420Buffer, 0, l2);
        }

        @Override
        public void close() {
            try {
                this.mediaFile.close();
            }
            catch (IOException iOException) {
                Logging.e(TAG, "Problem closing file", iOException);
            }
        }
    }

    private static interface VideoReader {
        public VideoFrame getNextFrame();

        public void close();
    }
}

