/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.webrtc.GlUtil;
import org.webrtc.Logging;

public class GlShader {
    private static final String TAG = "GlShader";
    private int program;

    private static int compileShader(int n2, String string) {
        int n3 = GLES20.glCreateShader((int)n2);
        if (n3 == 0) {
            throw new RuntimeException("glCreateShader() failed. GLES20 error: " + GLES20.glGetError());
        }
        GLES20.glShaderSource((int)n3, (String)string);
        GLES20.glCompileShader((int)n3);
        int[] nArray = new int[]{0};
        GLES20.glGetShaderiv((int)n3, (int)35713, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            Logging.e(TAG, "Could not compile shader " + n2 + ":" + GLES20.glGetShaderInfoLog((int)n3));
            throw new RuntimeException(GLES20.glGetShaderInfoLog((int)n3));
        }
        GlUtil.checkNoGLES2Error("compileShader");
        return n3;
    }

    public GlShader(String string, String string2) {
        int n2 = GlShader.compileShader(35633, string);
        int n3 = GlShader.compileShader(35632, string2);
        this.program = GLES20.glCreateProgram();
        if (this.program == 0) {
            throw new RuntimeException("glCreateProgram() failed. GLES20 error: " + GLES20.glGetError());
        }
        GLES20.glAttachShader((int)this.program, (int)n2);
        GLES20.glAttachShader((int)this.program, (int)n3);
        GLES20.glLinkProgram((int)this.program);
        int[] nArray = new int[]{0};
        GLES20.glGetProgramiv((int)this.program, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            Logging.e(TAG, "Could not link program: " + GLES20.glGetProgramInfoLog((int)this.program));
            throw new RuntimeException(GLES20.glGetProgramInfoLog((int)this.program));
        }
        GLES20.glDeleteShader((int)n2);
        GLES20.glDeleteShader((int)n3);
        GlUtil.checkNoGLES2Error("Creating GlShader");
    }

    public int getAttribLocation(String string) {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        int n2 = GLES20.glGetAttribLocation((int)this.program, (String)string);
        if (n2 < 0) {
            throw new RuntimeException("Could not locate '" + string + "' in program");
        }
        return n2;
    }

    public void setVertexAttribArray(String string, int n2, FloatBuffer floatBuffer) {
        this.setVertexAttribArray(string, n2, 0, floatBuffer);
    }

    public void setVertexAttribArray(String string, int n2, int n3, FloatBuffer floatBuffer) {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        int n4 = this.getAttribLocation(string);
        GLES20.glEnableVertexAttribArray((int)n4);
        GLES20.glVertexAttribPointer((int)n4, (int)n2, (int)5126, (boolean)false, (int)n3, (Buffer)floatBuffer);
        GlUtil.checkNoGLES2Error("setVertexAttribArray");
    }

    public int getUniformLocation(String string) {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        int n2 = GLES20.glGetUniformLocation((int)this.program, (String)string);
        if (n2 < 0) {
            throw new RuntimeException("Could not locate uniform '" + string + "' in program");
        }
        return n2;
    }

    public void useProgram() {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        GLES20.glUseProgram((int)this.program);
        GlUtil.checkNoGLES2Error("glUseProgram");
    }

    public void release() {
        Logging.d(TAG, "Deleting shader.");
        if (this.program != -1) {
            GLES20.glDeleteProgram((int)this.program);
            this.program = -1;
        }
    }
}

