/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.SystemClock;
import android.view.Surface;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.webrtc.EglBase;
import org.webrtc.EncodedImage;
import org.webrtc.JavaI420Buffer;
import org.webrtc.Logging;
import org.webrtc.MediaCodecUtils;
import org.webrtc.NV12Buffer;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoCodecType;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoFrame;

@TargetApi(value=16)
class HardwareVideoDecoder
implements SurfaceTextureHelper.OnTextureFrameAvailableListener,
VideoDecoder {
    private static final String TAG = "HardwareVideoDecoder";
    private static final String MEDIA_FORMAT_KEY_STRIDE = "stride";
    private static final String MEDIA_FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String MEDIA_FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String MEDIA_FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String MEDIA_FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String MEDIA_FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_INPUT_TIMEOUT_US = 500000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private final String codecName;
    private final VideoCodecType codecType;
    private final BlockingDeque<FrameInfo> frameInfos;
    private int colorFormat;
    private Thread outputThread;
    private ThreadUtils.ThreadChecker outputThreadChecker;
    private ThreadUtils.ThreadChecker decoderThreadChecker;
    private volatile boolean running = false;
    private volatile Exception shutdownException = null;
    private final Object dimensionLock = new Object();
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private boolean keyFrameRequired;
    private final EglBase.Context sharedContext;
    private SurfaceTextureHelper surfaceTextureHelper;
    private Surface surface = null;
    private final Object renderedTextureMetadataLock = new Object();
    private DecodedTextureMetadata renderedTextureMetadata;
    private VideoDecoder.Callback callback;
    private MediaCodec codec = null;

    HardwareVideoDecoder(String string, VideoCodecType videoCodecType, int n2, EglBase.Context context) {
        if (!this.isSupportedColorFormat(n2)) {
            throw new IllegalArgumentException("Unsupported color format: " + n2);
        }
        this.codecName = string;
        this.codecType = videoCodecType;
        this.colorFormat = n2;
        this.sharedContext = context;
        this.frameInfos = new LinkedBlockingDeque<FrameInfo>();
    }

    @Override
    public VideoCodecStatus initDecode(VideoDecoder.Settings settings, VideoDecoder.Callback callback) {
        this.decoderThreadChecker = new ThreadUtils.ThreadChecker();
        this.callback = callback;
        if (this.sharedContext != null) {
            this.surfaceTextureHelper = SurfaceTextureHelper.create("decoder-texture-thread", this.sharedContext);
            this.surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
            this.surfaceTextureHelper.startListening(this);
        }
        return this.initDecodeInternal(settings.width, settings.height);
    }

    private VideoCodecStatus initDecodeInternal(int n2, int n3) {
        this.decoderThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "initDecodeInternal");
        if (this.outputThread != null) {
            Logging.e(TAG, "initDecodeInternal called while the codec is already running");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.width = n2;
        this.height = n3;
        this.stride = n2;
        this.sliceHeight = n3;
        this.hasDecodedFirstFrame = false;
        this.keyFrameRequired = true;
        try {
            this.codec = MediaCodec.createByCodecName((String)this.codecName);
        }
        catch (IOException | IllegalArgumentException exception) {
            Logging.e(TAG, "Cannot create media decoder " + this.codecName);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)n2, (int)n3);
            if (this.sharedContext == null) {
                mediaFormat.setInteger("color-format", this.colorFormat);
            }
            this.codec.configure(mediaFormat, this.surface, null, 0);
            this.codec.start();
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initDecode failed", illegalStateException);
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.running = true;
        this.outputThread = this.createOutputThread();
        this.outputThread.start();
        Logging.d(TAG, "initDecodeInternal done");
        return VideoCodecStatus.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus decode(EncodedImage encodedImage, VideoDecoder.DecodeInfo decodeInfo) {
        ByteBuffer byteBuffer;
        int n2;
        int n3;
        int n4;
        this.decoderThreadChecker.checkIsOnValidThread();
        if (this.codec == null || this.callback == null) {
            Logging.d(TAG, "decode uninitalized, codec: " + this.codec + ", callback: " + this.callback);
            return VideoCodecStatus.UNINITIALIZED;
        }
        if (encodedImage.buffer == null) {
            Logging.e(TAG, "decode() - no input data");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        int n5 = encodedImage.buffer.remaining();
        if (n5 == 0) {
            Logging.e(TAG, "decode() - input buffer empty");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            n4 = this.width;
            n3 = this.height;
        }
        if (encodedImage.encodedWidth * encodedImage.encodedHeight > 0 && (encodedImage.encodedWidth != n4 || encodedImage.encodedHeight != n3) && (object = this.reinitDecode(encodedImage.encodedWidth, encodedImage.encodedHeight)) != VideoCodecStatus.OK) {
            return object;
        }
        if (this.keyFrameRequired) {
            if (encodedImage.frameType != EncodedImage.FrameType.VideoFrameKey) {
                Logging.e(TAG, "decode() - key frame required first");
                return VideoCodecStatus.NO_OUTPUT;
            }
            if (!encodedImage.completeFrame) {
                Logging.e(TAG, "decode() - complete frame required first");
                return VideoCodecStatus.NO_OUTPUT;
            }
        }
        try {
            n2 = this.codec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueInputBuffer failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        if (n2 < 0) {
            Logging.e(TAG, "decode() - no HW buffers available; decoder falling behind");
            return VideoCodecStatus.ERROR;
        }
        try {
            byteBuffer = this.codec.getInputBuffers()[n2];
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "getInputBuffers failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        if (byteBuffer.capacity() < n5) {
            Logging.e(TAG, "decode() - HW buffer too small");
            return VideoCodecStatus.ERROR;
        }
        byteBuffer.put(encodedImage.buffer);
        this.frameInfos.offer(new FrameInfo(SystemClock.elapsedRealtime(), encodedImage.rotation));
        try {
            this.codec.queueInputBuffer(n2, 0, n5, TimeUnit.NANOSECONDS.toMicros(encodedImage.captureTimeNs), 0);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "queueInputBuffer failed", illegalStateException);
            this.frameInfos.pollLast();
            return VideoCodecStatus.ERROR;
        }
        if (this.keyFrameRequired) {
            this.keyFrameRequired = false;
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public boolean getPrefersLateDecoding() {
        return true;
    }

    @Override
    public String getImplementationName() {
        return "HWDecoder";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus release() {
        Logging.d(TAG, "release");
        VideoCodecStatus videoCodecStatus = this.releaseInternal();
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
            this.surfaceTextureHelper.stopListening();
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
        Object object = this.renderedTextureMetadataLock;
        synchronized (object) {
            this.renderedTextureMetadata = null;
        }
        this.callback = null;
        this.frameInfos.clear();
        return videoCodecStatus;
    }

    private VideoCodecStatus releaseInternal() {
        if (!this.running) {
            Logging.d(TAG, "release: Decoder is not running.");
            return VideoCodecStatus.OK;
        }
        try {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                Logging.e(TAG, "Media decoder release timeout", new RuntimeException());
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.TIMEOUT;
                return videoCodecStatus;
            }
            if (this.shutdownException != null) {
                Logging.e(TAG, "Media decoder release error", new RuntimeException(this.shutdownException));
                this.shutdownException = null;
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.ERROR;
                return videoCodecStatus;
            }
        }
        finally {
            this.codec = null;
            this.outputThread = null;
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus reinitDecode(int n2, int n3) {
        this.decoderThreadChecker.checkIsOnValidThread();
        VideoCodecStatus videoCodecStatus = this.releaseInternal();
        if (videoCodecStatus != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        return this.initDecodeInternal(n2, n3);
    }

    private Thread createOutputThread() {
        return new Thread("HardwareVideoDecoder.outputThread"){

            @Override
            public void run() {
                HardwareVideoDecoder.this.outputThreadChecker = new ThreadUtils.ThreadChecker();
                while (HardwareVideoDecoder.this.running) {
                    HardwareVideoDecoder.this.deliverDecodedFrame();
                }
                HardwareVideoDecoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    private void deliverDecodedFrame() {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n2 = this.codec.dequeueOutputBuffer(bufferInfo, 100000L);
            if (n2 == -2) {
                this.reformat(this.codec.getOutputFormat());
                return;
            }
            if (n2 < 0) {
                Logging.v(TAG, "dequeueOutputBuffer returned " + n2);
                return;
            }
            FrameInfo frameInfo = this.frameInfos.poll();
            Integer n3 = null;
            int n4 = 0;
            if (frameInfo != null) {
                n3 = (int)(SystemClock.elapsedRealtime() - frameInfo.decodeStartTimeMs);
                n4 = frameInfo.rotation;
            }
            this.hasDecodedFirstFrame = true;
            if (this.surfaceTextureHelper != null) {
                this.deliverTextureFrame(n2, bufferInfo, n4, n3);
            } else {
                this.deliverByteFrame(n2, bufferInfo, n4, n3);
            }
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "deliverDecodedFrame failed", illegalStateException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverTextureFrame(int n2, MediaCodec.BufferInfo bufferInfo, int n3, Integer n4) {
        int n5;
        int n6;
        Object object = this.dimensionLock;
        synchronized (object) {
            n6 = this.width;
            n5 = this.height;
        }
        object = this.renderedTextureMetadataLock;
        synchronized (object) {
            if (this.renderedTextureMetadata != null) {
                return;
            }
            this.renderedTextureMetadata = new DecodedTextureMetadata(n6, n5, n3, bufferInfo.presentationTimeUs, n4);
            this.codec.releaseOutputBuffer(n2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTextureFrameAvailable(int n2, float[] fArray, long l2) {
        int n3;
        VideoFrame videoFrame;
        Object object = this.renderedTextureMetadataLock;
        synchronized (object) {
            if (this.renderedTextureMetadata == null) {
                throw new IllegalStateException("Rendered texture metadata was null in onTextureFrameAvailable.");
            }
            VideoFrame.TextureBuffer textureBuffer = this.surfaceTextureHelper.createTextureBuffer(this.renderedTextureMetadata.width, this.renderedTextureMetadata.height, RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray));
            videoFrame = new VideoFrame(textureBuffer, this.renderedTextureMetadata.rotation, this.renderedTextureMetadata.presentationTimestampUs * 1000L);
            n3 = this.renderedTextureMetadata.decodeTimeMs;
            this.renderedTextureMetadata = null;
        }
        this.callback.onDecodedFrame(videoFrame, n3, null);
        videoFrame.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverByteFrame(int n2, MediaCodec.BufferInfo bufferInfo, int n3, Integer n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        Object object = this.dimensionLock;
        synchronized (object) {
            n8 = this.width;
            n7 = this.height;
            n6 = this.stride;
            n5 = this.sliceHeight;
        }
        if (bufferInfo.size < n8 * n7 * 3 / 2) {
            Logging.e(TAG, "Insufficient output buffer size: " + bufferInfo.size);
            return;
        }
        if (bufferInfo.size < n6 * n7 * 3 / 2 && n5 == n7 && n6 > n8) {
            n6 = bufferInfo.size * 2 / (n7 * 3);
        }
        object = this.codec.getOutputBuffers()[n2];
        ((ByteBuffer)object).position(bufferInfo.offset);
        ((ByteBuffer)object).limit(bufferInfo.offset + bufferInfo.size);
        object = ((ByteBuffer)object).slice();
        VideoFrame.Buffer buffer = this.colorFormat == 19 ? this.copyI420Buffer((ByteBuffer)object, n6, n5, n8, n7) : this.copyNV12ToI420Buffer((ByteBuffer)object, n6, n5, n8, n7);
        this.codec.releaseOutputBuffer(n2, false);
        long l2 = bufferInfo.presentationTimeUs * 1000L;
        VideoFrame videoFrame = new VideoFrame(buffer, n3, l2);
        this.callback.onDecodedFrame(videoFrame, n4, null);
        videoFrame.release();
    }

    private VideoFrame.Buffer copyNV12ToI420Buffer(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
        return new NV12Buffer(n4, n5, n2, n3, byteBuffer, null).toI420();
    }

    private VideoFrame.Buffer copyI420Buffer(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
        int n6 = n2 / 2;
        boolean bl = false;
        int n7 = 0 + n2 * n3;
        int n8 = n7 + n6 * (n3 / 2);
        int n9 = n7 + n6 * n3 / 2;
        int n10 = n9 + n6 * (n3 / 2);
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n4, n5);
        ByteBuffer byteBuffer2 = javaI420Buffer.getDataY();
        byteBuffer.position(0);
        byteBuffer.limit(n7);
        byteBuffer2.put(byteBuffer);
        ByteBuffer byteBuffer3 = javaI420Buffer.getDataU();
        byteBuffer.position(n7);
        byteBuffer.limit(n8);
        byteBuffer3.put(byteBuffer);
        if (n3 % 2 != 0) {
            byteBuffer.position(n8 - n6);
            byteBuffer3.put(byteBuffer);
        }
        ByteBuffer byteBuffer4 = javaI420Buffer.getDataV();
        byteBuffer.position(n9);
        byteBuffer.limit(n10);
        byteBuffer4.put(byteBuffer);
        if (n3 % 2 != 0) {
            byteBuffer.position(n10 - n6);
            byteBuffer4.put(byteBuffer);
        }
        return javaI420Buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reformat(MediaFormat mediaFormat) {
        int n2;
        int n3;
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Decoder format changed: " + mediaFormat.toString());
        if (mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_LEFT) && mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_RIGHT) && mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_BOTTOM) && mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_TOP)) {
            n3 = 1 + mediaFormat.getInteger(MEDIA_FORMAT_KEY_CROP_RIGHT) - mediaFormat.getInteger(MEDIA_FORMAT_KEY_CROP_LEFT);
            n2 = 1 + mediaFormat.getInteger(MEDIA_FORMAT_KEY_CROP_BOTTOM) - mediaFormat.getInteger(MEDIA_FORMAT_KEY_CROP_TOP);
        } else {
            n3 = mediaFormat.getInteger("width");
            n2 = mediaFormat.getInteger("height");
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            if (this.hasDecodedFirstFrame && (this.width != n3 || this.height != n2)) {
                this.stopOnOutputThread(new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n3 + "*" + n2));
                return;
            }
            this.width = n3;
            this.height = n2;
        }
        if (this.surfaceTextureHelper == null && mediaFormat.containsKey("color-format")) {
            this.colorFormat = mediaFormat.getInteger("color-format");
            Logging.d(TAG, "Color: 0x" + Integer.toHexString(this.colorFormat));
            if (!this.isSupportedColorFormat(this.colorFormat)) {
                this.stopOnOutputThread(new IllegalStateException("Unsupported color format: " + this.colorFormat));
                return;
            }
        }
        object = this.dimensionLock;
        synchronized (object) {
            if (mediaFormat.containsKey(MEDIA_FORMAT_KEY_STRIDE)) {
                this.stride = mediaFormat.getInteger(MEDIA_FORMAT_KEY_STRIDE);
            }
            if (mediaFormat.containsKey(MEDIA_FORMAT_KEY_SLICE_HEIGHT)) {
                this.sliceHeight = mediaFormat.getInteger(MEDIA_FORMAT_KEY_SLICE_HEIGHT);
            }
            Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
            this.stride = Math.max(this.width, this.stride);
            this.sliceHeight = Math.max(this.height, this.sliceHeight);
        }
    }

    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Releasing MediaCodec on output thread");
        try {
            this.codec.stop();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media decoder stop failed", exception);
        }
        try {
            this.codec.release();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media decoder release failed", exception);
            this.shutdownException = exception;
        }
        Logging.d(TAG, "Release on output thread done");
    }

    private void stopOnOutputThread(Exception exception) {
        this.outputThreadChecker.checkIsOnValidThread();
        this.running = false;
        this.shutdownException = exception;
    }

    private boolean isSupportedColorFormat(int n2) {
        for (int n3 : MediaCodecUtils.DECODER_COLOR_FORMATS) {
            if (n3 != n2) continue;
            return true;
        }
        return false;
    }

    private static class DecodedTextureMetadata {
        final int width;
        final int height;
        final int rotation;
        final long presentationTimestampUs;
        final Integer decodeTimeMs;

        DecodedTextureMetadata(int n2, int n3, int n4, long l2, Integer n5) {
            this.width = n2;
            this.height = n3;
            this.rotation = n4;
            this.presentationTimestampUs = l2;
            this.decodeTimeMs = n5;
        }
    }

    private static class FrameInfo {
        final long decodeStartTimeMs;
        final int rotation;

        FrameInfo(long l2, int n2) {
            this.decodeStartTimeMs = l2;
            this.rotation = n2;
        }
    }
}

