/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import org.webrtc.EglBase;
import org.webrtc.HardwareVideoDecoder;
import org.webrtc.Logging;
import org.webrtc.MediaCodecUtils;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.VideoCodecType;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoDecoderFactory;

public class HardwareVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "HardwareVideoDecoderFactory";
    private final EglBase.Context sharedContext;
    private final boolean fallbackToSoftware;

    @Deprecated
    public HardwareVideoDecoderFactory() {
        this(null);
    }

    public HardwareVideoDecoderFactory(EglBase.Context context) {
        this(context, true);
    }

    HardwareVideoDecoderFactory(EglBase.Context context, boolean bl) {
        this.sharedContext = context;
        this.fallbackToSoftware = bl;
    }

    @Override
    public VideoDecoder createDecoder(String string) {
        VideoCodecType videoCodecType = VideoCodecType.valueOf(string);
        MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
        if (mediaCodecInfo == null) {
            if (this.fallbackToSoftware) {
                SoftwareVideoDecoderFactory softwareVideoDecoderFactory = new SoftwareVideoDecoderFactory();
                return softwareVideoDecoderFactory.createDecoder(string);
            }
            return null;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(videoCodecType.mimeType());
        return new HardwareVideoDecoder(mediaCodecInfo.getName(), videoCodecType, MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, codecCapabilities), this.sharedContext);
    }

    private MediaCodecInfo findCodecForType(VideoCodecType videoCodecType) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder() || !this.isSupportedCodec(mediaCodecInfo, videoCodecType)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        if (!MediaCodecUtils.codecSupportsType(mediaCodecInfo, videoCodecType)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(videoCodecType.mimeType())) == null) {
            return false;
        }
        return this.isHardwareSupported(mediaCodecInfo, videoCodecType);
    }

    private boolean isHardwareSupported(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        String string = mediaCodecInfo.getName();
        switch (videoCodecType) {
            case VP8: {
                return string.startsWith("OMX.qcom.") || string.startsWith("OMX.Intel.") || string.startsWith("OMX.Exynos.") || string.startsWith("OMX.Nvidia.");
            }
            case VP9: {
                return string.startsWith("OMX.qcom.") || string.startsWith("OMX.Exynos.");
            }
            case H264: {
                return string.startsWith("OMX.qcom.") || string.startsWith("OMX.Intel.") || string.startsWith("OMX.Exynos.");
            }
        }
        return false;
    }
}

