/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import com.ucloudrtclib.a.i;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.webrtc.BaseBitrateAdjuster;
import org.webrtc.BitrateAdjuster;
import org.webrtc.DynamicBitrateAdjuster;
import org.webrtc.EglBase;
import org.webrtc.EglBase14;
import org.webrtc.FramerateBitrateAdjuster;
import org.webrtc.HardwareVideoEncoder;
import org.webrtc.JNINamespace;
import org.webrtc.Logging;
import org.webrtc.MediaCodecUtils;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoCodecType;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;

@JNINamespace(value="webrtc::jni")
public class HardwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "HardwareVideoEncoderFactory";
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000;
    private static final List<String> H264_HW_EXCEPTION_MODELS = Arrays.asList("SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4");
    private final EglBase14.Context sharedContext;
    private final boolean enableIntelVp8Encoder;
    private final boolean enableH264HighProfile;
    private final boolean fallbackToSoftware;

    public HardwareVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2) {
        this(context, bl, bl2, true);
    }

    HardwareVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2, boolean bl3) {
        if (context instanceof EglBase14.Context) {
            this.sharedContext = (EglBase14.Context)context;
        } else {
            Logging.w(TAG, "No shared EglBase.Context.  Encoders will not use texture mode.");
            this.sharedContext = null;
        }
        this.enableIntelVp8Encoder = bl;
        this.enableH264HighProfile = bl2;
        this.fallbackToSoftware = bl3;
    }

    @Deprecated
    public HardwareVideoEncoderFactory(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    @Override
    public VideoEncoder createEncoder(VideoCodecInfo videoCodecInfo) {
        i.d(TAG, "createEncoder in HardwareVideoEncoderFactory");
        VideoCodecType videoCodecType = VideoCodecType.valueOf(videoCodecInfo.name);
        MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
        if (mediaCodecInfo == null) {
            if (this.fallbackToSoftware) {
                SoftwareVideoEncoderFactory softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory();
                return softwareVideoEncoderFactory.createEncoder(videoCodecInfo);
            }
            return null;
        }
        String string = mediaCodecInfo.getName();
        String string2 = videoCodecType.mimeType();
        Integer n2 = MediaCodecUtils.selectColorFormat(MediaCodecUtils.TEXTURE_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(string2));
        Integer n3 = MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(string2));
        if (videoCodecType == VideoCodecType.H264) {
            boolean bl = HardwareVideoEncoderFactory.nativeIsSameH264Profile(videoCodecInfo.params, this.getCodecProperties(videoCodecType, true)) && this.isH264HighProfileSupported(mediaCodecInfo);
            boolean bl2 = HardwareVideoEncoderFactory.nativeIsSameH264Profile(videoCodecInfo.params, this.getCodecProperties(videoCodecType, false));
            if (!bl && !bl2) {
                return null;
            }
        }
        i.d(TAG, "create hw encoder success with " + string);
        return new HardwareVideoEncoder(string, videoCodecType, n2, n3, videoCodecInfo.params, this.getKeyFrameIntervalSec(videoCodecType), this.getForcedKeyFrameIntervalMs(videoCodecType, string), this.createBitrateAdjuster(videoCodecType, string), this.sharedContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
        for (VideoCodecType videoCodecType : new VideoCodecType[]{VideoCodecType.VP8, VideoCodecType.VP9, VideoCodecType.H264}) {
            MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
            if (mediaCodecInfo == null) continue;
            String string = videoCodecType.name();
            if (videoCodecType == VideoCodecType.H264 && this.isH264HighProfileSupported(mediaCodecInfo)) {
                arrayList.add(new VideoCodecInfo(string, this.getCodecProperties(videoCodecType, true)));
            }
            arrayList.add(new VideoCodecInfo(string, this.getCodecProperties(videoCodecType, false)));
        }
        if (this.fallbackToSoftware) {
            for (VideoCodecInfo videoCodecInfo : SoftwareVideoEncoderFactory.supportedCodecs()) {
                if (arrayList.contains(videoCodecInfo)) continue;
                arrayList.add(videoCodecInfo);
            }
        }
        return arrayList.toArray(new VideoCodecInfo[arrayList.size()]);
    }

    private MediaCodecInfo findCodecForType(VideoCodecType videoCodecType) {
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder() || !this.isSupportedCodec(mediaCodecInfo, videoCodecType)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        if (!MediaCodecUtils.codecSupportsType(mediaCodecInfo, videoCodecType)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(videoCodecType.mimeType())) == null) {
            return false;
        }
        return this.isHardwareSupportedInCurrentSdk(mediaCodecInfo, videoCodecType);
    }

    private boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        switch (videoCodecType) {
            case VP8: {
                return this.isHardwareSupportedInCurrentSdkVp8(mediaCodecInfo);
            }
            case VP9: {
                return this.isHardwareSupportedInCurrentSdkVp9(mediaCodecInfo);
            }
            case H264: {
                return this.isHardwareSupportedInCurrentSdkH264(mediaCodecInfo);
            }
        }
        return false;
    }

    private boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo mediaCodecInfo) {
        String string = mediaCodecInfo.getName();
        return string.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || string.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || string.startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21 && this.enableIntelVp8Encoder;
    }

    private boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo mediaCodecInfo) {
        String string = mediaCodecInfo.getName();
        return (string.startsWith("OMX.qcom.") || string.startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
    }

    private boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo mediaCodecInfo) {
        if (H264_HW_EXCEPTION_MODELS.contains(Build.MODEL)) {
            return false;
        }
        String string = mediaCodecInfo.getName();
        return string.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || string.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 21 || string.startsWith("OMX.google.") && Build.VERSION.SDK_INT >= 21 || string.startsWith("OMX.hisi.") && Build.VERSION.SDK_INT >= 21;
    }

    private int getKeyFrameIntervalSec(VideoCodecType videoCodecType) {
        switch (videoCodecType) {
            case VP8: 
            case VP9: {
                return 100;
            }
            case H264: {
                return 20;
            }
        }
        throw new IllegalArgumentException("Unsupported VideoCodecType " + (Object)((Object)videoCodecType));
    }

    private int getForcedKeyFrameIntervalMs(VideoCodecType videoCodecType, String string) {
        if (videoCodecType == VideoCodecType.VP8 && string.startsWith("OMX.qcom.")) {
            if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
                return 15000;
            }
            if (Build.VERSION.SDK_INT == 23) {
                return 20000;
            }
            if (Build.VERSION.SDK_INT > 23) {
                return 15000;
            }
        }
        return 0;
    }

    private BitrateAdjuster createBitrateAdjuster(VideoCodecType videoCodecType, String string) {
        if (string.startsWith("OMX.Exynos.") || string.startsWith("OMX.google.")) {
            if (videoCodecType == VideoCodecType.VP8) {
                return new DynamicBitrateAdjuster();
            }
            return new FramerateBitrateAdjuster();
        }
        return new BaseBitrateAdjuster();
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo mediaCodecInfo) {
        return this.enableH264HighProfile && Build.VERSION.SDK_INT > 23 && (mediaCodecInfo.getName().startsWith("OMX.Exynos.") || mediaCodecInfo.getName().startsWith("OMX.google.") || mediaCodecInfo.getName().startsWith("OMX.qcom."));
    }

    private Map<String, String> getCodecProperties(VideoCodecType videoCodecType, boolean bl) {
        switch (videoCodecType) {
            case VP8: 
            case VP9: {
                return new HashMap<String, String>();
            }
            case H264: {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("level-asymmetry-allowed", "1");
                hashMap.put("packetization-mode", "1");
                hashMap.put("profile-level-id", bl ? "640c1f" : "42e01f");
                return hashMap;
            }
        }
        throw new IllegalArgumentException("Unsupported codec: " + (Object)((Object)videoCodecType));
    }

    private static native boolean nativeIsSameH264Profile(Map<String, String> var0, Map<String, String> var1);
}

