/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.SystemClock;
import android.view.Surface;
import com.ucloudrtclib.a.i;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.webrtc.CalledByNative;
import org.webrtc.CalledByNativeUnchecked;
import org.webrtc.Logging;
import org.webrtc.MediaCodecVideoEncoder;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;

public class MediaCodecVideoDecoder {
    private static final String TAG = "MediaCodecVideoDecoder";
    private static final long MAX_DECODE_TIME_MS = 200L;
    private static final String FORMAT_KEY_STRIDE = "stride";
    private static final String FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int DEQUEUE_INPUT_TIMEOUT = 500000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    private static MediaCodecVideoDecoder runningInstance = null;
    private static MediaCodecVideoDecoderErrorCallback errorCallback = null;
    private static int codecErrors = 0;
    private static Set<String> hwDecoderDisabledTypes = new HashSet<String>();
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String[] supportedVp9HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos."};
    private static final String supportedQcomH264HighProfileHwCodecPrefix = "OMX.qcom.";
    private static final String supportedExynosH264HighProfileHwCodecPrefix = "OMX.Exynos.";
    private static final String supportedMediaTekH264HighProfileHwCodecPrefix = "OMX.MTK.";
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final List<Integer> supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876);
    private int colorFormat;
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private final Queue<TimeStamps> decodeStartTimeMs = new ArrayDeque<TimeStamps>();
    private boolean useSurface;
    private TextureListener textureListener;
    private int droppedFrames;
    private Surface surface = null;
    private final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers = new ArrayDeque<DecodedOutputBuffer>();

    private static final String[] supportedVp8HwCodecPrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(supportedQcomH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Nvidia.");
        arrayList.add(supportedExynosH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Intel.");
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekVP8").equals("Enabled") && Build.VERSION.SDK_INT >= 24) {
            arrayList.add(supportedMediaTekH264HighProfileHwCodecPrefix);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static final String[] supportedH264HwCodecPrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(supportedQcomH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Intel.");
        arrayList.add(supportedExynosH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.google.");
        arrayList.add("OMX.hisi.");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    @CalledByNativeUnchecked
    public static boolean isVp8HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, MediaCodecVideoDecoder.supportedVp8HwCodecPrefixes()) != null;
    }

    @CalledByNativeUnchecked
    public static boolean isVp9HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes) != null;
    }

    @CalledByNativeUnchecked
    public static boolean isH264HwSupported() {
        return !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, MediaCodecVideoDecoder.supportedH264HwCodecPrefixes()) != null;
    }

    @CalledByNative
    public static boolean isH264HighProfileHwSupported() {
        if (hwDecoderDisabledTypes.contains(H264_MIME_TYPE)) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedQcomH264HighProfileHwCodecPrefix}) != null) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, new String[]{supportedExynosH264HighProfileHwCodecPrefix}) != null;
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoDecoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoDecoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoDecoder stacks trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    private static DecoderProperties findDecoder(String string, String[] codecCapabilities) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        Logging.d(TAG, "Trying to find HW decoder for mime " + string);
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo.CodecCapabilities codecCapabilities2;
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder()) continue;
            String string2 = null;
            for (String string3 : mediaCodecInfo.getSupportedTypes()) {
                if (!string3.equals(string)) continue;
                string2 = mediaCodecInfo.getName();
                break;
            }
            if (string2 == null) continue;
            Logging.d(TAG, "Found candidate decoder " + string2);
            boolean bl = false;
            for (String string4 : codecCapabilities) {
                if (!string2.startsWith(string4)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            try {
                codecCapabilities2 = mediaCodecInfo.getCapabilitiesForType(string);
                i.d(TAG, "capabilities " + codecCapabilities2 + "");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder capabilities", illegalArgumentException);
                continue;
            }
            for (int n2 : codecCapabilities2.colorFormats) {
                Logging.v(TAG, "   Color: 0x" + Integer.toHexString(n2));
            }
            Object object = supportedColorList.iterator();
            while (object.hasNext()) {
                int n2;
                int n3 = (Integer)object.next();
                int[] nArray = codecCapabilities2.colorFormats;
                n2 = nArray.length;
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n4 = nArray[i3];
                    if (n4 != n3) continue;
                    Logging.d(TAG, "Found target decoder " + string2 + ". Color: 0x" + Integer.toHexString(n4));
                    return new DecoderProperties(string2, n4);
                }
            }
        }
        Logging.d(TAG, "No HW decoder found for mime " + string);
        return null;
    }

    @CalledByNative
    MediaCodecVideoDecoder() {
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new IllegalStateException("MediaCodecVideoDecoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    @CalledByNativeUnchecked
    private boolean initDecode(VideoCodecType videoCodecType, int n2, int n3, SurfaceTextureHelper surfaceTextureHelper) {
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("initDecode: Forgot to release()?");
        }
        String string = null;
        this.useSurface = surfaceTextureHelper != null;
        String[] stringArray = null;
        if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP8) {
            string = VP8_MIME_TYPE;
            stringArray = MediaCodecVideoDecoder.supportedVp8HwCodecPrefixes();
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP9) {
            string = VP9_MIME_TYPE;
            stringArray = supportedVp9HwCodecPrefixes;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_H264) {
            string = H264_MIME_TYPE;
            stringArray = MediaCodecVideoDecoder.supportedH264HwCodecPrefixes();
        } else {
            throw new RuntimeException("initDecode: Non-supported codec " + (Object)((Object)videoCodecType));
        }
        DecoderProperties decoderProperties = MediaCodecVideoDecoder.findDecoder(string, stringArray);
        if (decoderProperties == null) {
            throw new RuntimeException("Cannot find HW decoder for " + (Object)((Object)videoCodecType));
        }
        Logging.d(TAG, "Java initDecode: " + (Object)((Object)videoCodecType) + " : " + n2 + " x " + n3 + ". Color: 0x" + Integer.toHexString(decoderProperties.colorFormat) + ". Use Surface: " + this.useSurface);
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        try {
            this.width = n2;
            this.height = n3;
            this.stride = n2;
            this.sliceHeight = n3;
            if (this.useSurface) {
                this.textureListener = new TextureListener(surfaceTextureHelper);
                this.surface = new Surface(surfaceTextureHelper.getSurfaceTexture());
            }
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)string, (int)n2, (int)n3);
            if (!this.useSurface) {
                mediaFormat.setInteger("color-format", decoderProperties.colorFormat);
            }
            Logging.d(TAG, "  Format: " + mediaFormat);
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(decoderProperties.codecName);
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media decoder");
                return false;
            }
            this.mediaCodec.configure(mediaFormat, this.surface, null, 0);
            this.mediaCodec.start();
            this.colorFormat = decoderProperties.colorFormat;
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            this.inputBuffers = this.mediaCodec.getInputBuffers();
            this.decodeStartTimeMs.clear();
            this.hasDecodedFirstFrame = false;
            this.dequeuedSurfaceOutputBuffers.clear();
            this.droppedFrames = 0;
            Logging.d(TAG, "Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initDecode failed", illegalStateException);
            return false;
        }
    }

    @CalledByNativeUnchecked
    private void reset(int n2, int n3) {
        if (this.mediaCodecThread == null || this.mediaCodec == null) {
            throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
        }
        Logging.d(TAG, "Java reset: " + n2 + " x " + n3);
        this.mediaCodec.flush();
        this.width = n2;
        this.height = n3;
        this.decodeStartTimeMs.clear();
        this.dequeuedSurfaceOutputBuffers.clear();
        this.hasDecodedFirstFrame = false;
        this.droppedFrames = 0;
    }

    @CalledByNativeUnchecked
    private void release() {
        Logging.d(TAG, "Java releaseDecoder. Total number of dropped frames: " + this.droppedFrames);
        this.checkOnMediaCodecThread();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread");
                    MediaCodecVideoDecoder.this.mediaCodec.stop();
                    MediaCodecVideoDecoder.this.mediaCodec.release();
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread done");
                }
                catch (Exception exception) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Media decoder release failed", exception);
                }
                countDownLatch.countDown();
            }
        };
        new Thread(runnable).start();
        if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
            Logging.e(TAG, "Media decoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        if (this.useSurface) {
            this.surface.release();
            this.surface = null;
            this.textureListener.release();
        }
        Logging.d(TAG, "Java releaseDecoder done");
    }

    @CalledByNativeUnchecked
    private int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    @CalledByNativeUnchecked
    private boolean queueInputBuffer(int n2, int n3, long l2, long l3, long l4) {
        this.checkOnMediaCodecThread();
        try {
            this.inputBuffers[n2].position(0);
            this.inputBuffers[n2].limit(n3);
            this.decodeStartTimeMs.add(new TimeStamps(SystemClock.elapsedRealtime(), l3, l4));
            this.mediaCodec.queueInputBuffer(n2, 0, n3, l2, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "decode failed", illegalStateException);
            return false;
        }
    }

    @CalledByNativeUnchecked
    private DecodedOutputBuffer dequeueOutputBuffer(int n2) {
        int n3;
        this.checkOnMediaCodecThread();
        if (this.decodeStartTimeMs.isEmpty()) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        block5: while (true) {
            n3 = this.mediaCodec.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(n2));
            switch (n3) {
                case -3: {
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                    Logging.d(TAG, "Decoder output buffers changed: " + this.outputBuffers.length);
                    if (!this.hasDecodedFirstFrame) continue block5;
                    throw new RuntimeException("Unexpected output buffer change event.");
                }
                case -2: {
                    int n4;
                    int n5;
                    MediaFormat mediaFormat = this.mediaCodec.getOutputFormat();
                    Logging.d(TAG, "Decoder format changed: " + mediaFormat.toString());
                    if (mediaFormat.containsKey(FORMAT_KEY_CROP_LEFT) && mediaFormat.containsKey(FORMAT_KEY_CROP_RIGHT) && mediaFormat.containsKey(FORMAT_KEY_CROP_BOTTOM) && mediaFormat.containsKey(FORMAT_KEY_CROP_TOP)) {
                        n5 = 1 + mediaFormat.getInteger(FORMAT_KEY_CROP_RIGHT) - mediaFormat.getInteger(FORMAT_KEY_CROP_LEFT);
                        n4 = 1 + mediaFormat.getInteger(FORMAT_KEY_CROP_BOTTOM) - mediaFormat.getInteger(FORMAT_KEY_CROP_TOP);
                    } else {
                        n5 = mediaFormat.getInteger("width");
                        n4 = mediaFormat.getInteger("height");
                    }
                    if (this.hasDecodedFirstFrame && (n5 != this.width || n4 != this.height)) {
                        throw new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n5 + "*" + n4);
                    }
                    this.width = n5;
                    this.height = n4;
                    if (!this.useSurface && mediaFormat.containsKey("color-format")) {
                        this.colorFormat = mediaFormat.getInteger("color-format");
                        Logging.d(TAG, "Color: 0x" + Integer.toHexString(this.colorFormat));
                        if (!supportedColorList.contains(this.colorFormat)) {
                            throw new IllegalStateException("Non supported color format: " + this.colorFormat);
                        }
                    }
                    if (mediaFormat.containsKey(FORMAT_KEY_STRIDE)) {
                        this.stride = mediaFormat.getInteger(FORMAT_KEY_STRIDE);
                    }
                    if (mediaFormat.containsKey(FORMAT_KEY_SLICE_HEIGHT)) {
                        this.sliceHeight = mediaFormat.getInteger(FORMAT_KEY_SLICE_HEIGHT);
                    }
                    Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
                    this.stride = Math.max(this.width, this.stride);
                    this.sliceHeight = Math.max(this.height, this.sliceHeight);
                    continue block5;
                }
                case -1: {
                    return null;
                }
            }
            break;
        }
        this.hasDecodedFirstFrame = true;
        TimeStamps timeStamps = this.decodeStartTimeMs.remove();
        long l2 = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
        if (l2 > 200L) {
            Logging.e(TAG, "Very high decode time: " + l2 + "ms. Q size: " + this.decodeStartTimeMs.size() + ". Might be caused by resuming H264 decoding after a pause.");
            l2 = 200L;
        }
        return new DecodedOutputBuffer(n3, bufferInfo.offset, bufferInfo.size, TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs), timeStamps.timeStampMs, timeStamps.ntpTimeStampMs, l2, SystemClock.elapsedRealtime());
    }

    @CalledByNativeUnchecked
    private DecodedTextureBuffer dequeueTextureBuffer(int n2) {
        this.checkOnMediaCodecThread();
        if (!this.useSurface) {
            throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
        }
        DecodedOutputBuffer decodedOutputBuffer = this.dequeueOutputBuffer(n2);
        if (decodedOutputBuffer != null) {
            this.dequeuedSurfaceOutputBuffers.add(decodedOutputBuffer);
        }
        this.MaybeRenderDecodedTextureBuffer();
        DecodedTextureBuffer decodedTextureBuffer = this.textureListener.dequeueTextureBuffer(n2);
        if (decodedTextureBuffer != null) {
            this.MaybeRenderDecodedTextureBuffer();
            return decodedTextureBuffer;
        }
        if (this.dequeuedSurfaceOutputBuffers.size() >= Math.min(3, this.outputBuffers.length) || n2 > 0 && !this.dequeuedSurfaceOutputBuffers.isEmpty()) {
            ++this.droppedFrames;
            DecodedOutputBuffer decodedOutputBuffer2 = this.dequeuedSurfaceOutputBuffers.remove();
            if (n2 > 0) {
                Logging.w(TAG, "Draining decoder. Dropping frame with TS: " + decodedOutputBuffer2.presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames);
            } else {
                Logging.w(TAG, "Too many output buffers " + this.dequeuedSurfaceOutputBuffers.size() + ". Dropping frame with TS: " + decodedOutputBuffer2.presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames);
            }
            this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer2.index, false);
            return new DecodedTextureBuffer(0, null, decodedOutputBuffer2.presentationTimeStampMs, decodedOutputBuffer2.timeStampMs, decodedOutputBuffer2.ntpTimeStampMs, decodedOutputBuffer2.decodeTimeMs, SystemClock.elapsedRealtime() - decodedOutputBuffer2.endDecodeTimeMs);
        }
        return null;
    }

    private void MaybeRenderDecodedTextureBuffer() {
        if (this.dequeuedSurfaceOutputBuffers.isEmpty() || this.textureListener.isWaitingForTexture()) {
            return;
        }
        DecodedOutputBuffer decodedOutputBuffer = this.dequeuedSurfaceOutputBuffers.remove();
        this.textureListener.addBufferToRender(decodedOutputBuffer);
        this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, true);
    }

    @CalledByNativeUnchecked
    private void returnDecodedOutputBuffer(int n2) {
        this.checkOnMediaCodecThread();
        if (this.useSurface) {
            throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
        }
        this.mediaCodec.releaseOutputBuffer(n2, false);
    }

    @CalledByNative
    ByteBuffer[] getInputBuffers() {
        return this.inputBuffers;
    }

    @CalledByNative
    ByteBuffer[] getOutputBuffers() {
        return this.outputBuffers;
    }

    @CalledByNative
    int getColorFormat() {
        return this.colorFormat;
    }

    @CalledByNative
    int getWidth() {
        return this.width;
    }

    @CalledByNative
    int getHeight() {
        return this.height;
    }

    @CalledByNative
    int getStride() {
        return this.stride;
    }

    @CalledByNative
    int getSliceHeight() {
        return this.sliceHeight;
    }

    private static class TextureListener
    implements SurfaceTextureHelper.OnTextureFrameAvailableListener {
        private final SurfaceTextureHelper surfaceTextureHelper;
        private final Object newFrameLock = new Object();
        private DecodedOutputBuffer bufferToRender;
        private DecodedTextureBuffer renderedBuffer;

        public TextureListener(SurfaceTextureHelper surfaceTextureHelper) {
            this.surfaceTextureHelper = surfaceTextureHelper;
            surfaceTextureHelper.startListening(this);
        }

        public void addBufferToRender(DecodedOutputBuffer decodedOutputBuffer) {
            if (this.bufferToRender != null) {
                Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected addBufferToRender() called while waiting for a texture.");
                throw new IllegalStateException("Waiting for a texture.");
            }
            this.bufferToRender = decodedOutputBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWaitingForTexture() {
            Object object = this.newFrameLock;
            synchronized (object) {
                return this.bufferToRender != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTextureFrameAvailable(int n2, float[] fArray, long l2) {
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer != null) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected onTextureFrameAvailable() called while already holding a texture.");
                    throw new IllegalStateException("Already holding a texture.");
                }
                this.renderedBuffer = new DecodedTextureBuffer(n2, fArray, this.bufferToRender.presentationTimeStampMs, this.bufferToRender.timeStampMs, this.bufferToRender.ntpTimeStampMs, this.bufferToRender.decodeTimeMs, SystemClock.elapsedRealtime() - this.bufferToRender.endDecodeTimeMs);
                this.bufferToRender = null;
                this.newFrameLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DecodedTextureBuffer dequeueTextureBuffer(int n2) {
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer == null && n2 > 0 && this.isWaitingForTexture()) {
                    try {
                        this.newFrameLock.wait(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                DecodedTextureBuffer decodedTextureBuffer = this.renderedBuffer;
                this.renderedBuffer = null;
                return decodedTextureBuffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            this.surfaceTextureHelper.stopListening();
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer != null) {
                    this.surfaceTextureHelper.returnTextureFrame();
                    this.renderedBuffer = null;
                }
            }
        }
    }

    private static class DecodedTextureBuffer {
        private final int textureID;
        private final float[] transformMatrix;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long frameDelayMs;

        public DecodedTextureBuffer(int n2, float[] fArray, long l2, long l3, long l4, long l5, long l6) {
            this.textureID = n2;
            this.transformMatrix = fArray;
            this.presentationTimeStampMs = l2;
            this.timeStampMs = l3;
            this.ntpTimeStampMs = l4;
            this.decodeTimeMs = l5;
            this.frameDelayMs = l6;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        int getTextureId() {
            return this.textureID;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        float[] getTransformMatrix() {
            return this.transformMatrix;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getPresentationTimestampMs() {
            return this.presentationTimeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getTimeStampMs() {
            return this.timeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getNtpTimestampMs() {
            return this.ntpTimeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getDecodeTimeMs() {
            return this.decodeTimeMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        long getFrameDelayMs() {
            return this.frameDelayMs;
        }
    }

    private static class DecodedOutputBuffer {
        private final int index;
        private final int offset;
        private final int size;
        private final long presentationTimeStampMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long endDecodeTimeMs;

        public DecodedOutputBuffer(int n2, int n3, int n4, long l2, long l3, long l4, long l5, long l6) {
            this.index = n2;
            this.offset = n3;
            this.size = n4;
            this.presentationTimeStampMs = l2;
            this.timeStampMs = l3;
            this.ntpTimeStampMs = l4;
            this.decodeTimeMs = l5;
            this.endDecodeTimeMs = l6;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getIndex() {
            return this.index;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getOffset() {
            return this.offset;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        int getSize() {
            return this.size;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getPresentationTimestampMs() {
            return this.presentationTimeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getTimestampMs() {
            return this.timeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getNtpTimestampMs() {
            return this.ntpTimeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        long getDecodeTimeMs() {
            return this.decodeTimeMs;
        }
    }

    private static class TimeStamps {
        private final long decodeStartTimeMs;
        private final long timeStampMs;
        private final long ntpTimeStampMs;

        public TimeStamps(long l2, long l3, long l4) {
            this.decodeStartTimeMs = l2;
            this.timeStampMs = l3;
            this.ntpTimeStampMs = l4;
        }
    }

    private static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;

        public DecoderProperties(String string, int n2) {
            this.codecName = string;
            this.colorFormat = n2;
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;


        @CalledByNative(value="VideoCodecType")
        static VideoCodecType fromNativeIndex(int n2) {
            return VideoCodecType.values()[n2];
        }
    }
}

