/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.webrtc.AudioTrack;
import org.webrtc.CalledByNative;
import org.webrtc.JNINamespace;
import org.webrtc.JniCommon;
import org.webrtc.Logging;
import org.webrtc.MediaStreamTrack;
import org.webrtc.VideoTrack;

@JNINamespace(value="webrtc::jni")
public class MediaStream {
    private static final String TAG = "MediaStream";
    public final List<AudioTrack> audioTracks = new ArrayList<AudioTrack>();
    public final List<VideoTrack> videoTracks = new ArrayList<VideoTrack>();
    public final List<VideoTrack> preservedVideoTracks = new ArrayList<VideoTrack>();
    final long nativeStream;

    @CalledByNative
    public MediaStream(long l2) {
        this.nativeStream = l2;
    }

    public boolean addTrack(AudioTrack audioTrack) {
        if (MediaStream.nativeAddAudioTrackToNativeStream(this.nativeStream, audioTrack.nativeTrack)) {
            this.audioTracks.add(audioTrack);
            return true;
        }
        return false;
    }

    public boolean addTrack(VideoTrack videoTrack) {
        if (MediaStream.nativeAddVideoTrackToNativeStream(this.nativeStream, videoTrack.nativeTrack)) {
            this.videoTracks.add(videoTrack);
            return true;
        }
        return false;
    }

    public boolean addPreservedTrack(VideoTrack videoTrack) {
        if (MediaStream.nativeAddVideoTrackToNativeStream(this.nativeStream, videoTrack.nativeTrack)) {
            this.preservedVideoTracks.add(videoTrack);
            return true;
        }
        return false;
    }

    public boolean removeTrack(AudioTrack audioTrack) {
        this.audioTracks.remove(audioTrack);
        return MediaStream.nativeRemoveAudioTrack(this.nativeStream, audioTrack.nativeTrack);
    }

    public boolean removeTrack(VideoTrack videoTrack) {
        this.videoTracks.remove(videoTrack);
        this.preservedVideoTracks.remove(videoTrack);
        return MediaStream.nativeRemoveVideoTrack(this.nativeStream, videoTrack.nativeTrack);
    }

    @CalledByNative
    public void dispose() {
        MediaStreamTrack mediaStreamTrack;
        while (!this.audioTracks.isEmpty()) {
            mediaStreamTrack = this.audioTracks.get(0);
            this.removeTrack((AudioTrack)mediaStreamTrack);
            ((AudioTrack)mediaStreamTrack).dispose();
        }
        while (!this.videoTracks.isEmpty()) {
            mediaStreamTrack = this.videoTracks.get(0);
            this.removeTrack((VideoTrack)mediaStreamTrack);
            ((VideoTrack)mediaStreamTrack).dispose();
        }
        while (!this.preservedVideoTracks.isEmpty()) {
            this.removeTrack(this.preservedVideoTracks.get(0));
        }
        JniCommon.nativeReleaseRef(this.nativeStream);
    }

    public String label() {
        return MediaStream.nativeGetLabel(this.nativeStream);
    }

    public String toString() {
        return "[" + this.label() + ":A=" + this.audioTracks.size() + ":V=" + this.videoTracks.size() + "]";
    }

    @CalledByNative
    void addNativeAudioTrack(long l2) {
        this.audioTracks.add(new AudioTrack(l2));
    }

    @CalledByNative
    void addNativeVideoTrack(long l2) {
        this.videoTracks.add(new VideoTrack(l2));
    }

    @CalledByNative
    void removeAudioTrack(long l2) {
        MediaStream.removeMediaStreamTrack(this.audioTracks, l2);
    }

    @CalledByNative
    void removeVideoTrack(long l2) {
        MediaStream.removeMediaStreamTrack(this.videoTracks, l2);
    }

    private static void removeMediaStreamTrack(List<? extends MediaStreamTrack> list, long l2) {
        Iterator<? extends MediaStreamTrack> iterator = list.iterator();
        while (iterator.hasNext()) {
            MediaStreamTrack mediaStreamTrack = iterator.next();
            if (mediaStreamTrack.nativeTrack != l2) continue;
            mediaStreamTrack.dispose();
            iterator.remove();
            return;
        }
        Logging.e(TAG, "Couldn't not find track");
    }

    private static native boolean nativeAddAudioTrackToNativeStream(long var0, long var2);

    private static native boolean nativeAddVideoTrackToNativeStream(long var0, long var2);

    private static native boolean nativeRemoveAudioTrack(long var0, long var2);

    private static native boolean nativeRemoveVideoTrack(long var0, long var2);

    private static native String nativeGetLabel(long var0);
}

