/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.JNINamespace;
import org.webrtc.JniCommon;

@JNINamespace(value="webrtc::jni")
public class MediaStreamTrack {
    final long nativeTrack;

    public MediaStreamTrack(long l2) {
        this.nativeTrack = l2;
    }

    public String id() {
        return MediaStreamTrack.nativeGetId(this.nativeTrack);
    }

    public String kind() {
        return MediaStreamTrack.nativeGetKind(this.nativeTrack);
    }

    public boolean enabled() {
        return MediaStreamTrack.nativeGetEnabled(this.nativeTrack);
    }

    public boolean setEnabled(boolean bl) {
        return MediaStreamTrack.nativeSetEnabled(this.nativeTrack, bl);
    }

    public State state() {
        return MediaStreamTrack.nativeGetState(this.nativeTrack);
    }

    public void dispose() {
        JniCommon.nativeReleaseRef(this.nativeTrack);
    }

    private static native String nativeGetId(long var0);

    private static native String nativeGetKind(long var0);

    private static native boolean nativeGetEnabled(long var0);

    private static native boolean nativeSetEnabled(long var0, boolean var2);

    private static native State nativeGetState(long var0);

    public static enum MediaType {
        MEDIA_TYPE_AUDIO(0),
        MEDIA_TYPE_VIDEO(1);

        private final int nativeIndex;

        private MediaType(int n3) {
            this.nativeIndex = n3;
        }

        @CalledByNative(value="MediaType")
        int getNative() {
            return this.nativeIndex;
        }

        @CalledByNative(value="MediaType")
        static MediaType fromNativeIndex(int n2) {
            for (MediaType mediaType : MediaType.values()) {
                if (mediaType.getNative() != n2) continue;
                return mediaType;
            }
            throw new IllegalArgumentException("Unknown native media type: " + n2);
        }
    }

    public static enum State {
        LIVE,
        ENDED;


        @CalledByNative(value="State")
        static State fromNativeIndex(int n2) {
            return State.values()[n2];
        }
    }
}

