/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.HashMap;
import java.util.Map;
import org.webrtc.CalledByNative;
import org.webrtc.JNINamespace;

@JNINamespace(value="webrtc::jni")
public class Metrics {
    private static final String TAG = "Metrics";
    public final Map<String, HistogramInfo> map = new HashMap<String, HistogramInfo>();

    @CalledByNative
    Metrics() {
    }

    @CalledByNative
    private void add(String string, HistogramInfo histogramInfo) {
        this.map.put(string, histogramInfo);
    }

    public static void enable() {
        Metrics.nativeEnable();
    }

    public static Metrics getAndReset() {
        return Metrics.nativeGetAndReset();
    }

    private static native void nativeEnable();

    private static native Metrics nativeGetAndReset();

    public static class HistogramInfo {
        public final int min;
        public final int max;
        public final int bucketCount;
        public final Map<Integer, Integer> samples = new HashMap<Integer, Integer>();

        @CalledByNative(value="HistogramInfo")
        public HistogramInfo(int n2, int n3, int n4) {
            this.min = n2;
            this.max = n3;
            this.bucketCount = n4;
        }

        @CalledByNative(value="HistogramInfo")
        public void addSample(int n2, int n3) {
            this.samples.put(n2, n3);
        }
    }
}

