/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.JNINamespace;
import org.webrtc.JavaI420Buffer;
import org.webrtc.VideoFrame;

@JNINamespace(value="webrtc::jni")
public class NV12Buffer
implements VideoFrame.Buffer {
    private final int width;
    private final int height;
    private final int stride;
    private final int sliceHeight;
    private final ByteBuffer buffer;
    private final Runnable releaseCallback;
    private final Object refCountLock = new Object();
    private int refCount;

    public NV12Buffer(int n2, int n3, int n4, int n5, ByteBuffer byteBuffer, Runnable runnable) {
        this.width = n2;
        this.height = n3;
        this.stride = n4;
        this.sliceHeight = n5;
        this.buffer = byteBuffer;
        this.releaseCallback = runnable;
        this.refCount = 1;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer)this.cropAndScale(0, 0, this.width, this.height, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.refCountLock;
        synchronized (object) {
            if (--this.refCount == 0 && this.releaseCallback != null) {
                this.releaseCallback.run();
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n2, int n3, int n4, int n5, int n6, int n7) {
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n6, n7);
        NV12Buffer.nativeCropAndScale(n2, n3, n4, n5, n6, n7, this.buffer, this.width, this.height, this.stride, this.sliceHeight, javaI420Buffer.getDataY(), javaI420Buffer.getStrideY(), javaI420Buffer.getDataU(), javaI420Buffer.getStrideU(), javaI420Buffer.getDataV(), javaI420Buffer.getStrideV());
        return javaI420Buffer;
    }

    private static native void nativeCropAndScale(int var0, int var1, int var2, int var3, int var4, int var5, ByteBuffer var6, int var7, int var8, int var9, int var10, ByteBuffer var11, int var12, ByteBuffer var13, int var14, ByteBuffer var15, int var16);
}

