/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.JNINamespace;
import org.webrtc.JavaI420Buffer;
import org.webrtc.VideoFrame;

@JNINamespace(value="webrtc::jni")
public class NV21Buffer
implements VideoFrame.Buffer {
    private final byte[] data;
    private final int width;
    private final int height;
    private final Runnable releaseCallback;
    private final Object refCountLock = new Object();
    public static final String TAG = "NV21Buffer";
    private boolean isNeedMirror;
    private int refCount = 1;

    public NV21Buffer(byte[] byArray, int n2, int n3, Runnable runnable) {
        this.data = byArray;
        this.width = n2;
        this.height = n3;
        this.releaseCallback = runnable;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer)this.cropAndScale(0, 0, this.width, this.height, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.refCountLock;
        synchronized (object) {
            if (--this.refCount == 0 && this.releaseCallback != null) {
                this.releaseCallback.run();
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n2, int n3, int n4, int n5, int n6, int n7) {
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n6, n7);
        NV21Buffer.nativeCropAndScale(n2, n3, n4, n5, n6, n7, this.data, this.width, this.height, javaI420Buffer.getDataY(), javaI420Buffer.getStrideY(), javaI420Buffer.getDataU(), javaI420Buffer.getStrideU(), javaI420Buffer.getDataV(), javaI420Buffer.getStrideV());
        if (this.isNeedMirror) {
            JavaI420Buffer javaI420Buffer2 = JavaI420Buffer.allocate(n6, n7);
            NV21Buffer.nativeMirror(javaI420Buffer.getDataY(), javaI420Buffer.getStrideY(), javaI420Buffer.getDataU(), javaI420Buffer.getStrideU(), javaI420Buffer.getDataV(), javaI420Buffer.getStrideV(), javaI420Buffer2.getDataY(), javaI420Buffer2.getStrideY(), javaI420Buffer2.getDataU(), javaI420Buffer2.getStrideU(), javaI420Buffer2.getDataV(), javaI420Buffer2.getStrideV(), n6, n7);
            javaI420Buffer.release();
            return javaI420Buffer2;
        }
        return javaI420Buffer;
    }

    private static native void nativeCropAndScale(int var0, int var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, ByteBuffer var9, int var10, ByteBuffer var11, int var12, ByteBuffer var13, int var14);

    private static native void nativeMirror(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, ByteBuffer var6, int var7, ByteBuffer var8, int var9, ByteBuffer var10, int var11, int var12, int var13);

    public void setNeedMirror(boolean bl) {
        this.isNeedMirror = bl;
    }
}

