/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.Logging;
import org.webrtc.NativeLibraryLoader;

public class NativeLibrary {
    private static String TAG = "NativeLibrary";
    private static Object lock = new Object();
    private static boolean libraryLoaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean initialize(NativeLibraryLoader nativeLibraryLoader) {
        Object object = lock;
        synchronized (object) {
            if (libraryLoaded) {
                Logging.d(TAG, "Native library has already been loaded.");
                return true;
            }
            Logging.d(TAG, "Loading native library.");
            libraryLoaded = nativeLibraryLoader.load("urtcengine_so");
            return libraryLoaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoaded() {
        Object object = lock;
        synchronized (object) {
            return libraryLoaded;
        }
    }

    static class DefaultLoader
    implements NativeLibraryLoader {
        DefaultLoader() {
        }

        @Override
        public boolean load(String string) {
            Logging.d(TAG, "Loading library: " + string);
            try {
                System.loadLibrary(string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Logging.e(TAG, "Failed to load native library: " + string, unsatisfiedLinkError);
                return false;
            }
            return true;
        }
    }
}

