/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.os.Build;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.webrtc.CalledByNative;
import org.webrtc.ContextUtils;
import org.webrtc.Logging;
import org.webrtc.NativeClassQualifiedName;
import org.webrtc.NetworkMonitorAutoDetect;

public class NetworkMonitor {
    private static final String TAG = "NetworkMonitor";
    private final ArrayList<Long> nativeNetworkObservers;
    private final ArrayList<NetworkObserver> networkObservers;
    private final Object autoDetectorLock = new Object();
    private NetworkMonitorAutoDetect autoDetector;
    private int numMonitors = 0;
    private NetworkMonitorAutoDetect.ConnectionType currentConnectionType = NetworkMonitorAutoDetect.ConnectionType.CONNECTION_UNKNOWN;

    private NetworkMonitor() {
        this.nativeNetworkObservers = new ArrayList();
        this.networkObservers = new ArrayList();
    }

    @Deprecated
    public static void init(Context context) {
    }

    @CalledByNative
    public static NetworkMonitor getInstance() {
        return InstanceHolder.instance;
    }

    private static void assertIsTrue(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"Expected to be true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitoring() {
        Object object = this.autoDetectorLock;
        synchronized (object) {
            ++this.numMonitors;
            if (this.autoDetector == null) {
                this.autoDetector = this.createAutoDetector(ContextUtils.getApplicationContext());
            }
            this.currentConnectionType = NetworkMonitorAutoDetect.getConnectionType(this.autoDetector.getCurrentNetworkState());
        }
    }

    @CalledByNative
    private void startMonitoring(long l2) {
        Logging.d(TAG, "Start monitoring with native observer " + l2);
        this.startMonitoring();
        this.nativeNetworkObservers.add(l2);
        this.updateObserverActiveNetworkList(l2);
        this.notifyObserversOfConnectionTypeChange(this.currentConnectionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoring() {
        Object object = this.autoDetectorLock;
        synchronized (object) {
            if (--this.numMonitors == 0) {
                this.autoDetector.destroy();
                this.autoDetector = null;
            }
        }
    }

    @CalledByNative
    private void stopMonitoring(long l2) {
        Logging.d(TAG, "Stop monitoring with native observer " + l2);
        this.stopMonitoring();
        this.nativeNetworkObservers.remove(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean networkBindingSupported() {
        Object object = this.autoDetectorLock;
        synchronized (object) {
            return this.autoDetector != null && this.autoDetector.supportNetworkCallback();
        }
    }

    @CalledByNative
    private static int androidSdkInt() {
        return Build.VERSION.SDK_INT;
    }

    private NetworkMonitorAutoDetect.ConnectionType getCurrentConnectionType() {
        return this.currentConnectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentDefaultNetId() {
        Object object = this.autoDetectorLock;
        synchronized (object) {
            return this.autoDetector == null ? -1L : this.autoDetector.getDefaultNetId();
        }
    }

    private NetworkMonitorAutoDetect createAutoDetector(Context context) {
        return new NetworkMonitorAutoDetect(new NetworkMonitorAutoDetect.Observer(){

            @Override
            public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType connectionType) {
                NetworkMonitor.this.updateCurrentConnectionType(connectionType);
            }

            @Override
            public void onNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
                NetworkMonitor.this.notifyObserversOfNetworkConnect(networkInformation);
            }

            @Override
            public void onNetworkDisconnect(long l2) {
                NetworkMonitor.this.notifyObserversOfNetworkDisconnect(l2);
            }
        }, context);
    }

    private void updateCurrentConnectionType(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        this.currentConnectionType = connectionType;
        this.notifyObserversOfConnectionTypeChange(connectionType);
    }

    private void notifyObserversOfConnectionTypeChange(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        Iterator<Object> iterator = this.nativeNetworkObservers.iterator();
        while (iterator.hasNext()) {
            long l2 = iterator.next();
            this.nativeNotifyConnectionTypeChanged(l2);
        }
        for (NetworkObserver networkObserver : this.networkObservers) {
            networkObserver.onConnectionTypeChanged(connectionType);
        }
    }

    private void notifyObserversOfNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
        for (long l2 : this.nativeNetworkObservers) {
            this.nativeNotifyOfNetworkConnect(l2, networkInformation);
        }
    }

    private void notifyObserversOfNetworkDisconnect(long l2) {
        for (long l3 : this.nativeNetworkObservers) {
            this.nativeNotifyOfNetworkDisconnect(l3, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObserverActiveNetworkList(long l2) {
        NetworkMonitorAutoDetect.NetworkInformation[] networkInformationArray = this.autoDetectorLock;
        synchronized (this.autoDetectorLock) {
            List<NetworkMonitorAutoDetect.NetworkInformation> list = this.autoDetector == null ? null : this.autoDetector.getActiveNetworkList();
            // ** MonitorExit[var4_2] (shouldn't be in output)
            if (list == null || list.size() == 0) {
                return;
            }
            networkInformationArray = new NetworkMonitorAutoDetect.NetworkInformation[list.size()];
            networkInformationArray = list.toArray(networkInformationArray);
            this.nativeNotifyOfActiveNetworkList(l2, networkInformationArray);
            return;
        }
    }

    public static void addNetworkObserver(NetworkObserver networkObserver) {
        NetworkMonitor.getInstance().addNetworkObserverInternal(networkObserver);
    }

    private void addNetworkObserverInternal(NetworkObserver networkObserver) {
        this.networkObservers.add(networkObserver);
    }

    public static void removeNetworkObserver(NetworkObserver networkObserver) {
        NetworkMonitor.getInstance().removeNetworkObserverInternal(networkObserver);
    }

    private void removeNetworkObserverInternal(NetworkObserver networkObserver) {
        this.networkObservers.remove(networkObserver);
    }

    public static boolean isOnline() {
        NetworkMonitorAutoDetect.ConnectionType connectionType = NetworkMonitor.getInstance().getCurrentConnectionType();
        return connectionType != NetworkMonitorAutoDetect.ConnectionType.CONNECTION_NONE;
    }

    @NativeClassQualifiedName(value="webrtc::jni::AndroidNetworkMonitor")
    private native void nativeNotifyConnectionTypeChanged(long var1);

    @NativeClassQualifiedName(value="webrtc::jni::AndroidNetworkMonitor")
    private native void nativeNotifyOfNetworkConnect(long var1, NetworkMonitorAutoDetect.NetworkInformation var3);

    @NativeClassQualifiedName(value="webrtc::jni::AndroidNetworkMonitor")
    private native void nativeNotifyOfNetworkDisconnect(long var1, long var3);

    @NativeClassQualifiedName(value="webrtc::jni::AndroidNetworkMonitor")
    private native void nativeNotifyOfActiveNetworkList(long var1, NetworkMonitorAutoDetect.NetworkInformation[] var3);

    static NetworkMonitorAutoDetect getAutoDetectorForTest(Context context) {
        NetworkMonitorAutoDetect networkMonitorAutoDetect;
        NetworkMonitor networkMonitor = NetworkMonitor.getInstance();
        networkMonitor.autoDetector = networkMonitorAutoDetect = networkMonitor.createAutoDetector(context);
        return networkMonitor.autoDetector;
    }

    private static class InstanceHolder {
        static final NetworkMonitor instance = new NetworkMonitor();

        private InstanceHolder() {
        }
    }

    public static interface NetworkObserver {
        public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType var1);
    }
}

