/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.webrtc.CalledByNative;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.JNINamespace;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.NativePeerConnectionFactory;
import org.webrtc.RTCStatsCollectorCallback;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.StatsObserver;
import org.webrtc.TurnCustomizer;

@JNINamespace(value="webrtc::jni")
public class PeerConnection {
    private final List<MediaStream> localStreams = new ArrayList<MediaStream>();
    private final long nativePeerConnection;
    private List<RtpSender> senders = new ArrayList<RtpSender>();
    private List<RtpReceiver> receivers = new ArrayList<RtpReceiver>();

    public PeerConnection(NativePeerConnectionFactory nativePeerConnectionFactory) {
        this(nativePeerConnectionFactory.createNativePeerConnection());
    }

    PeerConnection(long l2) {
        this.nativePeerConnection = l2;
    }

    public SessionDescription getLocalDescription() {
        return this.nativeGetLocalDescription();
    }

    public SessionDescription getRemoteDescription() {
        return this.nativeGetRemoteDescription();
    }

    public DataChannel createDataChannel(String string, DataChannel.Init init) {
        return this.nativeCreateDataChannel(string, init);
    }

    public void createOffer(SdpObserver sdpObserver, MediaConstraints mediaConstraints) {
        this.nativeCreateOffer(sdpObserver, mediaConstraints);
    }

    public void createAnswer(SdpObserver sdpObserver, MediaConstraints mediaConstraints) {
        this.nativeCreateAnswer(sdpObserver, mediaConstraints);
    }

    public void setLocalDescription(SdpObserver sdpObserver, SessionDescription sessionDescription) {
        this.nativeSetLocalDescription(sdpObserver, sessionDescription);
    }

    public void setRemoteDescription(SdpObserver sdpObserver, SessionDescription sessionDescription) {
        this.nativeSetRemoteDescription(sdpObserver, sessionDescription);
    }

    public void setAudioPlayout(boolean bl) {
        this.nativeSetAudioPlayout(bl);
    }

    public void setAudioRecording(boolean bl) {
        this.nativeSetAudioRecording(bl);
    }

    public boolean setConfiguration(RTCConfiguration rTCConfiguration) {
        return this.nativeSetConfiguration(rTCConfiguration);
    }

    public boolean addIceCandidate(IceCandidate iceCandidate) {
        return this.nativeAddIceCandidate(iceCandidate.sdpMid, iceCandidate.sdpMLineIndex, iceCandidate.sdp);
    }

    public boolean removeIceCandidates(IceCandidate[] iceCandidateArray) {
        return this.nativeRemoveIceCandidates(iceCandidateArray);
    }

    public boolean addStream(MediaStream mediaStream) {
        boolean bl = this.nativeAddLocalStream(mediaStream.nativeStream);
        if (!bl) {
            return false;
        }
        this.localStreams.add(mediaStream);
        return true;
    }

    public void removeStream(MediaStream mediaStream) {
        this.nativeRemoveLocalStream(mediaStream.nativeStream);
        this.localStreams.remove(mediaStream);
    }

    public RtpSender createSender(String string, String string2) {
        RtpSender rtpSender = this.nativeCreateSender(string, string2);
        if (rtpSender != null) {
            this.senders.add(rtpSender);
        }
        return rtpSender;
    }

    public List<RtpSender> getSenders() {
        for (RtpSender rtpSender : this.senders) {
            rtpSender.dispose();
        }
        this.senders = this.nativeGetSenders();
        return Collections.unmodifiableList(this.senders);
    }

    public List<RtpReceiver> getReceivers() {
        for (RtpReceiver rtpReceiver : this.receivers) {
            rtpReceiver.dispose();
        }
        this.receivers = this.nativeGetReceivers();
        return Collections.unmodifiableList(this.receivers);
    }

    @Deprecated
    public boolean getStats(StatsObserver statsObserver, MediaStreamTrack mediaStreamTrack) {
        return this.nativeOldGetStats(statsObserver, mediaStreamTrack == null ? 0L : mediaStreamTrack.nativeTrack);
    }

    public void getStats(RTCStatsCollectorCallback rTCStatsCollectorCallback) {
        this.nativeNewGetStats(rTCStatsCollectorCallback);
    }

    public boolean setBitrate(Integer n2, Integer n3, Integer n4) {
        return this.nativeSetBitrate(n2, n3, n4);
    }

    public boolean startRtcEventLog(int n2, int n3) {
        return this.nativeStartRtcEventLog(n2, n3);
    }

    public void stopRtcEventLog() {
        this.nativeStopRtcEventLog();
    }

    public SignalingState signalingState() {
        return this.nativeSignalingState();
    }

    public IceConnectionState iceConnectionState() {
        return this.nativeIceConnectionState();
    }

    public IceGatheringState iceGatheringState() {
        return this.nativeIceGatheringState();
    }

    public void close() {
        this.nativeClose();
    }

    public void dispose() {
        this.close();
        for (MediaStream object : this.localStreams) {
            this.nativeRemoveLocalStream(object.nativeStream);
            object.dispose();
        }
        this.localStreams.clear();
        for (RtpSender rtpSender : this.senders) {
            rtpSender.dispose();
        }
        this.senders.clear();
        for (RtpReceiver rtpReceiver : this.receivers) {
            rtpReceiver.dispose();
        }
        this.receivers.clear();
        PeerConnection.nativeFreeOwnedPeerConnection(this.nativePeerConnection);
    }

    public long getNativePeerConnection() {
        return this.nativeGetNativePeerConnection();
    }

    @CalledByNative
    long getNativeOwnedPeerConnection() {
        return this.nativePeerConnection;
    }

    public static long createNativePeerConnectionObserver(Observer observer) {
        return PeerConnection.nativeCreatePeerConnectionObserver(observer);
    }

    private native long nativeGetNativePeerConnection();

    private native SessionDescription nativeGetLocalDescription();

    private native SessionDescription nativeGetRemoteDescription();

    private native DataChannel nativeCreateDataChannel(String var1, DataChannel.Init var2);

    private native void nativeCreateOffer(SdpObserver var1, MediaConstraints var2);

    private native void nativeCreateAnswer(SdpObserver var1, MediaConstraints var2);

    private native void nativeSetLocalDescription(SdpObserver var1, SessionDescription var2);

    private native void nativeSetRemoteDescription(SdpObserver var1, SessionDescription var2);

    private native void nativeSetAudioPlayout(boolean var1);

    private native void nativeSetAudioRecording(boolean var1);

    private native boolean nativeSetBitrate(Integer var1, Integer var2, Integer var3);

    private native SignalingState nativeSignalingState();

    private native IceConnectionState nativeIceConnectionState();

    private native IceGatheringState nativeIceGatheringState();

    private native void nativeClose();

    private static native long nativeCreatePeerConnectionObserver(Observer var0);

    private static native void nativeFreeOwnedPeerConnection(long var0);

    private native boolean nativeSetConfiguration(RTCConfiguration var1);

    private native boolean nativeAddIceCandidate(String var1, int var2, String var3);

    private native boolean nativeRemoveIceCandidates(IceCandidate[] var1);

    private native boolean nativeAddLocalStream(long var1);

    private native void nativeRemoveLocalStream(long var1);

    private native boolean nativeOldGetStats(StatsObserver var1, long var2);

    private native void nativeNewGetStats(RTCStatsCollectorCallback var1);

    private native RtpSender nativeCreateSender(String var1, String var2);

    private native List<RtpSender> nativeGetSenders();

    private native List<RtpReceiver> nativeGetReceivers();

    private native boolean nativeStartRtcEventLog(int var1, int var2);

    private native void nativeStopRtcEventLog();

    public static class RTCConfiguration {
        public IceTransportsType iceTransportsType = IceTransportsType.ALL;
        public List<IceServer> iceServers;
        public BundlePolicy bundlePolicy = BundlePolicy.BALANCED;
        public RtcpMuxPolicy rtcpMuxPolicy = RtcpMuxPolicy.REQUIRE;
        public TcpCandidatePolicy tcpCandidatePolicy = TcpCandidatePolicy.ENABLED;
        public CandidateNetworkPolicy candidateNetworkPolicy = CandidateNetworkPolicy.ALL;
        public int audioJitterBufferMaxPackets;
        public boolean audioJitterBufferFastAccelerate;
        public int iceConnectionReceivingTimeout;
        public int iceBackupCandidatePairPingInterval;
        public KeyType keyType;
        public ContinualGatheringPolicy continualGatheringPolicy;
        public int iceCandidatePoolSize;
        public boolean pruneTurnPorts;
        public boolean presumeWritableWhenFullyRelayed;
        public Integer iceCheckMinInterval;
        public Integer stunCandidateKeepaliveIntervalMs;
        public boolean disableIPv6OnWifi;
        public int maxIPv6Networks;
        public IntervalRange iceRegatherIntervalRange;
        public boolean disableIpv6;
        public boolean enableDscp;
        public boolean enableCpuOveruseDetection;
        public boolean enableRtpDataChannel;
        public boolean suspendBelowMinBitrate;
        public Integer screencastMinBitrate;
        public Boolean combinedAudioVideoBwe;
        public Boolean enableDtlsSrtp;
        public AdapterType networkPreference;
        public TurnCustomizer turnCustomizer;
        public String mixFilePath;
        public boolean mixSupport;
        public boolean isLoop;

        public RTCConfiguration(List<IceServer> list) {
            this.iceServers = list;
            this.audioJitterBufferMaxPackets = 50;
            this.audioJitterBufferFastAccelerate = false;
            this.iceConnectionReceivingTimeout = -1;
            this.iceBackupCandidatePairPingInterval = -1;
            this.keyType = KeyType.ECDSA;
            this.continualGatheringPolicy = ContinualGatheringPolicy.GATHER_ONCE;
            this.iceCandidatePoolSize = 0;
            this.pruneTurnPorts = false;
            this.presumeWritableWhenFullyRelayed = false;
            this.iceCheckMinInterval = null;
            this.stunCandidateKeepaliveIntervalMs = null;
            this.disableIPv6OnWifi = false;
            this.maxIPv6Networks = 5;
            this.iceRegatherIntervalRange = null;
            this.disableIpv6 = false;
            this.enableDscp = false;
            this.enableCpuOveruseDetection = false;
            this.enableRtpDataChannel = false;
            this.suspendBelowMinBitrate = false;
            this.screencastMinBitrate = null;
            this.combinedAudioVideoBwe = null;
            this.enableDtlsSrtp = null;
            this.mixFilePath = "";
            this.mixSupport = false;
            this.isLoop = false;
            this.networkPreference = AdapterType.UNKNOWN;
        }

        @CalledByNative(value="RTCConfiguration")
        IceTransportsType getIceTransportsType() {
            return this.iceTransportsType;
        }

        @CalledByNative(value="RTCConfiguration")
        List<IceServer> getIceServers() {
            return this.iceServers;
        }

        @CalledByNative(value="RTCConfiguration")
        BundlePolicy getBundlePolicy() {
            return this.bundlePolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        RtcpMuxPolicy getRtcpMuxPolicy() {
            return this.rtcpMuxPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        TcpCandidatePolicy getTcpCandidatePolicy() {
            return this.tcpCandidatePolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        CandidateNetworkPolicy getCandidateNetworkPolicy() {
            return this.candidateNetworkPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        int getAudioJitterBufferMaxPackets() {
            return this.audioJitterBufferMaxPackets;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getAudioJitterBufferFastAccelerate() {
            return this.audioJitterBufferFastAccelerate;
        }

        @CalledByNative(value="RTCConfiguration")
        int getIceConnectionReceivingTimeout() {
            return this.iceConnectionReceivingTimeout;
        }

        @CalledByNative(value="RTCConfiguration")
        int getIceBackupCandidatePairPingInterval() {
            return this.iceBackupCandidatePairPingInterval;
        }

        @CalledByNative(value="RTCConfiguration")
        KeyType getKeyType() {
            return this.keyType;
        }

        @CalledByNative(value="RTCConfiguration")
        ContinualGatheringPolicy getContinualGatheringPolicy() {
            return this.continualGatheringPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        int getIceCandidatePoolSize() {
            return this.iceCandidatePoolSize;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getPruneTurnPorts() {
            return this.pruneTurnPorts;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getPresumeWritableWhenFullyRelayed() {
            return this.presumeWritableWhenFullyRelayed;
        }

        @CalledByNative(value="RTCConfiguration")
        Integer getIceCheckMinInterval() {
            return this.iceCheckMinInterval;
        }

        @CalledByNative(value="RTCConfiguration")
        Integer getStunCandidateKeepaliveInterval() {
            return this.stunCandidateKeepaliveIntervalMs;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getDisableIPv6OnWifi() {
            return this.disableIPv6OnWifi;
        }

        @CalledByNative(value="RTCConfiguration")
        int getMaxIPv6Networks() {
            return this.maxIPv6Networks;
        }

        @CalledByNative(value="RTCConfiguration")
        IntervalRange getIceRegatherIntervalRange() {
            return this.iceRegatherIntervalRange;
        }

        @CalledByNative(value="RTCConfiguration")
        TurnCustomizer getTurnCustomizer() {
            return this.turnCustomizer;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getDisableIpv6() {
            return this.disableIpv6;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getEnableDscp() {
            return this.enableDscp;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getEnableCpuOveruseDetection() {
            return this.enableCpuOveruseDetection;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getEnableRtpDataChannel() {
            return this.enableRtpDataChannel;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getSuspendBelowMinBitrate() {
            return this.suspendBelowMinBitrate;
        }

        @CalledByNative(value="RTCConfiguration")
        Integer getScreencastMinBitrate() {
            return this.screencastMinBitrate;
        }

        @CalledByNative(value="RTCConfiguration")
        Boolean getCombinedAudioVideoBwe() {
            return this.combinedAudioVideoBwe;
        }

        @CalledByNative(value="RTCConfiguration")
        Boolean getEnableDtlsSrtp() {
            return this.enableDtlsSrtp;
        }

        @CalledByNative(value="RTCConfiguration")
        AdapterType getNetworkPreference() {
            return this.networkPreference;
        }

        @CalledByNative(value="RTCConfiguration")
        String getMixFilePath() {
            return this.mixFilePath;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getMixSupport() {
            return this.mixSupport;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getIsLoop() {
            return this.isLoop;
        }
    }

    public static class IntervalRange {
        private final int min;
        private final int max;

        public IntervalRange(int n2, int n3) {
            this.min = n2;
            this.max = n3;
        }

        @CalledByNative(value="IntervalRange")
        public int getMin() {
            return this.min;
        }

        @CalledByNative(value="IntervalRange")
        public int getMax() {
            return this.max;
        }
    }

    public static enum ContinualGatheringPolicy {
        GATHER_ONCE,
        GATHER_CONTINUALLY;

    }

    public static enum KeyType {
        RSA,
        ECDSA;

    }

    public static enum AdapterType {
        UNKNOWN,
        ETHERNET,
        WIFI,
        CELLULAR,
        VPN,
        LOOPBACK;

    }

    public static enum CandidateNetworkPolicy {
        ALL,
        LOW_COST;

    }

    public static enum TcpCandidatePolicy {
        ENABLED,
        DISABLED;

    }

    public static enum RtcpMuxPolicy {
        NEGOTIATE,
        REQUIRE;

    }

    public static enum BundlePolicy {
        BALANCED,
        MAXBUNDLE,
        MAXCOMPAT;

    }

    public static enum IceTransportsType {
        NONE,
        RELAY,
        NOHOST,
        ALL;

    }

    public static class IceServer {
        @Deprecated
        public final String uri;
        public final List<String> urls;
        public final String username;
        public final String password;
        public final TlsCertPolicy tlsCertPolicy;
        public final String hostname;
        public final List<String> tlsAlpnProtocols;
        public final List<String> tlsEllipticCurves;

        @Deprecated
        public IceServer(String string) {
            this(string, "", "");
        }

        @Deprecated
        public IceServer(String string, String string2, String string3) {
            this(string, string2, string3, TlsCertPolicy.TLS_CERT_POLICY_SECURE);
        }

        @Deprecated
        public IceServer(String string, String string2, String string3, TlsCertPolicy tlsCertPolicy) {
            this(string, string2, string3, tlsCertPolicy, "");
        }

        @Deprecated
        public IceServer(String string, String string2, String string3, TlsCertPolicy tlsCertPolicy, String string4) {
            this(string, Collections.singletonList(string), string2, string3, tlsCertPolicy, string4, null, null);
        }

        private IceServer(String string, List<String> list, String string2, String string3, TlsCertPolicy tlsCertPolicy, String string4, List<String> list2, List<String> list3) {
            if (string == null || list == null || list.isEmpty()) {
                throw new IllegalArgumentException("uri == null || urls == null || urls.isEmpty()");
            }
            for (String string5 : list) {
                if (string5 != null) continue;
                throw new IllegalArgumentException("urls element is null: " + list);
            }
            if (string2 == null) {
                throw new IllegalArgumentException("username == null");
            }
            if (string3 == null) {
                throw new IllegalArgumentException("password == null");
            }
            if (string4 == null) {
                throw new IllegalArgumentException("hostname == null");
            }
            this.uri = string;
            this.urls = list;
            this.username = string2;
            this.password = string3;
            this.tlsCertPolicy = tlsCertPolicy;
            this.hostname = string4;
            this.tlsAlpnProtocols = list2;
            this.tlsEllipticCurves = list3;
        }

        public String toString() {
            return this.urls + " [" + this.username + ":" + this.password + "] [" + (Object)((Object)this.tlsCertPolicy) + "] [" + this.hostname + "] [" + this.tlsAlpnProtocols + "] [" + this.tlsEllipticCurves + "]";
        }

        public static Builder builder(String string) {
            return new Builder(Collections.singletonList(string));
        }

        public static Builder builder(List<String> list) {
            return new Builder(list);
        }

        @CalledByNative(value="IceServer")
        List<String> getUrls() {
            return this.urls;
        }

        @CalledByNative(value="IceServer")
        String getUsername() {
            return this.username;
        }

        @CalledByNative(value="IceServer")
        String getPassword() {
            return this.password;
        }

        @CalledByNative(value="IceServer")
        TlsCertPolicy getTlsCertPolicy() {
            return this.tlsCertPolicy;
        }

        @CalledByNative(value="IceServer")
        String getHostname() {
            return this.hostname;
        }

        @CalledByNative(value="IceServer")
        List<String> getTlsAlpnProtocols() {
            return this.tlsAlpnProtocols;
        }

        @CalledByNative(value="IceServer")
        List<String> getTlsEllipticCurves() {
            return this.tlsEllipticCurves;
        }

        public static class Builder {
            private final List<String> urls;
            private String username = "";
            private String password = "";
            private TlsCertPolicy tlsCertPolicy = TlsCertPolicy.TLS_CERT_POLICY_SECURE;
            private String hostname = "";
            private List<String> tlsAlpnProtocols;
            private List<String> tlsEllipticCurves;

            private Builder(List<String> list) {
                if (list == null || list.isEmpty()) {
                    throw new IllegalArgumentException("urls == null || urls.isEmpty(): " + list);
                }
                this.urls = list;
            }

            public Builder setUsername(String string) {
                this.username = string;
                return this;
            }

            public Builder setPassword(String string) {
                this.password = string;
                return this;
            }

            public Builder setTlsCertPolicy(TlsCertPolicy tlsCertPolicy) {
                this.tlsCertPolicy = tlsCertPolicy;
                return this;
            }

            public Builder setHostname(String string) {
                this.hostname = string;
                return this;
            }

            public Builder setTlsAlpnProtocols(List<String> list) {
                this.tlsAlpnProtocols = list;
                return this;
            }

            public Builder setTlsEllipticCurves(List<String> list) {
                this.tlsEllipticCurves = list;
                return this;
            }

            public IceServer createIceServer() {
                return new IceServer(this.urls.get(0), this.urls, this.username, this.password, this.tlsCertPolicy, this.hostname, this.tlsAlpnProtocols, this.tlsEllipticCurves);
            }
        }
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onSignalingChange(SignalingState var1);

        @CalledByNative(value="Observer")
        public void onIceConnectionChange(IceConnectionState var1);

        @CalledByNative(value="Observer")
        public void onIceConnectionReceivingChange(boolean var1);

        @CalledByNative(value="Observer")
        public void onIceGatheringChange(IceGatheringState var1);

        @CalledByNative(value="Observer")
        public void onIceCandidate(IceCandidate var1);

        @CalledByNative(value="Observer")
        public void onIceCandidatesRemoved(IceCandidate[] var1);

        @CalledByNative(value="Observer")
        public void onAddStream(MediaStream var1);

        @CalledByNative(value="Observer")
        public void onRemoveStream(MediaStream var1);

        @CalledByNative(value="Observer")
        public void onDataChannel(DataChannel var1);

        @CalledByNative(value="Observer")
        public void onRenegotiationNeeded();

        @CalledByNative(value="Observer")
        public void onAddTrack(RtpReceiver var1, MediaStream[] var2);
    }

    public static enum SignalingState {
        STABLE,
        HAVE_LOCAL_OFFER,
        HAVE_LOCAL_PRANSWER,
        HAVE_REMOTE_OFFER,
        HAVE_REMOTE_PRANSWER,
        CLOSED;


        @CalledByNative(value="SignalingState")
        static SignalingState fromNativeIndex(int n2) {
            return SignalingState.values()[n2];
        }
    }

    public static enum TlsCertPolicy {
        TLS_CERT_POLICY_SECURE,
        TLS_CERT_POLICY_INSECURE_NO_CHECK;

    }

    public static enum IceConnectionState {
        NEW,
        CHECKING,
        CONNECTED,
        COMPLETED,
        FAILED,
        DISCONNECTED,
        CLOSED;


        @CalledByNative(value="IceConnectionState")
        static IceConnectionState fromNativeIndex(int n2) {
            return IceConnectionState.values()[n2];
        }
    }

    public static enum IceGatheringState {
        NEW,
        GATHERING,
        COMPLETE;


        @CalledByNative(value="IceGatheringState")
        static IceGatheringState fromNativeIndex(int n2) {
            return IceGatheringState.values()[n2];
        }
    }
}

