/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import com.ucloudrtclib.a.i;
import com.ucloudrtclib.d.d;
import java.util.List;
import org.webrtc.AndroidVideoTrackSourceObserver;
import org.webrtc.AudioProcessingFactory;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.CalledByNative;
import org.webrtc.ContextUtils;
import org.webrtc.EglBase;
import org.webrtc.FecControllerFactoryFactoryInterface;
import org.webrtc.JNINamespace;
import org.webrtc.Logging;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.NativeLibrary;
import org.webrtc.NativeLibraryLoader;
import org.webrtc.PeerConnection;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;

@JNINamespace(value="webrtc::jni")
public class PeerConnectionFactory {
    public static final String TRIAL_ENABLED = "Enabled";
    @Deprecated
    public static final String VIDEO_FRAME_EMIT_TRIAL = "VideoFrameEmit";
    private static final String TAG = "PeerConnectionFactory";
    private static final String VIDEO_CAPTURER_THREAD_NAME = "VideoCapturerThread";
    private long nativeFactory;
    private static volatile boolean internalTracerInitialized = false;
    private static Context applicationContext;
    private static Thread networkThread;
    private static Thread workerThread;
    private static Thread signalingThread;
    private EglBase localEglbase;
    private EglBase remoteEglbase;

    public static Builder builder() {
        return new Builder();
    }

    public static void initialize(InitializationOptions initializationOptions) {
        ContextUtils.initialize(initializationOptions.applicationContext);
        if (!NativeLibrary.initialize(initializationOptions.nativeLibraryLoader)) {
            return;
        }
        PeerConnectionFactory.nativeInitializeAndroidGlobals(initializationOptions.applicationContext, initializationOptions.enableVideoHwAcceleration);
        PeerConnectionFactory.initializeFieldTrials(initializationOptions.fieldTrials);
        if (initializationOptions.enableInternalTracer && !internalTracerInitialized) {
            PeerConnectionFactory.initializeInternalTracer();
        }
    }

    private boolean checkInitializeHasBeenCalled() {
        if (!NativeLibrary.isLoaded() || ContextUtils.getApplicationContext() == null) {
            Logging.e(TAG, "PeerConnectionFactory.initialize was not called before creating a PeerConnectionFactory.");
            return false;
        }
        return true;
    }

    private static void initializeInternalTracer() {
        internalTracerInitialized = true;
        PeerConnectionFactory.nativeInitializeInternalTracer();
    }

    public static void shutdownInternalTracer() {
        internalTracerInitialized = false;
        PeerConnectionFactory.nativeShutdownInternalTracer();
    }

    @Deprecated
    public static void initializeFieldTrials(String string) {
        PeerConnectionFactory.nativeInitializeFieldTrials(string);
    }

    public static String fieldTrialsFindFullName(String string) {
        return NativeLibrary.isLoaded() ? PeerConnectionFactory.nativeFindFieldTrialsFullName(string) : "";
    }

    public static boolean startInternalTracingCapture(String string) {
        return PeerConnectionFactory.nativeStartInternalTracingCapture(string);
    }

    public static void stopInternalTracingCapture() {
        PeerConnectionFactory.nativeStopInternalTracingCapture();
    }

    @Deprecated
    public PeerConnectionFactory() {
        this(null);
    }

    @Deprecated
    public PeerConnectionFactory(Options options) {
        this(options, null, null);
    }

    @Deprecated
    public PeerConnectionFactory(Options options, VideoEncoderFactory videoEncoderFactory, VideoDecoderFactory videoDecoderFactory) {
        if (this.checkInitializeHasBeenCalled()) {
            this.nativeFactory = PeerConnectionFactory.nativeCreatePeerConnectionFactory(options, videoEncoderFactory, videoDecoderFactory, 0L, 0L);
            if (this.nativeFactory == 0L) {
                throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
            }
        }
    }

    @Deprecated
    public PeerConnectionFactory(Options options, VideoEncoderFactory videoEncoderFactory, VideoDecoderFactory videoDecoderFactory, AudioProcessingFactory audioProcessingFactory) {
        this(options, videoEncoderFactory, videoDecoderFactory, audioProcessingFactory, null);
    }

    private PeerConnectionFactory(Options options, VideoEncoderFactory videoEncoderFactory, VideoDecoderFactory videoDecoderFactory, AudioProcessingFactory audioProcessingFactory, FecControllerFactoryFactoryInterface fecControllerFactoryFactoryInterface) {
        if (this.checkInitializeHasBeenCalled()) {
            this.nativeFactory = PeerConnectionFactory.nativeCreatePeerConnectionFactory(options, videoEncoderFactory, videoDecoderFactory, audioProcessingFactory == null ? 0L : audioProcessingFactory.createNative(), fecControllerFactoryFactoryInterface == null ? 0L : fecControllerFactoryFactoryInterface.createNative());
            if (this.nativeFactory == 0L) {
                throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
            }
        }
    }

    @Deprecated
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, MediaConstraints mediaConstraints, PeerConnection.Observer observer) {
        long l2 = PeerConnection.createNativePeerConnectionObserver(observer);
        if (l2 == 0L) {
            return null;
        }
        long l3 = PeerConnectionFactory.nativeCreatePeerConnection(this.nativeFactory, rTCConfiguration, mediaConstraints, l2);
        if (l3 == 0L) {
            return null;
        }
        return new PeerConnection(l3);
    }

    @Deprecated
    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> list, MediaConstraints mediaConstraints, PeerConnection.Observer observer) {
        PeerConnection.RTCConfiguration rTCConfiguration = new PeerConnection.RTCConfiguration(list);
        return this.createPeerConnection(rTCConfiguration, mediaConstraints, observer);
    }

    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> list, PeerConnection.Observer observer) {
        PeerConnection.RTCConfiguration rTCConfiguration = new PeerConnection.RTCConfiguration(list);
        return this.createPeerConnection(rTCConfiguration, observer);
    }

    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, PeerConnection.Observer observer) {
        return this.createPeerConnection(rTCConfiguration, null, observer);
    }

    public MediaStream createLocalMediaStream(String string) {
        return new MediaStream(PeerConnectionFactory.nativeCreateLocalMediaStream(this.nativeFactory, string));
    }

    public VideoSource createVideoSource(VideoCapturer videoCapturer, int n2) {
        EglBase.Context context = this.localEglbase == null ? null : this.localEglbase.getEglBaseContext();
        SurfaceTextureHelper surfaceTextureHelper = SurfaceTextureHelper.create(VIDEO_CAPTURER_THREAD_NAME, context);
        long l2 = PeerConnectionFactory.nativeCreateVideoSource(this.nativeFactory, surfaceTextureHelper, videoCapturer.isScreencast(), n2);
        AndroidVideoTrackSourceObserver androidVideoTrackSourceObserver = new AndroidVideoTrackSourceObserver(l2);
        videoCapturer.initialize(surfaceTextureHelper, ContextUtils.getApplicationContext(), androidVideoTrackSourceObserver);
        return new VideoSource(l2);
    }

    public VideoTrack createVideoTrack(String string, VideoSource videoSource) {
        return new VideoTrack(PeerConnectionFactory.nativeCreateVideoTrack(this.nativeFactory, string, videoSource.nativeSource));
    }

    public AudioSource createAudioSource(MediaConstraints mediaConstraints) {
        return new AudioSource(PeerConnectionFactory.nativeCreateAudioSource(this.nativeFactory, mediaConstraints));
    }

    public AudioTrack createAudioTrack(String string, AudioSource audioSource) {
        return new AudioTrack(PeerConnectionFactory.nativeCreateAudioTrack(this.nativeFactory, string, audioSource.nativeSource));
    }

    public boolean startAecDump(int n2, int n3) {
        return PeerConnectionFactory.nativeStartAecDump(this.nativeFactory, n2, n3);
    }

    public void stopAecDump() {
        PeerConnectionFactory.nativeStopAecDump(this.nativeFactory);
    }

    public void startPlayAudioFile(String string, boolean bl, boolean bl2) {
        PeerConnectionFactory.nativeStartPlayAudioFile(this.nativeFactory, string, bl, bl2);
    }

    public void stopPlayAudioFile() {
        PeerConnectionFactory.nativeStopPlayAudioFile(this.nativeFactory);
    }

    public void resumeAudioFile() {
        PeerConnectionFactory.nativeResumeAudioFile(this.nativeFactory);
    }

    public void pauseAudioFile() {
        PeerConnectionFactory.nativePauseAudioFile(this.nativeFactory);
    }

    @Deprecated
    public void setOptions(Options options) {
        this.nativeSetOptions(this.nativeFactory, options);
    }

    public void setVideoHwAccelerationOptions(EglBase.Context context, EglBase.Context context2) {
        if (this.localEglbase != null) {
            Logging.w(TAG, "Egl context already set.");
            this.localEglbase.release();
        }
        if (this.remoteEglbase != null) {
            Logging.w(TAG, "Egl context already set.");
            this.remoteEglbase.release();
        }
        this.localEglbase = EglBase.create(context);
        i.d(TAG, "PeerConnectionFactorylocalEglbase: " + this.localEglbase);
        this.remoteEglbase = EglBase.create(context2);
        i.d(TAG, "PeerConnectionFactoryremoteEglbase: " + this.remoteEglbase);
        PeerConnectionFactory.nativeSetVideoHwAccelerationOptions(this.nativeFactory, this.localEglbase.getEglBaseContext(), this.remoteEglbase.getEglBaseContext());
    }

    public void dispose() {
        PeerConnectionFactory.nativeFreeFactory(this.nativeFactory);
        networkThread = null;
        workerThread = null;
        signalingThread = null;
        if (this.localEglbase != null) {
            this.localEglbase.release();
        }
        if (this.remoteEglbase != null) {
            this.remoteEglbase.release();
        }
    }

    public void threadsCallbacks() {
        PeerConnectionFactory.nativeInvokeThreadsCallbacks(this.nativeFactory);
    }

    public long getNativePeerConnectionFactory() {
        return PeerConnectionFactory.nativeGetNativePeerConnectionFactory(this.nativeFactory);
    }

    public long getNativeOwnedFactoryAndThreads() {
        return this.nativeFactory;
    }

    private static void printStackTrace(Thread thread, String string) {
        StackTraceElement[] stackTraceElementArray;
        if (thread != null && (stackTraceElementArray = thread.getStackTrace()).length > 0) {
            Logging.d(TAG, string + " stacks trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    public static void printStackTraces() {
        PeerConnectionFactory.printStackTrace(networkThread, "Network thread");
        PeerConnectionFactory.printStackTrace(workerThread, "Worker thread");
        PeerConnectionFactory.printStackTrace(signalingThread, "Signaling thread");
    }

    @CalledByNative
    private static void onNetworkThreadReady() {
        networkThread = Thread.currentThread();
        Logging.d(TAG, "onNetworkThreadReady");
    }

    @CalledByNative
    private static void onWorkerThreadReady() {
        workerThread = Thread.currentThread();
        Logging.d(TAG, "onWorkerThreadReady");
    }

    @CalledByNative
    private static void onSignalingThreadReady() {
        signalingThread = Thread.currentThread();
        Logging.d(TAG, "onSignalingThreadReady");
    }

    @CalledByNative
    private static void onAudioFileFinish() {
        Logging.d(TAG, "onAudioFileFinish");
        d.dn().onAudioFileFinish();
    }

    private static native void nativeInitializeAndroidGlobals(Context var0, boolean var1);

    private static native void nativeInitializeFieldTrials(String var0);

    private static native String nativeFindFieldTrialsFullName(String var0);

    private static native void nativeInitializeInternalTracer();

    private static native void nativeShutdownInternalTracer();

    private static native boolean nativeStartInternalTracingCapture(String var0);

    private static native void nativeStopInternalTracingCapture();

    private static native long nativeCreatePeerConnectionFactory(Options var0, VideoEncoderFactory var1, VideoDecoderFactory var2, long var3, long var5);

    private static native long nativeCreatePeerConnection(long var0, PeerConnection.RTCConfiguration var2, MediaConstraints var3, long var4);

    private static native long nativeCreateLocalMediaStream(long var0, String var2);

    private static native long nativeCreateVideoSource(long var0, SurfaceTextureHelper var2, boolean var3, int var4);

    private static native long nativeCreateVideoTrack(long var0, String var2, long var3);

    private static native long nativeCreateAudioSource(long var0, MediaConstraints var2);

    private static native long nativeCreateAudioTrack(long var0, String var2, long var3);

    private static native boolean nativeStartAecDump(long var0, int var2, int var3);

    private static native void nativeStopAecDump(long var0);

    @Deprecated
    public native void nativeSetOptions(long var1, Options var3);

    private static native void nativeSetVideoHwAccelerationOptions(long var0, Object var2, Object var3);

    private static native void nativeInvokeThreadsCallbacks(long var0);

    private static native void nativeFreeFactory(long var0);

    private static native long nativeGetNativePeerConnectionFactory(long var0);

    private static native void nativeStartPlayAudioFile(long var0, String var2, boolean var3, boolean var4);

    private static native void nativeStopPlayAudioFile(long var0);

    private static native void nativeResumeAudioFile(long var0);

    private static native void nativePauseAudioFile(long var0);

    private static native int nativeGetAudioMixingDuration(long var0);

    private static native int nativeGetAudioMixingCurrentPosition(long var0);

    private static native void nativeSetAudioMixingPosition(long var0, int var2);

    private static native void nativeUpdateAudioMixingVolume(long var0, int var2);

    public static class Builder {
        private Options options;
        private VideoEncoderFactory encoderFactory;
        private VideoDecoderFactory decoderFactory;
        private AudioProcessingFactory audioProcessingFactory;
        private FecControllerFactoryFactoryInterface fecControllerFactoryFactory;

        private Builder() {
        }

        public Builder setOptions(Options options) {
            this.options = options;
            return this;
        }

        public Builder setVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
            this.encoderFactory = videoEncoderFactory;
            return this;
        }

        public Builder setVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
            this.decoderFactory = videoDecoderFactory;
            return this;
        }

        public Builder setAudioProcessingFactory(AudioProcessingFactory audioProcessingFactory) {
            if (audioProcessingFactory == null) {
                throw new NullPointerException("PeerConnectionFactory builder does not accept a null AudioProcessingFactory.");
            }
            this.audioProcessingFactory = audioProcessingFactory;
            return this;
        }

        public Builder setFecControllerFactoryFactoryInterface(FecControllerFactoryFactoryInterface fecControllerFactoryFactoryInterface) {
            this.fecControllerFactoryFactory = fecControllerFactoryFactoryInterface;
            return this;
        }

        public PeerConnectionFactory createPeerConnectionFactory() {
            return new PeerConnectionFactory(this.options, this.encoderFactory, this.decoderFactory, this.audioProcessingFactory, this.fecControllerFactoryFactory);
        }
    }

    public static class Options {
        static final int ADAPTER_TYPE_UNKNOWN = 0;
        static final int ADAPTER_TYPE_ETHERNET = 1;
        static final int ADAPTER_TYPE_WIFI = 2;
        static final int ADAPTER_TYPE_CELLULAR = 4;
        static final int ADAPTER_TYPE_VPN = 8;
        static final int ADAPTER_TYPE_LOOPBACK = 16;
        public int networkIgnoreMask = 16;
        public boolean disableEncryption = false;
        public boolean disableNetworkMonitor = false;
        public String mixFilePath = "";
        public boolean mixSupport = false;
        public boolean isLoop = true;

        @CalledByNative(value="Options")
        String getMixFilePath() {
            return this.mixFilePath;
        }

        @CalledByNative(value="Options")
        boolean getMixSupport() {
            return this.mixSupport;
        }

        @CalledByNative(value="Options")
        boolean getIsLoop() {
            return this.isLoop;
        }

        @CalledByNative(value="Options")
        int getNetworkIgnoreMask() {
            return this.networkIgnoreMask;
        }

        @CalledByNative(value="Options")
        boolean getDisableEncryption() {
            return this.disableEncryption;
        }

        @CalledByNative(value="Options")
        boolean getDisableNetworkMonitor() {
            return this.disableNetworkMonitor;
        }
    }

    public static class InitializationOptions {
        final Context applicationContext;
        final String fieldTrials;
        final boolean enableInternalTracer;
        final boolean enableVideoHwAcceleration;
        final NativeLibraryLoader nativeLibraryLoader;

        private InitializationOptions(Context context, String string, boolean bl, boolean bl2, NativeLibraryLoader nativeLibraryLoader) {
            this.applicationContext = context;
            this.fieldTrials = string;
            this.enableInternalTracer = bl;
            this.enableVideoHwAcceleration = bl2;
            this.nativeLibraryLoader = nativeLibraryLoader;
        }

        public static Builder builder(Context context) {
            return new Builder(context);
        }

        public static class Builder {
            private final Context applicationContext;
            private String fieldTrials = "";
            private boolean enableInternalTracer = false;
            private boolean enableVideoHwAcceleration = true;
            private NativeLibraryLoader nativeLibraryLoader = new NativeLibrary.DefaultLoader();

            Builder(Context context) {
                this.applicationContext = context;
            }

            public Builder setFieldTrials(String string) {
                this.fieldTrials = string;
                return this;
            }

            public Builder setEnableInternalTracer(boolean bl) {
                this.enableInternalTracer = bl;
                return this;
            }

            public Builder setEnableVideoHwAcceleration(boolean bl) {
                this.enableVideoHwAcceleration = bl;
                return this;
            }

            public Builder setNativeLibraryLoader(NativeLibraryLoader nativeLibraryLoader) {
                this.nativeLibraryLoader = nativeLibraryLoader;
                return this;
            }

            public InitializationOptions createInitializationOptions() {
                return new InitializationOptions(this.applicationContext, this.fieldTrials, this.enableInternalTracer, this.enableVideoHwAcceleration, this.nativeLibraryLoader);
            }
        }
    }
}

