/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.Map;
import org.webrtc.CalledByNative;
import org.webrtc.RTCStats;

public class RTCStatsReport {
    private final long timestampUs;
    private final Map<String, RTCStats> stats;

    public RTCStatsReport(long l2, Map<String, RTCStats> map) {
        this.timestampUs = l2;
        this.stats = map;
    }

    public double getTimestampUs() {
        return this.timestampUs;
    }

    public Map<String, RTCStats> getStatsMap() {
        return this.stats;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ timestampUs: ").append(this.timestampUs).append(", stats: [\n");
        boolean bl = true;
        for (RTCStats rTCStats : this.stats.values()) {
            if (!bl) {
                stringBuilder.append(",\n");
            }
            stringBuilder.append(rTCStats);
            bl = false;
        }
        stringBuilder.append(" ] }");
        return stringBuilder.toString();
    }

    @CalledByNative
    private static RTCStatsReport create(long l2, Map map) {
        return new RTCStatsReport(l2, map);
    }
}

