/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.ArrayList;
import java.util.List;
import org.webrtc.CalledByNative;
import org.webrtc.MediaStreamTrack;

public class RtpParameters {
    public final List<Encoding> encodings;
    public final List<Codec> codecs;

    public RtpParameters() {
        this.encodings = new ArrayList<Encoding>();
        this.codecs = new ArrayList<Codec>();
    }

    @CalledByNative
    RtpParameters(List<Encoding> list, List<Codec> list2) {
        this.encodings = list;
        this.codecs = list2;
    }

    @CalledByNative
    List<Encoding> getEncodings() {
        return this.encodings;
    }

    @CalledByNative
    List<Codec> getCodecs() {
        return this.codecs;
    }

    public static class Codec {
        public int payloadType;
        public String name;
        MediaStreamTrack.MediaType kind;
        public Integer clockRate;
        public Integer numChannels;

        @CalledByNative(value="Codec")
        Codec(int n2, String string, MediaStreamTrack.MediaType mediaType, Integer n3, Integer n4) {
            this.payloadType = n2;
            this.name = string;
            this.kind = mediaType;
            this.clockRate = n3;
            this.numChannels = n4;
        }

        @CalledByNative(value="Codec")
        int getPayloadType() {
            return this.payloadType;
        }

        @CalledByNative(value="Codec")
        String getName() {
            return this.name;
        }

        @CalledByNative(value="Codec")
        MediaStreamTrack.MediaType getKind() {
            return this.kind;
        }

        @CalledByNative(value="Codec")
        Integer getClockRate() {
            return this.clockRate;
        }

        @CalledByNative(value="Codec")
        Integer getNumChannels() {
            return this.numChannels;
        }
    }

    public static class Encoding {
        public boolean active = true;
        public Integer maxBitrateBps;
        public Long ssrc;

        @CalledByNative(value="Encoding")
        Encoding(boolean bl, Integer n2, Long l2) {
            this.active = bl;
            this.maxBitrateBps = n2;
            this.ssrc = l2;
        }

        @CalledByNative(value="Encoding")
        boolean getActive() {
            return this.active;
        }

        @CalledByNative(value="Encoding")
        Integer getMaxBitrateBps() {
            return this.maxBitrateBps;
        }

        @CalledByNative(value="Encoding")
        Long getSsrc() {
            return this.ssrc;
        }
    }
}

