/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.JNINamespace;
import org.webrtc.JniCommon;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RtpParameters;

@JNINamespace(value="webrtc::jni")
public class RtpReceiver {
    final long nativeRtpReceiver;
    private long nativeObserver;
    private MediaStreamTrack cachedTrack;

    @CalledByNative
    public RtpReceiver(long l2) {
        this.nativeRtpReceiver = l2;
        long l3 = RtpReceiver.nativeGetTrack(l2);
        this.cachedTrack = new MediaStreamTrack(l3);
    }

    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public boolean setParameters(RtpParameters rtpParameters) {
        return rtpParameters == null ? false : RtpReceiver.nativeSetParameters(this.nativeRtpReceiver, rtpParameters);
    }

    public RtpParameters getParameters() {
        return RtpReceiver.nativeGetParameters(this.nativeRtpReceiver);
    }

    public String id() {
        return RtpReceiver.nativeGetId(this.nativeRtpReceiver);
    }

    @CalledByNative
    public void dispose() {
        this.cachedTrack.dispose();
        if (this.nativeObserver != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, this.nativeObserver);
            this.nativeObserver = 0L;
        }
        JniCommon.nativeReleaseRef(this.nativeRtpReceiver);
    }

    public void SetObserver(Observer observer) {
        if (this.nativeObserver != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, this.nativeObserver);
        }
        this.nativeObserver = RtpReceiver.nativeSetObserver(this.nativeRtpReceiver, observer);
    }

    private static native long nativeGetTrack(long var0);

    private static native boolean nativeSetParameters(long var0, RtpParameters var2);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native String nativeGetId(long var0);

    private static native long nativeSetObserver(long var0, Observer var2);

    private static native void nativeUnsetObserver(long var0, long var2);

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onFirstPacketReceived(MediaStreamTrack.MediaType var1);
    }
}

