/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.DtmfSender;
import org.webrtc.JNINamespace;
import org.webrtc.JniCommon;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RtpParameters;

@JNINamespace(value="webrtc::jni")
public class RtpSender {
    final long nativeRtpSender;
    private MediaStreamTrack cachedTrack;
    private boolean ownsTrack = true;
    private final DtmfSender dtmfSender;

    @CalledByNative
    public RtpSender(long l2) {
        this.nativeRtpSender = l2;
        long l3 = RtpSender.nativeGetTrack(l2);
        this.cachedTrack = l3 != 0L ? new MediaStreamTrack(l3) : null;
        long l4 = RtpSender.nativeGetDtmfSender(l2);
        this.dtmfSender = l4 != 0L ? new DtmfSender(l4) : null;
    }

    public boolean setTrack(MediaStreamTrack mediaStreamTrack, boolean bl) {
        if (!RtpSender.nativeSetTrack(this.nativeRtpSender, mediaStreamTrack == null ? 0L : mediaStreamTrack.nativeTrack)) {
            return false;
        }
        if (this.cachedTrack != null && this.ownsTrack) {
            this.cachedTrack.dispose();
        }
        this.cachedTrack = mediaStreamTrack;
        this.ownsTrack = bl;
        return true;
    }

    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public boolean setParameters(RtpParameters rtpParameters) {
        return RtpSender.nativeSetParameters(this.nativeRtpSender, rtpParameters);
    }

    public RtpParameters getParameters() {
        return RtpSender.nativeGetParameters(this.nativeRtpSender);
    }

    public String id() {
        return RtpSender.nativeGetId(this.nativeRtpSender);
    }

    public DtmfSender dtmf() {
        return this.dtmfSender;
    }

    public void dispose() {
        if (this.dtmfSender != null) {
            this.dtmfSender.dispose();
        }
        if (this.cachedTrack != null && this.ownsTrack) {
            this.cachedTrack.dispose();
        }
        JniCommon.nativeReleaseRef(this.nativeRtpSender);
    }

    private static native boolean nativeSetTrack(long var0, long var2);

    private static native long nativeGetTrack(long var0);

    private static native long nativeGetDtmfSender(long var0);

    private static native boolean nativeSetParameters(long var0, RtpParameters var2);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native String nativeGetId(long var0);
}

