/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.view.Surface;
import com.ucloudrtclib.a.i;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;

@TargetApi(value=21)
public class ScreenCapturerAndroid
implements SurfaceTextureHelper.OnTextureFrameAvailableListener,
VideoCapturer {
    private static final int DISPLAY_FLAGS = 3;
    private static int VIRTUAL_DISPLAY_DPI = 400;
    private static final String TAG = "ScreenCapturerAndroid";
    private final Intent mediaProjectionPermissionResultData;
    private final MediaProjection.Callback mediaProjectionCallback;
    private int width;
    private int height;
    private VirtualDisplay virtualDisplay;
    private SurfaceTextureHelper surfaceTextureHelper;
    private VideoCapturer.CapturerObserver capturerObserver;
    private long numCapturedFrames = 0L;
    private MediaProjection mediaProjection;
    private boolean isDisposed = false;
    private MediaProjectionManager mediaProjectionManager;
    private static ScreenCapturerAndroid instance;

    public ScreenCapturerAndroid(Intent intent, MediaProjection.Callback callback) {
        this.mediaProjectionPermissionResultData = intent;
        this.mediaProjectionCallback = callback;
    }

    public static ScreenCapturerAndroid getInstance(Intent intent, MediaProjection.Callback callback) {
        if (instance == null) {
            i.d(TAG, "getInstance() is null!");
            instance = new ScreenCapturerAndroid(intent, callback);
        }
        return instance;
    }

    public static void DeleteInstance() {
        if (null != instance) {
            i.d(TAG, "getInstance() is not null, deleting!");
            instance = null;
        }
    }

    private void checkNotDisposed() {
        if (this.isDisposed) {
            throw new RuntimeException("capturer is disposed.");
        }
    }

    @Override
    public synchronized void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, VideoCapturer.CapturerObserver capturerObserver) {
        this.checkNotDisposed();
        if (capturerObserver == null) {
            throw new RuntimeException("capturerObserver not set.");
        }
        this.capturerObserver = capturerObserver;
        if (surfaceTextureHelper == null) {
            throw new RuntimeException("surfaceTextureHelper not set.");
        }
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.mediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
        float f2 = context.getResources().getDisplayMetrics().density;
        i.d(TAG, "get density " + f2);
        VIRTUAL_DISPLAY_DPI = (int)f2 * 160;
        i.d(TAG, "SET DPI " + VIRTUAL_DISPLAY_DPI);
    }

    @Override
    public synchronized void startCapture(int n2, int n3, int n4) {
        this.checkNotDisposed();
        i.d(TAG, "startCapture width: " + n2 + " height: " + n3);
        this.width = n2;
        this.height = n3;
        this.mediaProjection = this.mediaProjectionManager.getMediaProjection(-1, this.mediaProjectionPermissionResultData);
        this.mediaProjection.registerCallback(this.mediaProjectionCallback, this.surfaceTextureHelper.getHandler());
        this.createVirtualDisplay();
        this.capturerObserver.onCapturerStarted(true);
        this.surfaceTextureHelper.startListening(this);
    }

    public synchronized void startCapture(int n2, int n3, int n4, MediaProjection mediaProjection) {
        this.checkNotDisposed();
        i.d(TAG, "startCapture width: " + n2 + " height: " + n3);
        this.width = n2;
        this.height = n3;
        this.mediaProjection = mediaProjection;
        this.mediaProjection.registerCallback(this.mediaProjectionCallback, this.surfaceTextureHelper.getHandler());
        this.createVirtualDisplay();
        this.capturerObserver.onCapturerStarted(true);
        this.surfaceTextureHelper.startListening(this);
    }

    @Override
    public synchronized void stopCapture() {
        this.checkNotDisposed();
        ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                i.d(ScreenCapturerAndroid.TAG, "stopCapture");
                ScreenCapturerAndroid.this.surfaceTextureHelper.stopListening();
                ScreenCapturerAndroid.this.capturerObserver.onCapturerStopped();
                if (ScreenCapturerAndroid.this.virtualDisplay != null) {
                    ScreenCapturerAndroid.this.virtualDisplay.release();
                    ScreenCapturerAndroid.this.virtualDisplay = null;
                }
                if (ScreenCapturerAndroid.this.mediaProjection != null) {
                    ScreenCapturerAndroid.this.mediaProjection.unregisterCallback(ScreenCapturerAndroid.this.mediaProjectionCallback);
                    ScreenCapturerAndroid.this.mediaProjection.stop();
                    ScreenCapturerAndroid.this.mediaProjection = null;
                }
            }
        });
    }

    @Override
    public synchronized void dispose() {
        this.isDisposed = true;
    }

    @Override
    public synchronized void changeCaptureFormat(int n2, int n3, int n4) {
        this.checkNotDisposed();
        this.width = n2;
        this.height = n3;
        i.d(TAG, "changeCaptureFormat width: " + n2 + " height: " + n3);
        if (this.virtualDisplay == null) {
            return;
        }
        ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                ScreenCapturerAndroid.this.virtualDisplay.release();
                ScreenCapturerAndroid.this.createVirtualDisplay();
            }
        });
    }

    private void createVirtualDisplay() {
        i.d(TAG, "createVirtualDisplay width: " + this.width + " height: " + this.height + " dpi: " + VIRTUAL_DISPLAY_DPI);
        this.surfaceTextureHelper.getSurfaceTexture().setDefaultBufferSize(this.width, this.height);
        i.d(TAG, "screen surfaceTexture " + this.surfaceTextureHelper.getSurfaceTexture());
        this.virtualDisplay = this.mediaProjection.createVirtualDisplay("WebRTC_ScreenCapture", this.width, this.height, VIRTUAL_DISPLAY_DPI, 3, new Surface(this.surfaceTextureHelper.getSurfaceTexture()), null, null);
    }

    @Override
    public void onTextureFrameAvailable(int n2, float[] fArray, long l2) {
        ++this.numCapturedFrames;
        VideoFrame.TextureBuffer textureBuffer = this.surfaceTextureHelper.createTextureBuffer(this.width, this.height, RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray));
        VideoFrame videoFrame = new VideoFrame(textureBuffer, 0, l2);
        this.capturerObserver.onFrameCaptured(videoFrame);
        videoFrame.release();
    }

    @Override
    public boolean isScreencast() {
        return true;
    }

    public long getNumCapturedFrames() {
        return this.numCapturedFrames;
    }
}

