/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import com.ucloudrtclib.a.i;
import java.util.ArrayList;
import java.util.HashMap;
import org.webrtc.VP8Encoder;
import org.webrtc.VP9Encoder;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;

public class SoftwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "SoftwareVideoEncoderFac";

    @Override
    public VideoEncoder createEncoder(VideoCodecInfo videoCodecInfo) {
        i.d(TAG, "createEncoder in SoftwareVideoEncoderFac");
        if (videoCodecInfo.name.equalsIgnoreCase("VP8")) {
            i.d(TAG, "create soft ware encoder vp8: ");
            return new VP8Encoder();
        }
        if (videoCodecInfo.name.equalsIgnoreCase("VP9") && VP9Encoder.nativeIsSupported()) {
            i.d(TAG, "create soft ware encoder vp9: ");
            return new VP9Encoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoEncoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
        arrayList.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (VP9Encoder.nativeIsSupported()) {
            arrayList.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        return arrayList.toArray(new VideoCodecInfo[arrayList.size()]);
    }
}

