/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.ucloudrtclib.a.i;
import com.ucloudrtclib.sdkengine.define.UCloudRtcSdkScaleType;
import com.ucloudrtclib.sdkengine.define.UCloudRtcSdkStreamInfo;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRTCDataReceiver;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRTCFirstFrameRendered;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.GlRectDrawer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceEglRenderer;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoSink;

public class SurfaceViewRenderer
extends SurfaceView
implements SurfaceHolder.Callback,
RendererCommon.RendererEvents,
VideoRenderer.Callbacks,
VideoSink {
    private static final String TAG = "SurfaceViewRenderer";
    private final String resourceName;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
    private final SurfaceEglRenderer eglRenderer;
    protected UCloudRtcSdkStreamInfo mStreamInfo;
    protected UCloudRTCFirstFrameRendered mFrameRendered;
    protected UCloudRTCFirstFrameRendered mPeerConectionCallBack;
    protected int mScaleType = -1;
    private RendererCommon.RendererEvents rendererEvents;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private boolean enableFixedSize;
    private int surfaceWidth;
    private int surfaceHeight;

    public SurfaceViewRenderer(Context context) {
        super(context);
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    public SurfaceViewRenderer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, UCloudRTCDataReceiver uCloudRTCDataReceiver) {
        this.init(context, rendererEvents, EglBase.CONFIG_PLAIN, new GlRectDrawer(), uCloudRTCDataReceiver);
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer, UCloudRTCDataReceiver uCloudRTCDataReceiver) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        i.d(TAG, "surfaceViewRenderer renderEvents = " + rendererEvents + "this: " + this);
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init(context, this, nArray, glDrawer, uCloudRTCDataReceiver);
    }

    public void release() {
        i.d(TAG, "release surfaceviewrender");
        this.eglRenderer.release();
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer) {
        this.eglRenderer.addFrameListener(frameListener, f2, glDrawer);
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f2) {
        this.eglRenderer.addFrameListener(frameListener, f2);
    }

    public void removeFrameListener(EglRenderer.FrameListener frameListener) {
        this.eglRenderer.removeFrameListener(frameListener);
    }

    public void setEnableHardwareScaler(boolean bl) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = bl;
        this.updateSurfaceSize();
    }

    public void setMirror(boolean bl) {
        this.eglRenderer.setMirror(bl);
    }

    public void setScalingType(RendererCommon.ScalingType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingType);
        this.requestLayout();
    }

    public void setScalingType(RendererCommon.ScalingType scalingType, RendererCommon.ScalingType scalingType2) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingType, scalingType2);
        i.d(TAG, "surfaceview render setScaleType: " + (Object)((Object)scalingType2));
        this.requestLayout();
    }

    public void setFpsReduction(float f2) {
        this.eglRenderer.setFpsReduction(f2);
    }

    public void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    public void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    @Override
    public void renderFrame(VideoRenderer.I420Frame i420Frame) {
        this.eglRenderer.renderFrame(i420Frame);
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        this.eglRenderer.onFrame(videoFrame);
    }

    protected void onMeasure(int n2, int n3) {
        ThreadUtils.checkIsOnMainThread();
        Point point = this.videoLayoutMeasure.measure(n2, n3, this.rotatedFrameWidth, this.rotatedFrameHeight);
        this.setMeasuredDimension(point.x, point.y);
        i.d(TAG, "SurfaceViewRendereronMeasure(). New size: " + point.x + "x" + point.y);
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mScaleType == UCloudRtcSdkScaleType.UCLOUD_RTC_SDK_SCALE_FILL.ordinal()) {
            this.eglRenderer.setLayoutAspectRatio(-100.0f);
        } else {
            this.eglRenderer.setLayoutAspectRatio((float)(n4 - n2) / (float)(n5 - n3));
        }
        this.updateSurfaceSize();
    }

    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
            int n2;
            int n3;
            float f2 = (float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight;
            float f3 = (float)this.getWidth() / (float)this.getHeight();
            if (f2 > f3) {
                n3 = (int)((float)this.rotatedFrameHeight * f3);
                n2 = this.rotatedFrameHeight;
            } else {
                n3 = this.rotatedFrameWidth;
                n2 = (int)((float)this.rotatedFrameWidth / f3);
            }
            int n4 = Math.min(this.getWidth(), n3);
            int n5 = Math.min(this.getHeight(), n2);
            i.d(TAG, "SurfaceViewRendererupdateSurfaceSize. Layout size: " + this.getWidth() + "x" + this.getHeight() + ", frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + n4 + "x" + n5 + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
            if (n4 != this.surfaceWidth || n5 != this.surfaceHeight) {
                this.surfaceWidth = n4;
                this.surfaceHeight = n5;
                this.getHolder().setFixedSize(n4, n5);
            }
        } else {
            this.surfaceHeight = 0;
            this.surfaceWidth = 0;
            this.getHolder().setSizeFromLayout();
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
        this.updateSurfaceSize();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId());
        }
        catch (Resources.NotFoundException notFoundException) {
            return "";
        }
    }

    public void clearImage() {
        this.eglRenderer.clearImage();
    }

    @Override
    public void onFirstFrameRendered() {
        if (this.rendererEvents != null && this.rendererEvents != this) {
            this.rendererEvents.onFirstFrameRendered();
        }
    }

    @Override
    public void onFrameResolutionChanged(int n2, int n3, int n4) {
        if (this.rendererEvents != null) {
            this.rendererEvents.onFrameResolutionChanged(n2, n3, n4);
        }
        int n5 = n4 == 0 || n4 == 180 ? n2 : n3;
        int n6 = n4 == 0 || n4 == 180 ? n3 : n2;
        this.postOrRun(() -> {
            this.rotatedFrameWidth = n5;
            this.rotatedFrameHeight = n6;
            this.updateSurfaceSize();
            this.requestLayout();
        });
    }

    private void postOrRun(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            this.post(runnable);
        }
    }

    public UCloudRtcSdkStreamInfo getStreamInfo() {
        return this.mStreamInfo;
    }

    public void setStreamInfo(UCloudRtcSdkStreamInfo uCloudRtcSdkStreamInfo) {
        this.mStreamInfo = uCloudRtcSdkStreamInfo;
    }

    public void setFrameRendered(UCloudRTCFirstFrameRendered uCloudRTCFirstFrameRendered) {
        this.mFrameRendered = uCloudRTCFirstFrameRendered;
    }

    public void setPeerConectionCallBack(UCloudRTCFirstFrameRendered uCloudRTCFirstFrameRendered) {
        this.mPeerConectionCallBack = uCloudRTCFirstFrameRendered;
    }

    private void logD(String string) {
        Logging.d(TAG, this.resourceName + ": " + string);
    }
}

