/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.SurfaceTexture;
import android.view.TextureView;
import com.ucloudrtclib.a.i;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRTCDataReceiver;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.JavaI420Buffer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoRenderer;
import org.webrtc.YuvHelper;

public class TextureEglRenderer
extends EglRenderer
implements TextureView.SurfaceTextureListener {
    private static final String TAG = "TextureEglRenderer";
    private final Object layoutLock = new Object();
    private boolean isRenderingPaused = false;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private int frameRotation;
    private UCloudRTCDataReceiver mDataReceiver;

    public TextureEglRenderer(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer, UCloudRTCDataReceiver uCloudRTCDataReceiver) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        this.mDataReceiver = uCloudRTCDataReceiver;
        Object object = this.layoutLock;
        synchronized (object) {
            this.isFirstFrameRendered = false;
            this.rotatedFrameWidth = 0;
            this.rotatedFrameHeight = 0;
            this.frameRotation = 0;
        }
        super.init(context, nArray, glDrawer, rendererEvents);
    }

    @Override
    public void init(EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer, RendererCommon.RendererEvents rendererEvents) {
        this.init(context, rendererEvents, nArray, glDrawer, this.mDataReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFpsReduction(float f2) {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = f2 == 0.0f;
        }
        super.setFpsReduction(f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableFpsReduction() {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = false;
        }
        super.disableFpsReduction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseVideo() {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = true;
        }
        super.pauseVideo();
    }

    @Override
    public void renderFrame(VideoRenderer.I420Frame i420Frame) {
        this.updateFrameDimensionsAndReportEvents(i420Frame);
        super.renderFrame(i420Frame);
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        this.updateFrameDimensionsAndReportEvents(videoFrame);
        if (this.mDataReceiver != null) {
            VideoFrame.Buffer buffer = videoFrame.getBuffer();
            if (buffer instanceof JavaI420Buffer) {
                JavaI420Buffer javaI420Buffer = (JavaI420Buffer)buffer;
                int n2 = ((this.mDataReceiver.getType() & 0xF0) >> 4) * javaI420Buffer.getWidth() * javaI420Buffer.getHeight();
                ByteBuffer byteBuffer = this.mDataReceiver.getCacheBuffer();
                byteBuffer.limit(n2);
                YuvHelper.I420ToRgba(this.mDataReceiver.getType(), buffer.getWidth(), buffer.getHeight(), javaI420Buffer.getDataY(), javaI420Buffer.getStrideY(), javaI420Buffer.getDataU(), javaI420Buffer.getStrideU(), javaI420Buffer.getDataV(), javaI420Buffer.getStrideV(), byteBuffer);
                this.mDataReceiver.onReceiveRGBAData(byteBuffer, javaI420Buffer.getWidth(), javaI420Buffer.getHeight());
            }
            videoFrame.release();
        } else {
            super.onFrame(videoFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrameDimensionsAndReportEvents(VideoRenderer.I420Frame i420Frame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.isRenderingPaused) {
                return;
            }
            if (this.rotatedFrameWidth != i420Frame.rotatedWidth() || this.rotatedFrameHeight != i420Frame.rotatedHeight() || this.frameRotation != i420Frame.rotationDegree) {
                i.d(TAG, "Reporting frame resolution changed to " + i420Frame.width + "x" + i420Frame.height + " with rotation " + i420Frame.rotationDegree);
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(i420Frame.width, i420Frame.height, i420Frame.rotationDegree);
                }
                this.rotatedFrameWidth = i420Frame.rotatedWidth();
                this.rotatedFrameHeight = i420Frame.rotatedHeight();
                this.frameRotation = i420Frame.rotationDegree;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrameDimensionsAndReportEvents(VideoFrame videoFrame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.isRenderingPaused) {
                return;
            }
            if (this.rotatedFrameWidth != videoFrame.getRotatedWidth() || this.rotatedFrameHeight != videoFrame.getRotatedHeight() || this.frameRotation != videoFrame.getRotation()) {
                this.logD("Reporting frame resolution changed to " + videoFrame.getBuffer().getWidth() + "x" + videoFrame.getBuffer().getHeight() + " with rotation " + videoFrame.getRotation());
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(videoFrame.getBuffer().getWidth(), videoFrame.getBuffer().getHeight(), videoFrame.getRotation());
                }
                this.rotatedFrameWidth = videoFrame.getRotatedWidth();
                this.rotatedFrameHeight = videoFrame.getRotatedHeight();
                this.frameRotation = videoFrame.getRotation();
            }
        }
    }

    private void logD(String string) {
        Logging.d(TAG, this.name + ": " + string);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
        i.d(TAG, " TextureEglRenderer onSurfaceTextureAvailable surface: " + surfaceTexture + "width: " + n2 + " height: " + n3);
        ThreadUtils.checkIsOnMainThread();
        this.createEglSurface(surfaceTexture);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
        i.d(TAG, " TextureEglRenderer onSurfaceTextureSizeChanged surface: " + surfaceTexture + "width: " + n2 + " height: " + n3);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        i.d(TAG, " TextureEglRenderer onSurfaceTextureDestroyed surface: " + surfaceTexture);
        ThreadUtils.checkIsOnMainThread();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.releaseEglSurface(countDownLatch::countDown);
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }
}

