/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Looper;
import android.view.TextureView;
import android.view.View;
import com.ucloudrtclib.a.i;
import com.ucloudrtclib.d.d;
import com.ucloudrtclib.sdkengine.define.UCloudRtcSdkScaleType;
import com.ucloudrtclib.sdkengine.define.UCloudRtcSdkStreamInfo;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRTCDataReceiver;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRTCFirstFrameRendered;
import java.util.Objects;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.GlRectDrawer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.TextureEglRenderer;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoSink;
import org.webrtc.ucloud.record.MediaRecorderNative;
import org.webrtc.ucloud.record.model.CameraParamObserver;

public class TextureViewRenderer
implements TextureView.SurfaceTextureListener,
RendererCommon.RendererEvents,
VideoRenderer.Callbacks,
VideoSink {
    private static final String TAG = "TextureViewRenderer";
    protected TextureView mTextureView;
    protected final String resourceName;
    protected final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
    private final TextureEglRenderer eglRenderer;
    protected UCloudRtcSdkStreamInfo mStreamInfo;
    protected UCloudRTCFirstFrameRendered mFrameRenderedCallBack;
    protected UCloudRTCFirstFrameRendered mPeerConnectionCallBack;
    protected RendererCommon.RendererEvents rendererEvents;
    protected int mScaleType = UCloudRtcSdkScaleType.UCLOUD_RTC_SDK_SCALE_ASPECT_FILL.ordinal();
    protected int rotatedFrameWidth;
    protected int rotatedFrameHeight;
    protected boolean enableFixedSize;
    protected int surfaceWidth;
    protected int surfaceHeight;
    private CameraParamObserver mParamObserver;

    public TextureViewRenderer(TextureView textureView) {
        this.mTextureView = textureView;
        this.resourceName = this.getResourceName();
        this.eglRenderer = new TextureEglRenderer(this.resourceName);
        this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.eglRenderer);
        this.mTextureView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
                i.d(TextureViewRenderer.TAG, "new width  " + (n4 - n2) + " old width: " + (n8 - n6));
                i.d(TextureViewRenderer.TAG, "new height  " + (n5 - n3) + " old height: " + (n9 - n7));
                TextureViewRenderer.this.initTextureViewMatrix();
            }
        });
        this.mParamObserver = MediaRecorderNative.cameraParamObserver;
    }

    public void setScaleType(int n2) {
        this.mScaleType = n2;
        this.postOrRun(() -> {
            if (this.mTextureView != null && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.mTextureView.getWidth() > 0 && this.mTextureView.getHeight() > 0) {
                this.initTextureViewMatrix();
                this.mTextureView.requestLayout();
            } else {
                i.d(TAG, "TextureViewRendererinitTextureViewMatrix failed for " + this.mTextureView + "viewWidth: " + this.mTextureView.getWidth() + "viewHeight: " + this.mTextureView.getHeight() + "frameWidth: " + this.rotatedFrameWidth + "frameHeight: " + this.rotatedFrameHeight);
            }
        });
        i.d(TAG, "TextureViewRenderersetScaleType: " + this.mScaleType);
    }

    private void initTextureViewMatrix() {
        i.d(TAG, "TextureViewRendererscaleType: " + this.mScaleType);
        if (this.mScaleType == UCloudRtcSdkScaleType.UCLOUD_RTC_SDK_SCALE_FILL.ordinal()) {
            Matrix matrix = new Matrix();
            this.mTextureView.setTransform(matrix);
        } else {
            int n2 = this.mTextureView.getWidth();
            int n3 = this.mTextureView.getHeight();
            int n4 = 0;
            int n5 = 0;
            if (this.mScaleType == UCloudRtcSdkScaleType.UCLOUD_RTC_SDK_SCALE_ASPECT_FILL.ordinal()) {
                RectF rectF = new RectF(0.0f, 0.0f, (float)n2, (float)n3);
                double d2 = (double)this.rotatedFrameWidth / (double)this.rotatedFrameHeight;
                double d3 = (double)n2 / (double)n3;
                i.d(TAG, "TextureViewRenderer : frameWidth:" + this.rotatedFrameWidth + " frameHeight: " + this.rotatedFrameHeight);
                i.d(TAG, "TextureViewRenderer : viewWidth:" + n2 + " viewHeight: " + n3);
                int n6 = 0;
                int n7 = 0;
                if (d2 > 1.0) {
                    if (d3 > d2) {
                        n4 = n2;
                        n5 = (int)((double)n4 / d2 + 0.5);
                        n7 = -(n5 - n3) / 2;
                    } else {
                        n5 = n3;
                        n4 = (int)((double)n5 * d2 + 0.5);
                        n6 = -(n4 - n2) / 2;
                    }
                } else if (d3 > d2) {
                    n4 = n2;
                    n5 = (int)((double)n4 / d2 + 0.5);
                    n7 = -(n5 - n3) / 2;
                } else {
                    n5 = n3;
                    n4 = (int)((double)n5 * d2 + 0.5);
                    n6 = -(n4 - n2) / 2;
                }
                i.d(TAG, "TextureViewRenderer : displayWidth:" + n4 + " displayHeight: " + n5);
                i.d(TAG, "TextureViewRenderer : left:" + n6 + " top: " + n7);
                RectF rectF2 = new RectF((float)n6, (float)n7, (float)(n4 + n6), (float)(n5 + n7));
                Matrix matrix = new Matrix();
                matrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.FILL);
                this.mTextureView.setTransform(matrix);
            } else if (this.mScaleType == UCloudRtcSdkScaleType.UCLOUD_RTC_SDK_SCALE_ASPECT_FIT.ordinal()) {
                RectF rectF = new RectF(0.0f, 0.0f, (float)n2, (float)n3);
                double d4 = (double)this.rotatedFrameWidth / (double)this.rotatedFrameHeight;
                double d5 = (double)n2 / (double)n3;
                i.d(TAG, "TextureViewRenderer : frameWidth:" + this.rotatedFrameWidth + " frameHeight: " + this.rotatedFrameHeight);
                i.d(TAG, "TextureViewRenderer : viewWidth:" + n2 + " viewHeight: " + n3);
                int n8 = 0;
                int n9 = 0;
                if (d4 > 1.0) {
                    if (d5 > d4) {
                        n5 = n3;
                        n4 = (int)((double)n5 * d4 + 0.5);
                        n8 = (n2 - n4) / 2;
                    } else {
                        n4 = n2;
                        n5 = (int)((double)n4 / d4 + 0.5);
                        n9 = (n3 - n5) / 2;
                    }
                } else if (d5 > d4) {
                    n5 = n3;
                    n4 = (int)((double)n5 * d4 + 0.5);
                    n8 = (n2 - n4) / 2;
                } else {
                    n4 = n2;
                    n5 = (int)((double)n4 / d4 + 0.5);
                    n9 = (n3 - n5) / 2;
                }
                i.d(TAG, "TextureViewRenderer : displayWidth:" + n4 + " displayHeight: " + n5);
                i.d(TAG, "TextureViewRenderer : left:" + n8 + " top: " + n9);
                RectF rectF3 = new RectF((float)n8, (float)n9, (float)(n4 + n8), (float)(n5 + n9));
                Matrix matrix = new Matrix();
                matrix.setRectToRect(rectF, rectF3, Matrix.ScaleToFit.FILL);
                this.mTextureView.setTransform(matrix);
            }
        }
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, UCloudRTCDataReceiver uCloudRTCDataReceiver) {
        this.init(context, rendererEvents, EglBase.CONFIG_PLAIN, new GlRectDrawer(), uCloudRTCDataReceiver);
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer, UCloudRTCDataReceiver uCloudRTCDataReceiver) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init(context, this, nArray, glDrawer, uCloudRTCDataReceiver);
    }

    public void release() {
        i.d(TAG, "TextureViewRenderer release: +mTextureView: " + this.mTextureView);
        if (this.mTextureView != null) {
            this.eglRenderer.release();
        }
    }

    public void initEgl(final boolean bl, final boolean bl2) {
        i.d(TAG, "TextureViewRenderer : mTextureView : " + this.mTextureView);
        if (this.mTextureView != null) {
            this.mTextureView.post(new Runnable(){

                @Override
                public void run() {
                    i.d(TextureViewRenderer.TAG, "start to init egl context\uff1b " + bl + "_surfaceContext: " + bl2);
                    if (!bl) {
                        i.d(TextureViewRenderer.TAG, "TextureViewRenderer : initEglBase:");
                        TextureViewRenderer.this.init(d.dn().dp(), null, null);
                    }
                    if (!bl2) {
                        i.d(TextureViewRenderer.TAG, "TextureViewRenderer : initEglSurface:" + TextureViewRenderer.this.mTextureView.getSurfaceTexture());
                        if (TextureViewRenderer.this.mTextureView.getSurfaceTexture() != null) {
                            TextureViewRenderer.this.createEglSurface(TextureViewRenderer.this.mTextureView.getSurfaceTexture());
                        } else {
                            i.d(TextureViewRenderer.TAG, "TextureViewRenderer initEglSurface quit for texture is null");
                        }
                    }
                }
            });
        } else {
            i.d(TAG, "TextureViewRenderer : mTextureView = null:");
        }
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer) {
        this.eglRenderer.addFrameListener(frameListener, f2, glDrawer);
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f2) {
        this.eglRenderer.addFrameListener(frameListener, f2);
    }

    public void removeFrameListener(EglRenderer.FrameListener frameListener) {
        this.eglRenderer.removeFrameListener(frameListener);
    }

    public void setEnableHardwareScaler(boolean bl) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = bl;
        this.updateSurfaceSize();
    }

    public void setMirror(boolean bl) {
        this.eglRenderer.setMirror(bl);
    }

    public void setScalingType(RendererCommon.ScalingType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingType);
    }

    public void setScalingType(RendererCommon.ScalingType scalingType, RendererCommon.ScalingType scalingType2) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingType, scalingType2);
    }

    public void setFpsReduction(float f2) {
        this.eglRenderer.setFpsReduction(f2);
    }

    public void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    public void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    @Override
    public void renderFrame(VideoRenderer.I420Frame i420Frame) {
        this.eglRenderer.renderFrame(i420Frame);
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        this.eglRenderer.onFrame(videoFrame);
    }

    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.mTextureView.getWidth() != 0 && this.mTextureView.getHeight() != 0) {
            int n2;
            int n3;
            float f2 = (float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight;
            float f3 = (float)this.mTextureView.getWidth() / (float)this.mTextureView.getHeight();
            if (f2 > f3) {
                n3 = (int)((float)this.rotatedFrameHeight * f3);
                n2 = this.rotatedFrameHeight;
            } else {
                n3 = this.rotatedFrameWidth;
                n2 = (int)((float)this.rotatedFrameWidth / f3);
            }
            int n4 = Math.min(this.mTextureView.getWidth(), n3);
            int n5 = Math.min(this.mTextureView.getHeight(), n2);
            this.logD("updateSurfaceSize. Layout size: " + this.mTextureView.getWidth() + "x" + this.mTextureView.getHeight() + ", frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + n4 + "x" + n5 + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
            if (n4 != this.surfaceWidth || n5 != this.surfaceHeight) {
                this.surfaceWidth = n4;
                this.surfaceHeight = n5;
            }
        } else {
            this.surfaceHeight = 0;
            this.surfaceWidth = 0;
        }
    }

    private String getResourceName() {
        try {
            return this.mTextureView.getResources().getResourceEntryName(this.mTextureView.getId()) + "_" + Integer.toHexString(this.mTextureView.hashCode());
        }
        catch (Resources.NotFoundException notFoundException) {
            return "";
        }
    }

    public void clearImage() {
        if (this.mTextureView != null) {
            this.mTextureView.post(new Runnable(){

                @Override
                public void run() {
                    TextureViewRenderer.this.eglRenderer.clearImage();
                }
            });
        }
    }

    @Override
    public void onFirstFrameRendered() {
        if (this.mFrameRenderedCallBack != null) {
            i.d(TAG, "TextureViewRendereronFirstFrameRendered: " + this.mStreamInfo + "view: " + this.mTextureView);
            this.mFrameRenderedCallBack.onFirstFrameRender(this.mStreamInfo, (View)this.mTextureView);
        }
        if (this.mPeerConnectionCallBack != null) {
            this.mPeerConnectionCallBack.onFirstFrameRender(this.mStreamInfo, (View)this.mTextureView);
        }
        if (this.rendererEvents != null && this.rendererEvents != this) {
            this.rendererEvents.onFirstFrameRendered();
        }
    }

    @Override
    public void onFrameResolutionChanged(int n2, int n3, int n4) {
        i.d(TAG, "TextureViewRenderer :" + this.mTextureView + " videoWidth:" + n2 + " videoHeight: " + n3 + " rotation: " + n4);
        int n5 = n4 == 0 || n4 == 180 ? n2 : n3;
        int n6 = n4 == 0 || n4 == 180 ? n3 : n2;
        this.postOrRun(() -> {
            this.rotatedFrameWidth = n5;
            this.rotatedFrameHeight = n6;
            this.initTextureViewMatrix();
            this.mTextureView.requestLayout();
        });
    }

    private void postOrRun(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            this.mTextureView.post(runnable);
        }
    }

    private void logD(String string) {
        Logging.d(TAG, this.resourceName + ": " + string);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
        i.d(TAG, "TextureViewRenderer onSurfaceTextureAvailable surface: " + surfaceTexture + " width: " + n2 + "height: " + n3);
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
        i.d(TAG, " TextureViewRenderer onSurfaceTextureSizeChanged surface: " + surfaceTexture);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        i.d(TAG, " TextureViewRenderer onSurfaceTextureDestroyed surface: " + surfaceTexture);
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    public void createEglSurface(SurfaceTexture surfaceTexture) {
        this.eglRenderer.createEglSurface(surfaceTexture);
    }

    public void requestEglState(EglRenderer.RequestEglInit requestEglInit) {
        this.eglRenderer.isInitEgl(requestEglInit);
    }

    public TextureView getTextureView() {
        return this.mTextureView;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextureViewRenderer textureViewRenderer = (TextureViewRenderer)object;
        if (Build.VERSION.SDK_INT >= 19) {
            return Objects.equals(this.mTextureView, textureViewRenderer.mTextureView);
        }
        return this.mTextureView.equals(textureViewRenderer.mTextureView);
    }

    public int hashCode() {
        if (Build.VERSION.SDK_INT >= 19) {
            return Objects.hash(this.mTextureView);
        }
        return this.mTextureView.hashCode();
    }

    public UCloudRtcSdkStreamInfo getStreamInfo() {
        return this.mStreamInfo;
    }

    public void setStreamInfo(UCloudRtcSdkStreamInfo uCloudRtcSdkStreamInfo) {
        this.mStreamInfo = uCloudRtcSdkStreamInfo;
        i.d(TAG, " tvrender" + this + " setStreamInfo " + uCloudRtcSdkStreamInfo);
    }

    public void setFrameRenderedCallBack(UCloudRTCFirstFrameRendered uCloudRTCFirstFrameRendered) {
        this.mFrameRenderedCallBack = uCloudRTCFirstFrameRendered;
    }

    public void setPeerConnectionCallBack(UCloudRTCFirstFrameRendered uCloudRTCFirstFrameRendered) {
        this.mPeerConnectionCallBack = uCloudRTCFirstFrameRendered;
    }

    public String toString() {
        return "TextureViewRenderer{mTextureView=" + this.mTextureView + '}';
    }
}

