/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    public static void checkIsOnMainThread() {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new IllegalStateException("Not on main thread!");
        }
    }

    public static void executeUninterruptibly(BlockingOperation blockingOperation) {
        boolean bl = false;
        while (true) {
            try {
                blockingOperation.run();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean joinUninterruptibly(Thread thread, long l2) {
        long l3 = SystemClock.elapsedRealtime();
        long l4 = l2;
        boolean bl = false;
        while (l4 > 0L) {
            try {
                thread.join(l4);
                break;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                long l5 = SystemClock.elapsedRealtime() - l3;
                l4 = l2 - l5;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return !thread.isAlive();
    }

    public static void joinUninterruptibly(final Thread thread) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() {
                thread.join();
            }
        });
    }

    public static void awaitUninterruptibly(final CountDownLatch countDownLatch) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() {
                countDownLatch.await();
            }
        });
    }

    public static boolean awaitUninterruptibly(CountDownLatch countDownLatch, long l2) {
        long l3 = SystemClock.elapsedRealtime();
        long l4 = l2;
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            try {
                bl2 = countDownLatch.await(l4, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                long l5;
                bl = true;
                if ((l4 = l2 - (l5 = SystemClock.elapsedRealtime() - l3)) > 0L) continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return bl2;
    }

    public static <V> V invokeAtFrontUninterruptibly(Handler handler, final Callable<V> callable) {
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        class Result {
            public V value;

            Result() {
            }
        }
        final Result result = new Result();
        class CaughtException {
            Exception e;

            CaughtException() {
            }
        }
        final CaughtException caughtException = new CaughtException();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        handler.post(new Runnable(){
            {
            }

            @Override
            public void run() {
                try {
                    result.value = callable.call();
                }
                catch (Exception exception) {
                    caughtException.e = exception;
                }
                countDownLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        if (caughtException.e != null) {
            RuntimeException runtimeException = new RuntimeException(caughtException.e);
            runtimeException.setStackTrace(ThreadUtils.concatStackTraces(caughtException.e.getStackTrace(), runtimeException.getStackTrace()));
            throw runtimeException;
        }
        return result.value;
    }

    public static void invokeAtFrontUninterruptibly(Handler handler, final Runnable runnable) {
        ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Void>(){

            @Override
            public Void call() {
                runnable.run();
                return null;
            }
        });
    }

    static StackTraceElement[] concatStackTraces(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        StackTraceElement[] stackTraceElementArray3 = new StackTraceElement[stackTraceElementArray.length + stackTraceElementArray2.length];
        System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray3, 0, stackTraceElementArray.length);
        System.arraycopy(stackTraceElementArray2, 0, stackTraceElementArray3, stackTraceElementArray.length, stackTraceElementArray2.length);
        return stackTraceElementArray3;
    }

    public static interface BlockingOperation {
        public void run();
    }

    public static class ThreadChecker {
        private Thread thread = Thread.currentThread();

        public void checkIsOnValidThread() {
            if (this.thread == null) {
                this.thread = Thread.currentThread();
            }
            if (Thread.currentThread() != this.thread) {
                throw new IllegalStateException("Wrong thread");
            }
        }

        public void detachThread() {
            this.thread = null;
        }
    }
}

