/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import com.ucloudrtclib.sdkengine.UCloudRtcSdkEnv;
import org.webrtc.CalledByNative;
import org.webrtc.CameraSession;
import org.webrtc.JNINamespace;
import org.webrtc.URTCCameraRTSPSession;
import org.webrtc.VideoFrame;
import org.webrtc.WrappedNativeI420Buffer;

@JNINamespace(value="webrtc::jni")
public class URTCCameraRTSP {
    private URTCCameraRTSPSession.RTSPCameraFormat mRTSPCameraFormat;
    private String mUrl;
    private URTCCameraRTSPSession mCameraSession;
    private CameraSession.Events mEvents;

    public URTCCameraRTSP(String string, URTCCameraRTSPSession.RTSPCameraFormat rTSPCameraFormat, URTCCameraRTSPSession uRTCCameraRTSPSession) {
        this.mRTSPCameraFormat = rTSPCameraFormat;
        this.mUrl = string;
        this.mCameraSession = uRTCCameraRTSPSession;
        this.mEvents = this.mCameraSession.getEvents();
        this.nativeInitCamera(string, this.mRTSPCameraFormat.mOutputFormat.ordinal(), this.mRTSPCameraFormat.mWidth, this.mRTSPCameraFormat.mHeight, this.mRTSPCameraFormat.mFrameRate);
        this.startCapturing();
    }

    public int startCapturing() {
        return this.nativeStartCapturing();
    }

    public int stopCapturing() {
        return this.nativeStopCapturing();
    }

    private native int nativeInitCamera(String var1, int var2, int var3, int var4, int var5);

    private native int nativeStartCapturing();

    private native int nativeStopCapturing();

    @CalledByNative
    void onPreviewData(WrappedNativeI420Buffer wrappedNativeI420Buffer, int n2, long l2) {
        if (this.mCameraSession != null && this.mEvents != null) {
            VideoFrame videoFrame = new VideoFrame(wrappedNativeI420Buffer, n2, l2);
            this.mEvents.onFrameCaptured(this.mCameraSession, videoFrame, UCloudRtcSdkEnv.isFrontCameraMirror());
        }
    }
}

