/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.os.Handler;
import org.webrtc.CameraSession;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.URTCCameraRTSP;

public class URTCCameraRTSPSession
implements CameraSession {
    private final CameraSession.Events events;
    private final Context applicationContext;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final int cameraId;
    private int mWidth;
    private int mHeight;
    private int mFrameRate;
    private final Handler cameraThreadHandler = new Handler();
    private URTCCameraRTSP mCamera;
    private SessionState state;

    URTCCameraRTSPSession(CameraSession.Events events, Context context, URTCCameraRTSP uRTCCameraRTSP, SurfaceTextureHelper surfaceTextureHelper, int n2, int n3, int n4, int n5) {
        this.events = events;
        this.applicationContext = context;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = n2;
        this.mWidth = n3;
        this.mHeight = n4;
        this.mFrameRate = n5;
        this.mCamera = uRTCCameraRTSP;
    }

    public static void create(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context context, SurfaceTextureHelper surfaceTextureHelper, String string, int n2, RTSPCameraDataFormat rTSPCameraDataFormat, int n3, int n4, int n5) {
        RTSPCameraFormat rTSPCameraFormat = new RTSPCameraFormat(rTSPCameraDataFormat, n3, n4, n5);
        URTCCameraRTSPSession uRTCCameraRTSPSession = new URTCCameraRTSPSession(events, context, null, surfaceTextureHelper, n2, n3, n4, n5);
        URTCCameraRTSP uRTCCameraRTSP = new URTCCameraRTSP(string, rTSPCameraFormat, uRTCCameraRTSPSession);
        uRTCCameraRTSPSession.setCamera(uRTCCameraRTSP);
        createSessionCallback.onDone(uRTCCameraRTSPSession);
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong RTSP Camera thread");
        }
    }

    public void setCamera(URTCCameraRTSP uRTCCameraRTSP) {
        this.mCamera = uRTCCameraRTSP;
    }

    public CameraSession.Events getEvents() {
        return this.events;
    }

    @Override
    public CameraSession.CameraParam requestCamera() {
        return null;
    }

    @Override
    public void stop() {
    }

    static class RTSPCameraFormat {
        RTSPCameraDataFormat mOutputFormat;
        int mWidth;
        int mHeight;
        int mFrameRate;

        public RTSPCameraFormat(RTSPCameraDataFormat rTSPCameraDataFormat, int n2, int n3, int n4) {
            this.mOutputFormat = rTSPCameraDataFormat;
            this.mWidth = n2;
            this.mHeight = n3;
            this.mFrameRate = n4;
        }
    }

    public static enum RTSPCameraDataFormat {
        NV_21,
        I420;

    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

