/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import com.ucloudrtclib.a.i;
import com.ucloudrtclib.sdkengine.listener.UCloudRtcRecordListener;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRtcAudioResample;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.webrtc.CalledByNative;
import org.webrtc.JNINamespace;

@JNINamespace(value="webrtc::jni")
public class URTCFFmpegBridge {
    private static final String TAG = "URTCFFmpegBridge";
    public static long period = 2000L;
    private static ArrayList<FFmpegStateListener> listeners = new ArrayList();
    private static ArrayList<UCloudRtcRecordListener> recordListeners = new ArrayList();
    private static ArrayList<UCloudRtcAudioResample> resampleListeners = new ArrayList();
    private static Map<UCloudRtcRecordListener, Timer> timers = new HashMap<UCloudRtcRecordListener, Timer>();
    private static FileOutputStream mPcmOutputStream = null;
    public static final int ALL_RECORD_END = 1;
    public static final int ROTATE_0_CROP_LF = 0;
    public static final int ROTATE_90_CROP_LT = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_270_CROP_LT_MIRROR_LR = 3;

    public static native int nativeEncodeFrame2H264(byte[] var0);

    public static native int nativeEncodeFrame2AAC(byte[] var0);

    public static native int nativeRecordEnd();

    public static native void nativeInitFFmpeg(boolean var0, String var1);

    public static native void nativeRelease();

    public static native int nativePrepareFFmpegEncoder(String var0, String var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static native void nativeSwitchAudioResample(boolean var0);

    public static native int nativeGetDuration();

    @CalledByNative
    public static void startRecordResult(final String string, int n2, String string2) {
        i.d(TAG, "bridge start record: " + string + "code: " + n2 + "msg " + string2);
        for (final UCloudRtcRecordListener uCloudRtcRecordListener : recordListeners) {
            if (uCloudRtcRecordListener == null) continue;
            uCloudRtcRecordListener.onLocalRecordStart(string, n2, string2);
            if (timers.get(uCloudRtcRecordListener) == null) continue;
            timers.get(uCloudRtcRecordListener).schedule(new TimerTask(){

                @Override
                public void run() {
                    File file = new File(string);
                    uCloudRtcRecordListener.onRecordStatusCallBack(URTCFFmpegBridge.nativeGetDuration(), file.length());
                }
            }, 0L, period);
        }
    }

    @CalledByNative
    public static void stopRecord(String string, int n2) {
        i.d(TAG, "bridge receive record stop: " + string);
        for (UCloudRtcRecordListener uCloudRtcRecordListener : recordListeners) {
            File file;
            if (uCloudRtcRecordListener == null || !(file = new File(string)).exists()) continue;
            uCloudRtcRecordListener.onLocalRecordStop(string, file.length(), n2);
            timers.get(uCloudRtcRecordListener).cancel();
        }
        recordListeners.clear();
        timers.clear();
    }

    @CalledByNative
    public static void reportError(int n2) {
        i.d(TAG, "recordFailed for : " + n2);
    }

    @CalledByNative
    public static void audioResample(byte[] byArray, int n2, int n3, int n4, int n5) {
        if (byArray != null) {
            if (!resampleListeners.isEmpty()) {
                try {
                    if (mPcmOutputStream != null) {
                        mPcmOutputStream.write(byArray);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            for (UCloudRtcAudioResample uCloudRtcAudioResample : resampleListeners) {
                if (uCloudRtcAudioResample == null) continue;
                uCloudRtcAudioResample.onAudioRecordCallback(byArray, n2, n3, n4, n5);
            }
        }
    }

    public static synchronized void notifyState(int n2, float f2) {
        for (FFmpegStateListener fFmpegStateListener : listeners) {
            if (fFmpegStateListener == null || n2 != 1) continue;
            fFmpegStateListener.allRecordEnd();
        }
    }

    public static void registFFmpegStateListener(FFmpegStateListener fFmpegStateListener) {
        if (!listeners.contains(fFmpegStateListener)) {
            listeners.add(fFmpegStateListener);
        }
    }

    public static void registURTCRecordListener(UCloudRtcRecordListener uCloudRtcRecordListener) {
        if (!recordListeners.contains(uCloudRtcRecordListener)) {
            recordListeners.add(uCloudRtcRecordListener);
            timers.put(uCloudRtcRecordListener, new Timer("record" + uCloudRtcRecordListener));
        }
    }

    public static void registURTCAudioResampleListener(UCloudRtcAudioResample uCloudRtcAudioResample) {
        if (!resampleListeners.contains(uCloudRtcAudioResample)) {
            resampleListeners.add(uCloudRtcAudioResample);
        }
    }

    public static void clearURTCAudioResampleListener() {
        resampleListeners.clear();
    }

    public static void unRegistURTCAudioResampleListener(UCloudRtcAudioResample uCloudRtcAudioResample) {
        if (resampleListeners.contains(uCloudRtcAudioResample)) {
            resampleListeners.remove(uCloudRtcAudioResample);
        }
    }

    public static void unRegistURTCRecordListener(UCloudRtcRecordListener uCloudRtcRecordListener) {
        if (recordListeners.contains(uCloudRtcRecordListener)) {
            recordListeners.remove(uCloudRtcRecordListener);
            timers.remove(uCloudRtcRecordListener);
        }
    }

    public static void unRegistFFmpegStateListener(FFmpegStateListener fFmpegStateListener) {
        if (listeners.contains(fFmpegStateListener)) {
            listeners.remove(fFmpegStateListener);
        }
    }

    public static void setPcmOutputStream(FileOutputStream fileOutputStream) {
        mPcmOutputStream = fileOutputStream;
    }

    public static void flushPcmFileAndClearStream() {
        try {
            if (mPcmOutputStream != null) {
                mPcmOutputStream.flush();
                i.d(TAG, "URTCFFmpegBridgesave pcm finish ");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (mPcmOutputStream != null) {
                    mPcmOutputStream.close();
                    mPcmOutputStream = null;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static interface FFmpegStateListener {
        public void allRecordEnd();
    }
}

