/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.EncodedImage;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoFrame;

public interface VideoEncoder {
    @CalledByNative
    public VideoCodecStatus initEncode(Settings var1, Callback var2);

    @CalledByNative
    public VideoCodecStatus release();

    @CalledByNative
    public VideoCodecStatus encode(VideoFrame var1, EncodeInfo var2);

    @CalledByNative
    public VideoCodecStatus setChannelParameters(short var1, long var2);

    @CalledByNative
    public VideoCodecStatus setRateAllocation(BitrateAllocation var1, int var2);

    @CalledByNative
    public ScalingSettings getScalingSettings();

    @CalledByNative
    public String getImplementationName();

    public static interface Callback {
        public void onEncodedFrame(EncodedImage var1, CodecSpecificInfo var2);
    }

    public static class ScalingSettings {
        public final boolean on;
        public final Integer low;
        public final Integer high;
        public static final ScalingSettings OFF = new ScalingSettings();

        public ScalingSettings(int n2, int n3) {
            this.on = true;
            this.low = n2;
            this.high = n3;
        }

        private ScalingSettings() {
            this.on = false;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean bl) {
            this.on = bl;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean bl, int n2, int n3) {
            this.on = bl;
            this.low = n2;
            this.high = n3;
        }
    }

    public static class BitrateAllocation {
        public final int[][] bitratesBbs;

        @CalledByNative(value="BitrateAllocation")
        public BitrateAllocation(int[][] nArray) {
            this.bitratesBbs = nArray;
        }

        public int getSum() {
            int n2 = 0;
            int[][] nArray = this.bitratesBbs;
            int n3 = nArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                int[] nArray2;
                for (int n4 : nArray2 = nArray[i2]) {
                    n2 += n4;
                }
            }
            return n2;
        }
    }

    public static class CodecSpecificInfoH264
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP9
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP8
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfo {
    }

    public static class EncodeInfo {
        public final EncodedImage.FrameType[] frameTypes;

        @CalledByNative(value="EncodeInfo")
        public EncodeInfo(EncodedImage.FrameType[] frameTypeArray) {
            this.frameTypes = frameTypeArray;
        }
    }

    public static class Settings {
        public final int numberOfCores;
        public final int width;
        public final int height;
        public final int startBitrate;
        public final int maxFramerate;
        public final boolean automaticResizeOn;

        @CalledByNative(value="Settings")
        public Settings(int n2, int n3, int n4, int n5, int n6, boolean bl) {
            this.numberOfCores = n2;
            this.width = n3;
            this.height = n4;
            this.startBitrate = n5;
            this.maxFramerate = n6;
            this.automaticResizeOn = bl;
        }
    }
}

