/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.os.Handler;
import android.os.HandlerThread;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.webrtc.EglBase;
import org.webrtc.JNINamespace;
import org.webrtc.JniCommon;
import org.webrtc.Logging;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoSink;
import org.webrtc.YuvConverter;
import org.webrtc.YuvHelper;

@JNINamespace(value="webrtc::jni")
public class VideoFileRenderer
implements VideoRenderer.Callbacks,
VideoSink {
    private static final String TAG = "VideoFileRenderer";
    private final HandlerThread renderThread;
    private final Handler renderThreadHandler;
    private final FileOutputStream videoOutFile;
    private final String outputFileName;
    private final int outputFileWidth;
    private final int outputFileHeight;
    private final int outputFrameSize;
    private final ByteBuffer outputFrameBuffer;
    private EglBase eglBase;
    private YuvConverter yuvConverter;
    private ArrayList<ByteBuffer> rawFrames = new ArrayList();

    public VideoFileRenderer(String string, int n2, int n3, final EglBase.Context context) {
        if (n2 % 2 == 1 || n3 % 2 == 1) {
            throw new IllegalArgumentException("Does not support uneven width or height");
        }
        this.outputFileName = string;
        this.outputFileWidth = n2;
        this.outputFileHeight = n3;
        this.outputFrameSize = n2 * n3 * 3 / 2;
        this.outputFrameBuffer = ByteBuffer.allocateDirect(this.outputFrameSize);
        this.videoOutFile = new FileOutputStream(string);
        this.videoOutFile.write(("YUV4MPEG2 C420 W" + n2 + " H" + n3 + " Ip F30:1 A1:1\n").getBytes(Charset.forName("US-ASCII")));
        this.renderThread = new HandlerThread(TAG);
        this.renderThread.start();
        this.renderThreadHandler = new Handler(this.renderThread.getLooper());
        ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, new Runnable(){

            @Override
            public void run() {
                VideoFileRenderer.this.eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER);
                VideoFileRenderer.this.eglBase.createDummyPbufferSurface();
                VideoFileRenderer.this.eglBase.makeCurrent();
                VideoFileRenderer.this.yuvConverter = new YuvConverter();
            }
        });
    }

    @Override
    public void renderFrame(VideoRenderer.I420Frame i420Frame) {
        VideoFrame videoFrame = i420Frame.toVideoFrame();
        this.onFrame(videoFrame);
        videoFrame.release();
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        videoFrame.retain();
        this.renderThreadHandler.post(() -> this.renderFrameOnRenderThread(videoFrame));
    }

    private void renderFrameOnRenderThread(VideoFrame videoFrame) {
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        int n2 = videoFrame.getRotation() % 180 == 0 ? this.outputFileWidth : this.outputFileHeight;
        int n3 = videoFrame.getRotation() % 180 == 0 ? this.outputFileHeight : this.outputFileWidth;
        float f2 = (float)buffer.getWidth() / (float)buffer.getHeight();
        float f3 = (float)n2 / (float)n3;
        int n4 = buffer.getWidth();
        int n5 = buffer.getHeight();
        if (f3 > f2) {
            n5 = (int)((float)n5 * (f2 / f3));
        } else {
            n4 = (int)((float)n4 * (f3 / f2));
        }
        int n6 = (buffer.getWidth() - n4) / 2;
        int n7 = (buffer.getHeight() - n5) / 2;
        VideoFrame.Buffer buffer2 = buffer.cropAndScale(n6, n7, n4, n5, n2, n3);
        videoFrame.release();
        VideoFrame.I420Buffer i420Buffer = buffer2.toI420();
        buffer2.release();
        ByteBuffer byteBuffer = JniCommon.nativeAllocateByteBuffer(this.outputFrameSize);
        YuvHelper.I420Rotate(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), byteBuffer, i420Buffer.getWidth(), i420Buffer.getHeight(), videoFrame.getRotation());
        i420Buffer.release();
        byteBuffer.rewind();
        this.rawFrames.add(byteBuffer);
    }

    public void release() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.renderThreadHandler.post(() -> {
            this.yuvConverter.release();
            this.eglBase.release();
            this.renderThread.quit();
            countDownLatch.countDown();
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        try {
            for (ByteBuffer byteBuffer : this.rawFrames) {
                this.videoOutFile.write("FRAME\n".getBytes(Charset.forName("US-ASCII")));
                byte[] byArray = new byte[this.outputFrameSize];
                byteBuffer.get(byArray);
                this.videoOutFile.write(byArray);
                JniCommon.nativeFreeByteBuffer(byteBuffer);
            }
            this.videoOutFile.close();
            Logging.d(TAG, "Video written to disk as " + this.outputFileName + ". Number frames are " + this.rawFrames.size() + " and the dimension of the frames are " + this.outputFileWidth + "x" + this.outputFileHeight + ".");
        }
        catch (IOException iOException) {
            Logging.e(TAG, "Error writing video to disk", iOException);
        }
    }
}

